/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.verifiedsenders;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.ErrorResponse;
import com.sendgrid.rest.api.v3.verifiedsenders.models.ListVerifiedSender200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.math.BigDecimal;

public class ListVerifiedSender
extends ApiKeyBase {
    private BigDecimal limit;
    private BigDecimal lastSeenID;
    private Integer id;

    @Override
    public ApiResponse<ListVerifiedSender200Response> send(ApiKeyRestClient client) {
        String path = "/v3/verified_senders";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListVerifiedSender creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListVerifiedSender200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListVerifiedSender200Response.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.lastSeenID != null) {
            request.addQueryParam("lastSeenID", this.lastSeenID.toString());
        }
        if (this.id != null) {
            request.addQueryParam("id", this.id.toString());
        }
    }

    public void setLimit(BigDecimal limit) {
        this.limit = limit;
    }

    public void setLastSeenID(BigDecimal lastSeenID) {
        this.lastSeenID = lastSeenID;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

