/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.webhooks;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.webhooks.models.GetSignedEventWebhook200Response;
import com.sendgrid.rest.api.v3.webhooks.models.GetSignedEventWebhook404Response;
import com.sendgrid.rest.api.v3.webhooks.models.UpdateSignedEventWebhookRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateSignedEventWebhook
extends ApiKeyBase {
    private final String id;
    private String onBehalfOf;
    private UpdateSignedEventWebhookRequest updateSignedEventWebhookRequest;

    @Override
    public ApiResponse<GetSignedEventWebhook200Response> send(ApiKeyRestClient client) {
        String path = "/v3/user/webhooks/event/settings/signed/{id}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateSignedEventWebhook creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                GetSignedEventWebhook404Response error = JsonUtil.fromJson(response.getStream(), GetSignedEventWebhook404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<GetSignedEventWebhook200Response>(statusCode, JsonUtil.fromJson(response.getStream(), GetSignedEventWebhook200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateSignedEventWebhookRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateSignedEventWebhookRequest));
        }
    }

    public UpdateSignedEventWebhook(String id) {
        this.id = id;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setUpdateSignedEventWebhookRequest(UpdateSignedEventWebhookRequest updateSignedEventWebhookRequest) {
        this.updateSignedEventWebhookRequest = updateSignedEventWebhookRequest;
    }
}

