/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;

public class JsonUtil {
    private static final ObjectMapper defaultObjectMapper = JsonUtil.createDefaultObjectMapper();

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    public static String toJson(Object object) {
        return JsonUtil.toJson(object, defaultObjectMapper);
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(InputStream json, Class<T> clazz) {
        return JsonUtil.fromJson(json, defaultObjectMapper, clazz);
    }

    public static <T> T fromJson(InputStream json, ObjectMapper objectMapper, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(InputStream json, TypeReference<T> typeReference) {
        return JsonUtil.fromJson(json, defaultObjectMapper, typeReference);
    }

    public static <T> T fromJson(InputStream json, ObjectMapper objectMapper, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(json, typeReference);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }
}

