/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.util;

import com.sendgrid.constant.EnumConstants;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class Utility {
    public static String buildBaseUrl(String domain, String region, String endPoint) {
        List<String> availableRegions = EnumConstants.Region.getValues();
        StringBuilder defaultDomain = new StringBuilder(domain);
        if (availableRegions.contains(region) && !EnumConstants.Region.GLOBAL.getValue().equals(region)) {
            defaultDomain.append(".");
            defaultDomain.append(region);
        }
        return "https://" + defaultDomain.toString() + ".sendgrid.com" + endPoint;
    }

    public static String buildWithPathParams(String path, Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String placeholder = "\\{" + entry.getKey() + "\\}";
            path = path.replaceAll(placeholder, entry.getValue());
        }
        return path;
    }

    public static String buildWithQueryParams(String path, Map<String, String> queryParams) {
        URIBuilder builder = new URIBuilder();
        if (queryParams != null) {
            String multiValueDelimiter = "&";
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.contains(multiValueDelimiter)) {
                    List<String> values = Arrays.asList(value.split(multiValueDelimiter));
                    for (String val : values) {
                        builder.addParameter(key, val);
                    }
                    continue;
                }
                builder.setParameter(key, value);
            }
        }
        return path + builder.toString();
    }
}

