/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.threeten.bp.LocalDate;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.GetInboundEmailEvents;
import sibModel.GetInboundEmailEventsByUuid;

public class InboundParsingApi {
    private ApiClient apiClient;

    public InboundParsingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InboundParsingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getInboundEmailEventsCall(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inbound/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sender != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sender", sender));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getInboundEmailEventsValidateBeforeCall(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getInboundEmailEventsCall(sender, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetInboundEmailEvents getInboundEmailEvents(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetInboundEmailEvents> resp = this.getInboundEmailEventsWithHttpInfo(sender, startDate, endDate, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetInboundEmailEvents> getInboundEmailEventsWithHttpInfo(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getInboundEmailEventsValidateBeforeCall(sender, startDate, endDate, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetInboundEmailEvents>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getInboundEmailEventsAsync(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort, final ApiCallback<GetInboundEmailEvents> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getInboundEmailEventsValidateBeforeCall(sender, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetInboundEmailEvents>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getInboundEmailEventsByUuidCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inbound/events/{uuid}".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getInboundEmailEventsByUuidValidateBeforeCall(String uuid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getInboundEmailEventsByUuid(Async)");
        }
        Call call = this.getInboundEmailEventsByUuidCall(uuid, progressListener, progressRequestListener);
        return call;
    }

    public GetInboundEmailEventsByUuid getInboundEmailEventsByUuid(String uuid) throws ApiException {
        ApiResponse<GetInboundEmailEventsByUuid> resp = this.getInboundEmailEventsByUuidWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<GetInboundEmailEventsByUuid> getInboundEmailEventsByUuidWithHttpInfo(String uuid) throws ApiException {
        Call call = this.getInboundEmailEventsByUuidValidateBeforeCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<GetInboundEmailEventsByUuid>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getInboundEmailEventsByUuidAsync(String uuid, final ApiCallback<GetInboundEmailEventsByUuid> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getInboundEmailEventsByUuidValidateBeforeCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetInboundEmailEventsByUuid>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

