/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Contact Details")
public class Contact {
    @SerializedName(value="virtualNextTask")
    private Object virtualNextTask = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="assignToId")
    private String assignToId = null;
    @SerializedName(value="contactsId")
    private Integer contactsId = null;
    @SerializedName(value="crmLists")
    private Object crmLists = null;
    @SerializedName(value="attributes")
    private Object attributes = null;
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt = null;

    public Contact virtualNextTask(Object virtualNextTask) {
        this.virtualNextTask = virtualNextTask;
        return this;
    }

    @ApiModelProperty(example="{\"id\":\"618e030658282f0555259086\",\"date\":\"2021-11-12T06:30:00+00:00\",\"done\":false}", value="Next incomplete task of contact")
    public Object getVirtualNextTask() {
        return this.virtualNextTask;
    }

    public void setVirtualNextTask(Object virtualNextTask) {
        this.virtualNextTask = virtualNextTask;
    }

    public Contact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="contact@example.com", required=true, value="Contact email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Contact assignToId(String assignToId) {
        this.assignToId = assignToId;
        return this;
    }

    @ApiModelProperty(example="5faab4b7f195bb3c4c31e62a", value="User id to whom contact is assigned")
    public String getAssignToId() {
        return this.assignToId;
    }

    public void setAssignToId(String assignToId) {
        this.assignToId = assignToId;
    }

    public Contact contactsId(Integer contactsId) {
        this.contactsId = contactsId;
        return this;
    }

    @ApiModelProperty(example="247", value="Contact id")
    public Integer getContactsId() {
        return this.contactsId;
    }

    public void setContactsId(Integer contactsId) {
        this.contactsId = contactsId;
    }

    public Contact crmLists(Object crmLists) {
        this.crmLists = crmLists;
        return this;
    }

    @ApiModelProperty(example="[43,58]", required=true, value="CRM lists in which contact is added")
    public Object getCrmLists() {
        return this.crmLists;
    }

    public void setCrmLists(Object crmLists) {
        this.crmLists = crmLists;
    }

    public Contact attributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="{\"SMS\":\"33058407250\",\"IDENTIFICATION\":\"1-3RHQ-259\",\"CIV\":\"MS\",\"LAST_NAME\":\"Brennon\",\"FIRST_NAME\":\"Meg\",\"DOB\":\"1986-05-02T00:00:00.000Z\",\"ADDRESS\":\"1 5th avenue\",\"ZIP_CODE\":\"44300\",\"CITY\":\"New-York\",\"ACTION_CODE\":\"17HH98CH\"}", value="Contact attributes e.g firstname / lastname / SMS etc.")
    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object attributes) {
        this.attributes = attributes;
    }

    public Contact createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-01T17:05:03.000Z", value="Contact created date/time")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Contact updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-01T17:05:03.000Z", value="Contact updated date/time")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.virtualNextTask, contact.virtualNextTask) && Objects.equals(this.email, contact.email) && Objects.equals(this.assignToId, contact.assignToId) && Objects.equals(this.contactsId, contact.contactsId) && Objects.equals(this.crmLists, contact.crmLists) && Objects.equals(this.attributes, contact.attributes) && Objects.equals(this.createdAt, contact.createdAt) && Objects.equals(this.updatedAt, contact.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.virtualNextTask, this.email, this.assignToId, this.contactsId, this.crmLists, this.attributes, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    virtualNextTask: ").append(this.toIndentedString(this.virtualNextTask)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    assignToId: ").append(this.toIndentedString(this.assignToId)).append("\n");
        sb.append("    contactsId: ").append(this.toIndentedString(this.contactsId)).append("\n");
        sb.append("    crmLists: ").append(this.toIndentedString(this.crmLists)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

