/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import sibModel.CreateAttributeEnumeration;

public class CreateAttribute {
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="enumeration")
    private List<CreateAttributeEnumeration> enumeration = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public CreateAttribute value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="COUNT[BLACKLISTED,BLACKLISTED,<,NOW()]", value="Value of the attribute. Use only if the attribute's category is 'calculated' or 'global'")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public CreateAttribute enumeration(List<CreateAttributeEnumeration> enumeration) {
        this.enumeration = enumeration;
        return this;
    }

    public CreateAttribute addEnumerationItem(CreateAttributeEnumeration enumerationItem) {
        if (this.enumeration == null) {
            this.enumeration = new ArrayList<CreateAttributeEnumeration>();
        }
        this.enumeration.add(enumerationItem);
        return this;
    }

    @ApiModelProperty(value="List of values and labels that the attribute can take. Use only if the attribute's category is \"category\". For example, [{\"value\":1, \"label\":\"male\"}, {\"value\":2, \"label\":\"female\"}]")
    public List<CreateAttributeEnumeration> getEnumeration() {
        return this.enumeration;
    }

    public void setEnumeration(List<CreateAttributeEnumeration> enumeration) {
        this.enumeration = enumeration;
    }

    public CreateAttribute type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="text", value="Type of the attribute. Use only if the attribute's category is 'normal', 'category' or 'transactional' ( type 'boolean' is only available if the category is 'normal' attribute, type 'id' is only available if the category is 'transactional' attribute & type 'category' is only available if the category is 'category' attribute )")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAttribute createAttribute = (CreateAttribute)o;
        return Objects.equals(this.value, createAttribute.value) && Objects.equals(this.enumeration, createAttribute.enumeration) && Objects.equals((Object)this.type, (Object)createAttribute.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.enumeration, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAttribute {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    enumeration: ").append(this.toIndentedString(this.enumeration)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TEXT("text"),
        DATE("date"),
        FLOAT("float"),
        BOOLEAN("boolean"),
        ID("id"),
        CATEGORY("category");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            TypeEnum[] typeEnumArray = TypeEnum.values();
            int n = typeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeEnum b = typeEnumArray[n2];
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
                ++n2;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

