/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="File data that is uploaded")
public class FileData {
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="authorId")
    private String authorId = null;
    @SerializedName(value="author")
    private Object author = null;
    @SerializedName(value="contactId")
    private Long contactId = null;
    @SerializedName(value="dealIds")
    private List<String> dealIds = null;
    @SerializedName(value="size")
    private Long size = null;
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt = null;

    public FileData url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="/api/v1/files/61a88a2eb7a574180261234", value="Url of uploaded file")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FileData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="61a88a2eb7a574180261234", value="Id of uploaded file")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FileData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="example.png", value="Name of uploaded file")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FileData authorId(String authorId) {
        this.authorId = authorId;
        return this;
    }

    @ApiModelProperty(example="61a5ce58y5d4795761045991", value="Account id of user which created the file")
    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public FileData author(Object author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(example="{\"id\":\"61a5ce58y5d4795761045991\",\"email\":\"johndoe@example.com\",\"locale\":\"en_GB\",\"timezone\":\"Asia/Kolkata\",\"name\":{\"fullName\":\"John Doe\"}}", value="Account details of user which created the file")
    public Object getAuthor() {
        return this.author;
    }

    public void setAuthor(Object author) {
        this.author = author;
    }

    public FileData contactId(Long contactId) {
        this.contactId = contactId;
        return this;
    }

    @ApiModelProperty(example="1", value="Contact id of contact on which file is uploaded")
    public Long getContactId() {
        return this.contactId;
    }

    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }

    public FileData dealIds(List<String> dealIds) {
        this.dealIds = dealIds;
        return this;
    }

    public FileData addDealIdsItem(String dealIdsItem) {
        if (this.dealIds == null) {
            this.dealIds = new ArrayList<String>();
        }
        this.dealIds.add(dealIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\"]", value="Deal ids linked to a file")
    public List<String> getDealIds() {
        return this.dealIds;
    }

    public void setDealIds(List<String> dealIds) {
        this.dealIds = dealIds;
    }

    public FileData size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="10", value="Size of file uploaded")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public FileData createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-01T17:05:03.000Z", value="File created date/time")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public FileData updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-01T17:05:03.000Z", value="File updated date/time")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileData fileData = (FileData)o;
        return Objects.equals(this.url, fileData.url) && Objects.equals(this.id, fileData.id) && Objects.equals(this.name, fileData.name) && Objects.equals(this.authorId, fileData.authorId) && Objects.equals(this.author, fileData.author) && Objects.equals(this.contactId, fileData.contactId) && Objects.equals(this.dealIds, fileData.dealIds) && Objects.equals(this.size, fileData.size) && Objects.equals(this.createdAt, fileData.createdAt) && Objects.equals(this.updatedAt, fileData.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.id, this.name, this.authorId, this.author, this.contactId, this.dealIds, this.size, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileData {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    authorId: ").append(this.toIndentedString(this.authorId)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    dealIds: ").append(this.toIndentedString(this.dealIds)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

