/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.LocalDate;

public class GetAccountPlan {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="creditsType")
    private CreditsTypeEnum creditsType = null;
    @SerializedName(value="credits")
    private Float credits = null;
    @SerializedName(value="startDate")
    private LocalDate startDate = null;
    @SerializedName(value="endDate")
    private LocalDate endDate = null;
    @SerializedName(value="userLimit")
    private Integer userLimit = null;

    public GetAccountPlan type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="subscription", required=true, value="Displays the plan type of the user")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public GetAccountPlan creditsType(CreditsTypeEnum creditsType) {
        this.creditsType = creditsType;
        return this;
    }

    @ApiModelProperty(example="sendLimit", required=true, value="This is the type of the credit, \"Send Limit\" is one of the possible types of credit of a user. \"Send Limit\" implies the total number of emails you can send to the subscribers in your account.")
    public CreditsTypeEnum getCreditsType() {
        return this.creditsType;
    }

    public void setCreditsType(CreditsTypeEnum creditsType) {
        this.creditsType = creditsType;
    }

    public GetAccountPlan credits(Float credits) {
        this.credits = credits;
        return this;
    }

    @ApiModelProperty(example="8755.0", required=true, value="Remaining credits of the user")
    public Float getCredits() {
        return this.credits;
    }

    public void setCredits(Float credits) {
        this.credits = credits;
    }

    public GetAccountPlan startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="2016-12-31", value="Date of the period from which the plan will start (only available for \"subscription\" and \"reseller\" plan type)")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public GetAccountPlan endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="2017-01-31", value="Date of the period from which the plan will end (only available for \"subscription\" and \"reseller\" plan type)")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public GetAccountPlan userLimit(Integer userLimit) {
        this.userLimit = userLimit;
        return this;
    }

    @ApiModelProperty(example="10", value="Only in case of reseller account. It implies the total number of child accounts you can add to your account.")
    public Integer getUserLimit() {
        return this.userLimit;
    }

    public void setUserLimit(Integer userLimit) {
        this.userLimit = userLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAccountPlan getAccountPlan = (GetAccountPlan)o;
        return Objects.equals((Object)this.type, (Object)getAccountPlan.type) && Objects.equals((Object)this.creditsType, (Object)getAccountPlan.creditsType) && Objects.equals(this.credits, getAccountPlan.credits) && Objects.equals(this.startDate, getAccountPlan.startDate) && Objects.equals(this.endDate, getAccountPlan.endDate) && Objects.equals(this.userLimit, getAccountPlan.userLimit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.creditsType, this.credits, this.startDate, this.endDate, this.userLimit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAccountPlan {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    creditsType: ").append(this.toIndentedString((Object)this.creditsType)).append("\n");
        sb.append("    credits: ").append(this.toIndentedString(this.credits)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    userLimit: ").append(this.toIndentedString(this.userLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CreditsTypeEnum {
        SENDLIMIT("sendLimit");

        private String value;

        private CreditsTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CreditsTypeEnum fromValue(String text) {
            CreditsTypeEnum[] creditsTypeEnumArray = CreditsTypeEnum.values();
            int n = creditsTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                CreditsTypeEnum b = creditsTypeEnumArray[n2];
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
                ++n2;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CreditsTypeEnum> {
            public void write(JsonWriter jsonWriter, CreditsTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CreditsTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CreditsTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PAYASYOUGO("payAsYouGo"),
        FREE("free"),
        SUBSCRIPTION("subscription"),
        SMS("sms"),
        RESELLER("reseller");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            TypeEnum[] typeEnumArray = TypeEnum.values();
            int n = typeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeEnum b = typeEnumArray[n2];
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
                ++n2;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

