/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import sibModel.RequestContactImportNewList;

public class RequestContactImport {
    @SerializedName(value="fileUrl")
    private String fileUrl = null;
    @SerializedName(value="fileBody")
    private String fileBody = null;
    @SerializedName(value="jsonBody")
    private List<Map<String, Object>> jsonBody = null;
    @SerializedName(value="listIds")
    private List<Long> listIds = null;
    @SerializedName(value="notifyUrl")
    private String notifyUrl = null;
    @SerializedName(value="newList")
    private RequestContactImportNewList newList = null;
    @SerializedName(value="emailBlacklist")
    private Boolean emailBlacklist = false;
    @SerializedName(value="smsBlacklist")
    private Boolean smsBlacklist = false;
    @SerializedName(value="updateExistingContacts")
    private Boolean updateExistingContacts = true;
    @SerializedName(value="emptyContactsAttributes")
    private Boolean emptyContactsAttributes = false;

    public RequestContactImport fileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        return this;
    }

    @ApiModelProperty(example="https://importfile.domain.com", value="Mandatory if fileBody or jsonBody is not defined. URL of the file to be imported (no local file). Possible file formats: .txt, .csv, .json")
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public RequestContactImport fileBody(String fileBody) {
        this.fileBody = fileBody;
        return this;
    }

    @ApiModelProperty(example="NAME;SURNAME;EMAIL\\n\"Smith\";\"John\";\"john.smith@example.com\"\\n\"Roger\";\"Ellie\";\"ellie36@example.com", value="Mandatory if fileUrl and jsonBody is not defined. CSV content to be imported. Use semicolon to separate multiple attributes. Maximum allowed file body size is 10MB . However we recommend a safe limit of around 8 MB to avoid the issues caused due to increase of file body size while parsing. Please use fileUrl instead to import bigger files.")
    public String getFileBody() {
        return this.fileBody;
    }

    public void setFileBody(String fileBody) {
        this.fileBody = fileBody;
    }

    public RequestContactImport jsonBody(List<Map<String, Object>> jsonBody) {
        this.jsonBody = jsonBody;
        return this;
    }

    public RequestContactImport addJsonBodyItem(Map<String, Object> jsonBodyItem) {
        if (this.jsonBody == null) {
            this.jsonBody = new ArrayList<Map<String, Object>>();
        }
        this.jsonBody.add(jsonBodyItem);
        return this;
    }

    @ApiModelProperty(value="**Mandatory if fileUrl and fileBody is not defined.** JSON content to be imported. **Maximum allowed json body size is 10MB** . However we recommend a safe limit of around 8 MB to avoid the issues caused due to increase of json body size while parsing. Please use fileUrl instead to import bigger files. ")
    public List<Map<String, Object>> getJsonBody() {
        return this.jsonBody;
    }

    public void setJsonBody(List<Map<String, Object>> jsonBody) {
        this.jsonBody = jsonBody;
    }

    public RequestContactImport listIds(List<Long> listIds) {
        this.listIds = listIds;
        return this;
    }

    public RequestContactImport addListIdsItem(Long listIdsItem) {
        if (this.listIds == null) {
            this.listIds = new ArrayList<Long>();
        }
        this.listIds.add(listIdsItem);
        return this;
    }

    @ApiModelProperty(value="Mandatory if newList is not defined. Ids of the lists in which the contacts shall be imported. For example, [2, 4, 7].")
    public List<Long> getListIds() {
        return this.listIds;
    }

    public void setListIds(List<Long> listIds) {
        this.listIds = listIds;
    }

    public RequestContactImport notifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", value="URL that will be called once the import process is finished. For reference, https://help.sendinblue.com/hc/en-us/articles/360007666479")
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public RequestContactImport newList(RequestContactImportNewList newList) {
        this.newList = newList;
        return this;
    }

    @ApiModelProperty(value="")
    public RequestContactImportNewList getNewList() {
        return this.newList;
    }

    public void setNewList(RequestContactImportNewList newList) {
        this.newList = newList;
    }

    public RequestContactImport emailBlacklist(Boolean emailBlacklist) {
        this.emailBlacklist = emailBlacklist;
        return this;
    }

    @ApiModelProperty(example="false", value="To blacklist all the contacts for email")
    public Boolean isEmailBlacklist() {
        return this.emailBlacklist;
    }

    public void setEmailBlacklist(Boolean emailBlacklist) {
        this.emailBlacklist = emailBlacklist;
    }

    public RequestContactImport smsBlacklist(Boolean smsBlacklist) {
        this.smsBlacklist = smsBlacklist;
        return this;
    }

    @ApiModelProperty(example="false", value="To blacklist all the contacts for sms")
    public Boolean isSmsBlacklist() {
        return this.smsBlacklist;
    }

    public void setSmsBlacklist(Boolean smsBlacklist) {
        this.smsBlacklist = smsBlacklist;
    }

    public RequestContactImport updateExistingContacts(Boolean updateExistingContacts) {
        this.updateExistingContacts = updateExistingContacts;
        return this;
    }

    @ApiModelProperty(example="true", value="To facilitate the choice to update the existing contacts")
    public Boolean isUpdateExistingContacts() {
        return this.updateExistingContacts;
    }

    public void setUpdateExistingContacts(Boolean updateExistingContacts) {
        this.updateExistingContacts = updateExistingContacts;
    }

    public RequestContactImport emptyContactsAttributes(Boolean emptyContactsAttributes) {
        this.emptyContactsAttributes = emptyContactsAttributes;
        return this;
    }

    @ApiModelProperty(example="true", value="To facilitate the choice to erase any attribute of the existing contacts with empty value. emptyContactsAttributes = true means the empty fields in your import will erase any attribute that currently contain data in SendinBlue, & emptyContactsAttributes = false means the empty fields will not affect your existing data ( only available if `updateExistingContacts` set to true )")
    public Boolean isEmptyContactsAttributes() {
        return this.emptyContactsAttributes;
    }

    public void setEmptyContactsAttributes(Boolean emptyContactsAttributes) {
        this.emptyContactsAttributes = emptyContactsAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestContactImport requestContactImport = (RequestContactImport)o;
        return Objects.equals(this.fileUrl, requestContactImport.fileUrl) && Objects.equals(this.fileBody, requestContactImport.fileBody) && Objects.equals(this.jsonBody, requestContactImport.jsonBody) && Objects.equals(this.listIds, requestContactImport.listIds) && Objects.equals(this.notifyUrl, requestContactImport.notifyUrl) && Objects.equals(this.newList, requestContactImport.newList) && Objects.equals(this.emailBlacklist, requestContactImport.emailBlacklist) && Objects.equals(this.smsBlacklist, requestContactImport.smsBlacklist) && Objects.equals(this.updateExistingContacts, requestContactImport.updateExistingContacts) && Objects.equals(this.emptyContactsAttributes, requestContactImport.emptyContactsAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.fileUrl, this.fileBody, this.jsonBody, this.listIds, this.notifyUrl, this.newList, this.emailBlacklist, this.smsBlacklist, this.updateExistingContacts, this.emptyContactsAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestContactImport {\n");
        sb.append("    fileUrl: ").append(this.toIndentedString(this.fileUrl)).append("\n");
        sb.append("    fileBody: ").append(this.toIndentedString(this.fileBody)).append("\n");
        sb.append("    jsonBody: ").append(this.toIndentedString(this.jsonBody)).append("\n");
        sb.append("    listIds: ").append(this.toIndentedString(this.listIds)).append("\n");
        sb.append("    notifyUrl: ").append(this.toIndentedString(this.notifyUrl)).append("\n");
        sb.append("    newList: ").append(this.toIndentedString(this.newList)).append("\n");
        sb.append("    emailBlacklist: ").append(this.toIndentedString(this.emailBlacklist)).append("\n");
        sb.append("    smsBlacklist: ").append(this.toIndentedString(this.smsBlacklist)).append("\n");
        sb.append("    updateExistingContacts: ").append(this.toIndentedString(this.updateExistingContacts)).append("\n");
        sb.append("    emptyContactsAttributes: ").append(this.toIndentedString(this.emptyContactsAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

