/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Mandatory if `templateId` is not passed. Pass `name` (optional) and `email` OR `id` of sender from which emails will be sent. `name` will be ignored if passed along with sender `id`. For example, {\"name\":\"Mary from MyShop\", \"email\":\"no-reply@myshop.com\"} or {\"id\":2}")
public class SendSmtpEmailSender {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="id")
    private Long id = null;

    public SendSmtpEmailSender name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Mary from MyShop", value="Name of the sender from which the emails will be sent. Maximum allowed characters are 70. Applicable only when email is passed.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SendSmtpEmailSender email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="no-reply@myshop.com", value="Email of the sender from which the emails will be sent. Mandatory if sender id is not passed.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public SendSmtpEmailSender id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="2", value="Id of the sender from which the emails will be sent. In order to select a sender with specific pool of IP\u2019s, dedicated ip users shall pass id (instead of email). Mandatory if email is not passed.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendSmtpEmailSender sendSmtpEmailSender = (SendSmtpEmailSender)o;
        return Objects.equals(this.name, sendSmtpEmailSender.name) && Objects.equals(this.email, sendSmtpEmailSender.email) && Objects.equals(this.id, sendSmtpEmailSender.id);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.email, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendSmtpEmailSender {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

