/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class SendTransacSms {
    @SerializedName(value="sender")
    private String sender = null;
    @SerializedName(value="recipient")
    private String recipient = null;
    @SerializedName(value="content")
    private String content = null;
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.TRANSACTIONAL;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="webUrl")
    private String webUrl = null;
    @SerializedName(value="unicodeEnabled")
    private Boolean unicodeEnabled = false;

    public SendTransacSms sender(String sender) {
        this.sender = sender;
        return this;
    }

    @ApiModelProperty(example="MyShop", required=true, value="Name of the sender. **The number of characters is limited to 11 for alphanumeric characters and 15 for numeric characters**")
    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public SendTransacSms recipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="33689965433", required=true, value="Mobile number to send SMS with the country code")
    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public SendTransacSms content(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="Enter this code:CCJJG8 to validate your account", required=true, value="Content of the message. If more than 160 characters long, will be sent as multiple text messages")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public SendTransacSms type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="marketing", value="Type of the SMS. Marketing SMS messages are those sent typically with marketing content. Transactional SMS messages are sent to individuals and are triggered in response to some action, such as a sign-up, purchase, etc.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SendTransacSms tag(String tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(example="accountValidation", value="Tag of the message")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public SendTransacSms webUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", value="Webhook to call for each event triggered by the message (delivered etc.)")
    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public SendTransacSms unicodeEnabled(Boolean unicodeEnabled) {
        this.unicodeEnabled = unicodeEnabled;
        return this;
    }

    @ApiModelProperty(example="true", value="Format of the message. It indicates whether the content should be treated as unicode or not.")
    public Boolean isUnicodeEnabled() {
        return this.unicodeEnabled;
    }

    public void setUnicodeEnabled(Boolean unicodeEnabled) {
        this.unicodeEnabled = unicodeEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendTransacSms sendTransacSms = (SendTransacSms)o;
        return Objects.equals(this.sender, sendTransacSms.sender) && Objects.equals(this.recipient, sendTransacSms.recipient) && Objects.equals(this.content, sendTransacSms.content) && Objects.equals((Object)this.type, (Object)sendTransacSms.type) && Objects.equals(this.tag, sendTransacSms.tag) && Objects.equals(this.webUrl, sendTransacSms.webUrl) && Objects.equals(this.unicodeEnabled, sendTransacSms.unicodeEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sender, this.recipient, this.content, this.type, this.tag, this.webUrl, this.unicodeEnabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendTransacSms {\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    webUrl: ").append(this.toIndentedString(this.webUrl)).append("\n");
        sb.append("    unicodeEnabled: ").append(this.toIndentedString(this.unicodeEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TRANSACTIONAL("transactional"),
        MARKETING("marketing");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            TypeEnum[] typeEnumArray = TypeEnum.values();
            int n = typeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeEnum b = typeEnumArray[n2];
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
                ++n2;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

