/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.deeplink;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.AbsDeepLink;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.DeepLinkManager;
import com.sensorsdata.analytics.android.sdk.advert.utils.ChannelUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class ChannelDeepLink
extends AbsDeepLink {
    ChannelDeepLink(Intent intent) {
        super(intent);
    }

    @Override
    public void parseDeepLink(Intent intent) {
        if (intent == null || intent.getData() == null) {
            return;
        }
        Uri uri = intent.getData();
        if (uri.isOpaque()) {
            SALog.d((String)"ChannelDeepLink", (String)(uri.toString() + " isOpaque"));
            return;
        }
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        Set parameterNames = uri.getQueryParameterNames();
        if (parameterNames != null && parameterNames.size() > 0) {
            HashMap<String, String> uriParams = new HashMap<String, String>();
            Iterator iterator = parameterNames.iterator();
            while (iterator.hasNext()) {
                String name;
                String value = uri.getQueryParameter(name = (String)iterator.next());
                uriParams.put(name, TextUtils.isEmpty((CharSequence)value) ? "" : value);
            }
            ChannelUtils.parseParams(uriParams);
            if (this.mCallBack != null) {
                this.mCallBack.onFinish(DeepLinkManager.DeepLinkType.CHANNEL, null, true, 0L);
            }
        }
    }

    @Override
    public void mergeDeepLinkProperty(JSONObject properties) {
        try {
            properties.put("$deeplink_url", (Object)this.getDeepLinkUrl());
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        JSONUtils.mergeJSONObject((JSONObject)ChannelUtils.getUtmProperties(), (JSONObject)properties);
    }
}

