/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.deeplink;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.advert.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.advert.utils.ChannelUtils;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.deeplink.SADeepLinkObject;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeferredDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.Map;
import org.json.JSONObject;

public class DeferredDeepLinkHelper {
    public static void request(final JSONObject jsonData, final SensorsDataDeferredDeepLinkCallback callBack, String url, final boolean isSaveDeepLinkInfo) {
        final long requestDeepLinkStartTime = System.currentTimeMillis();
        boolean isLegalHostUrl = !TextUtils.isEmpty((CharSequence)url) && (url.startsWith("http://") || url.startsWith("https://"));
        final SensorsDataAPI sensorsDataAPI = SensorsDataAPI.sharedInstance();
        if (!(isLegalHostUrl || !TextUtils.isEmpty((CharSequence)sensorsDataAPI.getServerUrl()) && sensorsDataAPI.getServerUrl().startsWith("http"))) {
            return;
        }
        new RequestHelper.Builder(HttpMethod.POST, NetworkUtils.getRequestUrl((String)(isLegalHostUrl ? url : sensorsDataAPI.getServerUrl()), (String)"slink/ddeeplink")).jsonData(jsonData.toString()).callback((HttpCallback)new HttpCallback.JsonCallback(){
            private String parameter;
            private String adChannel;
            private boolean isSuccess = false;
            private String errorMsg;
            private String adSlinkId;
            private String adSlinkTemplateId;
            private String adSlinkType;

            public void onFailure(int code, String errorMessage) {
                this.errorMsg = errorMessage;
            }

            public void onResponse(JSONObject response) {
                if (response != null) {
                    int code = response.optInt("code");
                    if (code == 0) {
                        this.isSuccess = true;
                        JSONObject channel = response.optJSONObject("channel_params");
                        Map params = JSONUtils.json2Map((JSONObject)channel);
                        ChannelUtils.parseParams(params);
                        this.parameter = response.optString("parameter");
                        this.adChannel = response.optString("ad_channel");
                        this.adSlinkId = response.optString("ad_slink_id");
                        this.adSlinkTemplateId = response.optString("slink_template_id");
                        this.adSlinkType = response.optString("slink_type");
                    } else {
                        this.errorMsg = response.optString("msg");
                    }
                } else {
                    this.errorMsg = "response is null";
                }
            }

            public void onAfter() {
                if (isSaveDeepLinkInfo) {
                    ChannelUtils.saveDeepLinkInfo();
                }
                long duration = System.currentTimeMillis() - requestDeepLinkStartTime;
                final JSONObject properties = new JSONObject();
                try {
                    if (!TextUtils.isEmpty((CharSequence)this.parameter)) {
                        properties.put("$deeplink_options", (Object)this.parameter);
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.errorMsg)) {
                        properties.put("$deeplink_match_fail_reason", (Object)this.errorMsg);
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.adChannel)) {
                        properties.put("$ad_deeplink_channel_info", (Object)this.adChannel);
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.adSlinkId)) {
                        properties.put("$ad_slink_id", (Object)this.adSlinkId);
                    }
                    properties.put("$ad_app_match_type", (Object)"deferred deeplink");
                    properties.put("$event_duration", (Object)TimeUtils.duration((float)duration));
                    properties.put("$ad_device_info", jsonData.get("ids"));
                    if (!TextUtils.isEmpty((CharSequence)this.adSlinkTemplateId)) {
                        properties.put("$ad_slink_template_id", (Object)this.adSlinkTemplateId);
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.adSlinkType)) {
                        properties.put("$ad_slink_type", (Object)this.adSlinkType);
                    }
                    if (callBack != null) {
                        try {
                            if (callBack.onReceive(new SADeepLinkObject(this.parameter, this.adChannel, this.isSuccess, duration)) && this.isSuccess) {
                                final JSONObject jsonObject = new JSONObject();
                                jsonObject.put("$deeplink_options", (Object)this.parameter);
                                if (!TextUtils.isEmpty((CharSequence)this.adSlinkId)) {
                                    jsonObject.put("$ad_slink_id", (Object)this.adSlinkId);
                                }
                                if (!TextUtils.isEmpty((CharSequence)this.adSlinkTemplateId)) {
                                    properties.put("$ad_slink_template_id", (Object)this.adSlinkTemplateId);
                                }
                                if (!TextUtils.isEmpty((CharSequence)this.adSlinkType)) {
                                    properties.put("$ad_slink_type", (Object)this.adSlinkType);
                                }
                                JSONUtils.mergeJSONObject((JSONObject)ChannelUtils.getUtmProperties(), (JSONObject)jsonObject);
                                SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                                    @Override
                                    public void run() {
                                        SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName("$AdAppDeferredDeepLinkJump").setProperties(jsonObject));
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            SALog.printStackTrace((Exception)e);
                        }
                    } else if (this.isSuccess) {
                        properties.put("$deeplink_match_fail_reason", (Object)SADisplayUtil.getStringResource((Context)sensorsDataAPI.getSAContextManager().getContext(), (int)R.string.sensors_analytics_ad_listener));
                    }
                    JSONUtils.mergeJSONObject((JSONObject)ChannelUtils.getUtmProperties(), (JSONObject)properties);
                    SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                        @Override
                        public void run() {
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName("$AppDeeplinkMatchedResult").setProperties(properties));
                        }
                    });
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        }).execute();
    }
}

