/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.provider.Settings;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.OAIDService;

public class HuaweiImpl
implements IRomOAID {
    private final Context mContext;
    private final OAIDService mService;
    private static final String TAG = "SA.HuaweiImpl";
    private String mPackageName;

    public HuaweiImpl(Context context) {
        this.mContext = context;
        this.mService = new OAIDService();
    }

    @Override
    public boolean isSupported() {
        boolean ret = false;
        try {
            PackageManager pm = this.mContext.getPackageManager();
            if (pm.getPackageInfo("com.huawei.hwid", 0) != null) {
                this.mPackageName = "com.huawei.hwid";
                ret = true;
            } else if (pm.getPackageInfo("com.huawei.hwid.tv", 0) != null) {
                this.mPackageName = "com.huawei.hwid.tv";
                ret = true;
            } else {
                this.mPackageName = "com.huawei.hms";
                ret = pm.getPackageInfo(this.mPackageName, 0) != null;
            }
        }
        catch (Throwable t) {
            SALog.i((String)TAG, (Throwable)t);
        }
        return ret;
    }

    @Override
    public String getRomOAID() {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                String oaid = Settings.Global.getString((ContentResolver)this.mContext.getContentResolver(), (String)"pps_oaid");
                if (!TextUtils.isEmpty((CharSequence)oaid)) {
                    SALog.i((String)TAG, (String)"Get oaid from global settings");
                    return oaid;
                }
            }
            catch (Throwable t) {
                SALog.i((String)TAG, (Throwable)t);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.mPackageName) && !this.isSupported()) {
            SALog.i((String)TAG, (String)"Huawei Advertising ID not available");
            return null;
        }
        Intent intent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
        intent.setPackage(this.mPackageName);
        String oaid = null;
        try {
            if (this.mContext.bindService(intent, (ServiceConnection)this.mService, 1)) {
                HuaWeiInterface anInterface = new HuaWeiInterface(OAIDService.BINDER_QUEUE.take());
                oaid = anInterface.getOAID();
            }
        }
        catch (Throwable t) {
            SALog.i((String)TAG, (Throwable)t);
        }
        return oaid;
    }

    static final class HuaWeiInterface
    implements IInterface {
        private final IBinder iBinder;

        private HuaWeiInterface(IBinder iBinder2) {
            this.iBinder = iBinder2;
        }

        public IBinder asBinder() {
            return this.iBinder;
        }

        public String getOAID() {
            String str = null;
            try {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                obtain.writeInterfaceToken("com.uodis.opendevice.aidl.OpenDeviceIdentifierService");
                this.iBinder.transact(1, obtain, obtain2, 0);
                obtain2.readException();
                str = obtain2.readString();
                obtain.recycle();
                obtain2.recycle();
            }
            catch (Throwable th) {
                SALog.i((String)HuaweiImpl.TAG, (Throwable)th);
            }
            return str;
        }
    }
}

