/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.scan;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.advert.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.advert.oaid.SAOaidHelper;
import com.sensorsdata.analytics.android.sdk.advert.scan.IAdvertScanListener;
import com.sensorsdata.analytics.android.sdk.advert.utils.ChannelUtils;
import com.sensorsdata.analytics.android.sdk.advert.utils.SAAdvertUtils;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataLoadingDialog;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import java.util.Date;
import org.json.JSONObject;

public class ChannelDebugScanHelper
implements IAdvertScanListener {
    @Override
    public void handlerScanUri(Activity activity, Uri uri) {
        if (ChannelUtils.hasUtmByMetaData((Context)activity)) {
            SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_listener));
            return;
        }
        String monitorId = uri.getQueryParameter("monitor_id");
        if (TextUtils.isEmpty((CharSequence)monitorId)) {
            SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            return;
        }
        String url = SensorsDataAPI.sharedInstance().getServerUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_url));
            return;
        }
        ServerUrl serverUrl = new ServerUrl(url);
        String projectName = uri.getQueryParameter("project_name");
        if (serverUrl.getProject().equals(projectName)) {
            String projectId = uri.getQueryParameter("project_id");
            String accountId = uri.getQueryParameter("account_id");
            String isReLink = uri.getQueryParameter("is_relink");
            if ("1".equals(isReLink)) {
                String deviceCode = uri.getQueryParameter("device_code");
                if (ChannelUtils.checkDeviceInfo((Context)activity, deviceCode)) {
                    ChannelDebugScanHelper.showChannelDebugActiveDialog(activity);
                } else {
                    SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_retry));
                }
            } else {
                ChannelDebugScanHelper.showChannelDebugDialog(activity, serverUrl.getBaseUrl(), monitorId, projectId, accountId);
            }
        } else {
            SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_project));
        }
    }

    public static void showChannelDebugActiveDialog(final Activity activity) {
        SensorsDataDialogUtils.showDialog((Activity)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_title), (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_content), (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_activate), (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChannelDebugScanHelper.trackChannelDebugInstallation(activity);
                ChannelDebugScanHelper.showChannelDebugActiveDialog(activity);
            }
        }, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_cancel), (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            }
        });
    }

    private static void trackChannelDebugInstallation(final Activity activity) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject _properties = new JSONObject();
                    _properties.put("$ios_install_source", (Object)ChannelUtils.getDeviceInfo((Context)activity, SAAdvertUtils.getIdentifier((Context)activity), SAOaidHelper.getOpenAdIdentifier((Context)activity)));
                    SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName("$ChannelDebugInstall").setProperties(_properties));
                    JSONObject profileProperties = new JSONObject();
                    JSONUtils.mergeJSONObject((JSONObject)_properties, (JSONObject)profileProperties);
                    profileProperties.put("$first_visit_time", (Object)new Date());
                    SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.PROFILE_SET_ONCE).setProperties(profileProperties));
                    SensorsDataAPI.sharedInstance().flush();
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        }).start();
    }

    public static void showChannelDebugDialog(final Activity activity, final String baseUrl, final String monitorId, final String projectId, final String accountId) {
        SensorsDataDialogUtils.showDialog((Activity)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_starting), (String)"", (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_ok), (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (dialog != null) {
                    dialog.dismiss();
                }
                Context context = activity.getApplicationContext();
                boolean isTrackInstallation = ChannelUtils.isTrackInstallation();
                if (!isTrackInstallation || ChannelUtils.isCorrectTrackInstallation()) {
                    String androidId = SensorsDataUtils.getIdentifier((Context)context);
                    String oaid = SAOaidHelper.getOpenAdIdentifier(context);
                    if (isTrackInstallation && !ChannelUtils.isGetDeviceInfo(context, androidId, oaid)) {
                        ChannelDebugScanHelper.showChannelDebugErrorDialog(activity);
                        return;
                    }
                    if (!NetworkUtils.isNetworkAvailable((Context)context)) {
                        SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_network));
                        return;
                    }
                    String deviceCode = ChannelUtils.getDeviceInfo((Context)activity, androidId, oaid);
                    final SensorsDataLoadingDialog loadingDialog = new SensorsDataLoadingDialog((Context)activity);
                    SensorsDataDialogUtils.dialogShowDismissOld((Dialog)loadingDialog);
                    ChannelDebugScanHelper.requestActiveChannel(baseUrl, monitorId, projectId, accountId, deviceCode, isTrackInstallation, (HttpCallback)new HttpCallback.JsonCallback(){

                        public void onFailure(int code, String errorMessage) {
                            loadingDialog.dismiss();
                            SALog.i((String)"SA.Advert", (String)("ChannelDebug request error:" + errorMessage));
                            SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_request));
                        }

                        public void onResponse(JSONObject response) {
                            loadingDialog.dismiss();
                            if (response == null) {
                                SALog.i((String)"SA.Advert", (String)"ChannelDebug response error msg: response is null");
                                SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_whitelist));
                                return;
                            }
                            int code = response.optInt("code", 0);
                            if (code == 1) {
                                ChannelDebugScanHelper.showChannelDebugActiveDialog(activity);
                            } else {
                                SALog.i((String)"SA.Advert", (String)("ChannelDebug response error msg:" + response.optString("message")));
                                SensorsDataDialogUtils.showDialog((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_whitelist));
                            }
                        }
                    });
                } else {
                    ChannelDebugScanHelper.showChannelDebugErrorDialog(activity);
                }
            }
        }, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_cancel), (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            }
        });
    }

    private static void showChannelDebugErrorDialog(final Activity activity) {
        SensorsDataDialogUtils.showDialog((Activity)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_debug_fail_title), (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_error_debug_fail_content), (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_dialog_ok), (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            }
        }, null, null);
    }

    private static void requestActiveChannel(String baseUrl, String monitorId, String projectId, String accountId, String deviceCode, boolean isActive, HttpCallback callback) {
        try {
            JSONObject json = new JSONObject();
            json.put("monitor_id", (Object)monitorId);
            json.put("distinct_id", (Object)SensorsDataAPI.sharedInstance().getDistinctId());
            json.put("project_id", (Object)projectId);
            json.put("account_id", (Object)accountId);
            json.put("has_active", (Object)(isActive ? "true" : "false"));
            json.put("device_code", (Object)deviceCode);
            new RequestHelper.Builder(HttpMethod.POST, baseUrl + "/api/sdk/channel_tool/url").jsonData(json.toString()).callback(callback).execute();
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

