/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.scan;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.advert.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.advert.oaid.SAOaidHelper;
import com.sensorsdata.analytics.android.sdk.advert.scan.IAdvertScanListener;
import com.sensorsdata.analytics.android.sdk.advert.utils.SAAdvertUtils;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.util.ToastUtil;
import org.json.JSONObject;

public class WhiteListScanHelper
implements IAdvertScanListener {
    @Override
    public void handlerScanUri(Activity activity, Uri uri) {
        ServerUrl serverUrl;
        String platform = uri.getQueryParameter("device_type");
        if (!"2".equals(platform)) {
            ToastUtil.showLong((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_whitelist_platform_error));
            SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            return;
        }
        String url = uri.getQueryParameter("apiurl");
        String info_id = uri.getQueryParameter("info_id");
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)info_id)) {
            ToastUtil.showLong((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_whitelist_request_falied));
            SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            return;
        }
        String project = uri.getQueryParameter("project");
        if (TextUtils.isEmpty((CharSequence)project)) {
            project = "default";
        }
        if (!project.equals((serverUrl = new ServerUrl(SensorsDataAPI.sharedInstance().getServerUrl())).getProject())) {
            ToastUtil.showLong((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_whitelist_project_error));
            SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            return;
        }
        WhiteListScanHelper.updateWhitelist(activity, url, info_id, project);
    }

    private static void updateWhitelist(final Activity activity, final String url, final String info_id, final String project) {
        new Thread(){

            @Override
            public void run() {
                try {
                    JSONObject json = new JSONObject();
                    json.put("android_oaid", (Object)SAOaidHelper.getOpenAdIdentifier((Context)activity));
                    json.put("android_id", (Object)SAAdvertUtils.getIdentifier((Context)activity));
                    json.put("android_imei", (Object)SAAdvertUtils.getInstallSource((Context)activity));
                    json.put("info_id", (Object)info_id);
                    json.put("project_name", (Object)project);
                    json.put("device_type", (Object)"2");
                    new RequestHelper.Builder(HttpMethod.POST, url).jsonData(json.toString()).callback((HttpCallback)new HttpCallback.JsonCallback(){

                        public void onFailure(int code, String errorMessage) {
                            ToastUtil.showLong((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_whitelist_request_falied));
                        }

                        public void onResponse(JSONObject response) {
                            int code = response.optInt("code", -1);
                            if (code == 0) {
                                ToastUtil.showLong((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_whitelist_request_success));
                            } else {
                                ToastUtil.showLong((Context)activity, (String)SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_ad_whitelist_request_falied));
                            }
                        }

                        public void onAfter() {
                            SensorsDataDialogUtils.startLaunchActivity((Context)activity);
                        }
                    }).execute();
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        }.start();
    }
}

