/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.OAIDService;

public class CoolpadImpl
implements IRomOAID {
    private final Context context;
    private static final String TAG = "SA.CoolpadImpl";
    private final OAIDService service;

    public CoolpadImpl(Context context) {
        this.context = context;
        this.service = new OAIDService();
    }

    @Override
    public boolean isSupported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.coolpad.deviceidsupport", 0);
            return pi != null;
        }
        catch (Throwable throwable) {
            SALog.i((String)TAG, (Throwable)throwable);
            return false;
        }
    }

    @Override
    public String getRomOAID() {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.coolpad.deviceidsupport", "com.coolpad.deviceidsupport.DeviceIdService"));
        String oaid = null;
        try {
            if (this.context.bindService(intent, (ServiceConnection)this.service, 1)) {
                CoolpadInterface anInterface = new CoolpadInterface(OAIDService.BINDER_QUEUE.take());
                oaid = anInterface.getOAID(this.context.getPackageName());
                this.context.unbindService((ServiceConnection)this.service);
            }
        }
        catch (Throwable throwable) {
            SALog.i((String)TAG, (Throwable)throwable);
        }
        return oaid;
    }

    static class CoolpadInterface
    implements IInterface {
        private final IBinder mIBinder;

        CoolpadInterface(IBinder iBinder) {
            this.mIBinder = iBinder;
        }

        public IBinder asBinder() {
            return this.mIBinder;
        }

        public String getOAID(String packageName) {
            String str = null;
            try {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                obtain.writeInterfaceToken("com.coolpad.deviceidsupport.IDeviceIdManager");
                obtain.writeString(packageName);
                this.mIBinder.transact(2, obtain, obtain2, 0);
                obtain2.readException();
                str = obtain2.readString();
                obtain.recycle();
                obtain2.recycle();
            }
            catch (Throwable th) {
                SALog.i((String)CoolpadImpl.TAG, (Throwable)th);
            }
            return str;
        }
    }
}

