/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;

class MeizuImpl
implements IRomOAID {
    private final Context mContext;
    private static final String TAG = "SA.MeizuImpl";

    public MeizuImpl(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean isSupported() {
        try {
            ProviderInfo pi = this.mContext.getPackageManager().resolveContentProvider("com.meizu.flyme.openidsdk", 0);
            return pi != null;
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
            return false;
        }
    }

    @Override
    public String getRomOAID() {
        Uri uri = Uri.parse((String)"content://com.meizu.flyme.openidsdk/");
        String oaid = null;
        try {
            Cursor cursor = this.mContext.getContentResolver().query(uri, null, null, new String[]{"oaid"}, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndex("value");
                oaid = cursor.getString(index);
                SALog.i((String)TAG, (String)("OAID query success: " + oaid));
                cursor.close();
            }
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
        }
        return oaid;
    }
}

