/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.OAIDService;
import java.security.MessageDigest;

class OppoImpl
implements IRomOAID {
    private final Context mContext;
    private final OAIDService mService;
    private static final String TAG = "SA.OppoImpl";
    private String mSign;

    public OppoImpl(Context context) {
        this.mContext = context;
        this.mService = new OAIDService();
    }

    @Override
    public boolean isSupported() {
        try {
            PackageInfo pi = this.mContext.getPackageManager().getPackageInfo("com.heytap.openid", 0);
            return pi != null;
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
            return false;
        }
    }

    @Override
    public String getRomOAID() {
        Intent intent = new Intent("action.com.heytap.openid.OPEN_ID_SERVICE");
        intent.setComponent(new ComponentName("com.heytap.openid", "com.heytap.openid.IdentifyService"));
        String oaid = null;
        try {
            if (this.mContext.bindService(intent, (ServiceConnection)this.mService, 1)) {
                oaid = this.realGetOUID();
                this.mContext.unbindService((ServiceConnection)this.mService);
            }
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
        }
        return oaid;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private String realGetOUID() {
        String pkgName = this.mContext.getPackageName();
        try {
            if (this.mSign == null) {
                Signature[] signatures = this.mContext.getPackageManager().getPackageInfo((String)pkgName, (int)64).signatures;
                byte[] byteArray = signatures[0].toByteArray();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                byte[] digest = messageDigest.digest(byteArray);
                StringBuilder sb = new StringBuilder();
                for (byte b : digest) {
                    sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
                }
                this.mSign = sb.toString();
                return this.getSerId(pkgName, this.mSign);
            }
            return this.getSerId(pkgName, this.mSign);
        }
        catch (Throwable throwable) {
            SALog.i((String)TAG, (Throwable)throwable);
            return null;
        }
    }

    private String getSerId(String pkgName, String sign) throws InterruptedException {
        OppoInterface anInterface = new OppoInterface(OAIDService.BINDER_QUEUE.take());
        return anInterface.getSerID(pkgName, sign, "OUID");
    }

    static class OppoInterface
    implements IInterface {
        private final IBinder mIBinder;

        OppoInterface(IBinder iBinder) {
            this.mIBinder = iBinder;
        }

        public IBinder asBinder() {
            return this.mIBinder;
        }

        public String getSerID(String packageName, String sign, String str) {
            String str4 = null;
            try {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                obtain.writeInterfaceToken("com.heytap.openid.IOpenID");
                obtain.writeString(packageName);
                obtain.writeString(sign);
                obtain.writeString(str);
                this.mIBinder.transact(1, obtain, obtain2, 0);
                obtain2.readException();
                str4 = obtain2.readString();
                obtain.recycle();
                obtain2.recycle();
            }
            catch (Throwable th) {
                SALog.i((String)OppoImpl.TAG, (Throwable)th);
            }
            return str4;
        }
    }
}

