/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.advert.oaid.SAOaidHelper;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelUtils {
    private static final String UTM_SOURCE_KEY = "SENSORS_ANALYTICS_UTM_SOURCE";
    private static final String UTM_MEDIUM_KEY = "SENSORS_ANALYTICS_UTM_MEDIUM";
    private static final String UTM_TERM_KEY = "SENSORS_ANALYTICS_UTM_TERM";
    private static final String UTM_CONTENT_KEY = "SENSORS_ANALYTICS_UTM_CONTENT";
    private static final String UTM_CAMPAIGN_KEY = "SENSORS_ANALYTICS_UTM_CAMPAIGN";
    private static final String SHARED_PREF_UTM = "sensorsdata.utm";
    private static final String SHARED_PREF_CORRECT_TRACK_INSTALLATION = "sensorsdata.correct.track.installation";
    private static HashSet<String> sChannelSourceKeySet = new HashSet();
    private static final HashMap<String, String> UTM_MAP = new HashMap<String, String>(){
        {
            this.put(ChannelUtils.UTM_SOURCE_KEY, "$utm_source");
            this.put(ChannelUtils.UTM_MEDIUM_KEY, "$utm_medium");
            this.put(ChannelUtils.UTM_TERM_KEY, "$utm_term");
            this.put(ChannelUtils.UTM_CONTENT_KEY, "$utm_content");
            this.put(ChannelUtils.UTM_CAMPAIGN_KEY, "$utm_campaign");
        }
    };
    private static final List<String> mDeepLinkBlackList = new ArrayList(){
        {
            this.add("io.dcloud.PandoraEntryActivity");
        }
    };
    private static final HashMap<String, String> UTM_LINK_MAP = new HashMap<String, String>(){
        {
            this.put(ChannelUtils.UTM_SOURCE_KEY, "utm_source");
            this.put(ChannelUtils.UTM_MEDIUM_KEY, "utm_medium");
            this.put(ChannelUtils.UTM_TERM_KEY, "utm_term");
            this.put(ChannelUtils.UTM_CONTENT_KEY, "utm_content");
            this.put(ChannelUtils.UTM_CAMPAIGN_KEY, "utm_campaign");
        }
    };
    private static final Map<String, String> LATEST_UTM_MAP = new HashMap<String, String>(){
        {
            this.put(ChannelUtils.UTM_SOURCE_KEY, "$latest_utm_source");
            this.put(ChannelUtils.UTM_MEDIUM_KEY, "$latest_utm_medium");
            this.put(ChannelUtils.UTM_TERM_KEY, "$latest_utm_term");
            this.put(ChannelUtils.UTM_CONTENT_KEY, "$latest_utm_content");
            this.put(ChannelUtils.UTM_CAMPAIGN_KEY, "$latest_utm_campaign");
        }
    };
    private static Map<String, String> sUtmProperties = new HashMap<String, String>();
    private static Map<String, String> sLatestUtmProperties = new HashMap<String, String>();

    public static JSONObject getUtmProperties() {
        if (sUtmProperties.size() > 0) {
            return new JSONObject(sUtmProperties);
        }
        return new JSONObject();
    }

    public static JSONObject getLatestUtmProperties() {
        if (sLatestUtmProperties.size() > 0) {
            return new JSONObject(sLatestUtmProperties);
        }
        return new JSONObject();
    }

    public static boolean hasUtmProperties(JSONObject properties) {
        if (properties == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : UTM_MAP.entrySet()) {
            if (entry == null || !properties.has(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLinkUtmProperties(Set<String> parameterNames) {
        if (parameterNames == null || parameterNames.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> entry : UTM_LINK_MAP.entrySet()) {
            if (entry == null || !parameterNames.contains(entry.getValue())) continue;
            return true;
        }
        for (String key : sChannelSourceKeySet) {
            if (TextUtils.isEmpty((CharSequence)key) || !sChannelSourceKeySet.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static String getDeviceInfo(Context mContext, String androidId, String oaid, String reflectionOAID) {
        return String.format("android_id=%s##imei=%s##imei_old=%s##imei_slot1=%s##imei_slot2=%s##imei_meid=%s##mac=%s##oaid=%s##oaid_reflection=%s", androidId, SensorsDataUtils.getInternationalIdentifier((Context)mContext), SensorsDataUtils.getInternationalIdOld((Context)mContext), SensorsDataUtils.getSlot((Context)mContext, (int)0), SensorsDataUtils.getSlot((Context)mContext, (int)1), SensorsDataUtils.getEquipmentIdentifier((Context)mContext), SensorsDataUtils.getMediaAddress((Context)mContext), oaid, reflectionOAID);
    }

    public static void mergeUtmByMetaData(Context context, JSONObject properties) throws JSONException {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : UTM_MAP.entrySet()) {
            String utmValue;
            if (entry == null || TextUtils.isEmpty((CharSequence)(utmValue = ChannelUtils.getApplicationMetaData(context, entry.getKey())))) continue;
            properties.put(entry.getValue(), (Object)utmValue);
        }
    }

    public static void setSourceChannelKeys(String ... sourceChannelKeys) {
        sChannelSourceKeySet.clear();
        if (sourceChannelKeys != null && sourceChannelKeys.length > 0) {
            for (String key : sourceChannelKeys) {
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                sChannelSourceKeySet.add(key);
            }
        }
    }

    public static void parseParams(Map<String, String> params) {
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, String> entry : UTM_LINK_MAP.entrySet()) {
                String utmKey = entry.getValue();
                String value = params.get(utmKey);
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                sUtmProperties.put(UTM_MAP.get(entry.getKey()), value);
                sLatestUtmProperties.put(LATEST_UTM_MAP.get(entry.getKey()), value);
            }
            for (String sourceKey : sChannelSourceKeySet) {
                try {
                    String value;
                    if (!SADataHelper.assertPropertyKey((String)sourceKey) || TextUtils.isEmpty((CharSequence)(value = params.get(sourceKey)))) continue;
                    sUtmProperties.put(sourceKey, value);
                    sLatestUtmProperties.put("_latest_" + sourceKey, value);
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        }
    }

    public static void loadUtmByLocal() {
        try {
            sLatestUtmProperties.clear();
            String channelJson = SAStoreManager.getInstance().getString(SHARED_PREF_UTM, "");
            if (!TextUtils.isEmpty((CharSequence)channelJson)) {
                JSONObject jsonObject = new JSONObject(channelJson);
                for (Map.Entry<String, String> entry : LATEST_UTM_MAP.entrySet()) {
                    String utmKey = entry.getValue();
                    if (!jsonObject.has(utmKey)) continue;
                    sLatestUtmProperties.put(utmKey, jsonObject.optString(utmKey));
                }
                for (String sourceKey : sChannelSourceKeySet) {
                    String latestSourceKey = "_latest_" + sourceKey;
                    if (!jsonObject.has(latestSourceKey)) continue;
                    sLatestUtmProperties.put(latestSourceKey, jsonObject.optString(latestSourceKey));
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void clearLocalUtm() {
        try {
            SAStoreManager.getInstance().setString(SHARED_PREF_UTM, "");
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void clearMemoryUtm() {
        sUtmProperties.clear();
        sLatestUtmProperties.clear();
    }

    public static void clearUtm() {
        ChannelUtils.clearMemoryUtm();
        ChannelUtils.clearLocalUtm();
    }

    public static void removeDeepLinkInfo(JSONObject jsonObject) {
        try {
            if (jsonObject == null) {
                return;
            }
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String latestKey = (String)keys.next();
                if (!latestKey.startsWith("$latest") && !latestKey.startsWith("_latest")) continue;
                keys.remove();
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    public static void saveDeepLinkInfo() {
        try {
            if (sLatestUtmProperties.size() > 0) {
                SAStoreManager.getInstance().setString(SHARED_PREF_UTM, sLatestUtmProperties.toString());
            } else {
                ChannelUtils.clearLocalUtm();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private static String getApplicationMetaData(Context mContext, String metaKey) {
        try {
            ApplicationInfo appInfo = mContext.getApplicationContext().getPackageManager().getApplicationInfo(mContext.getApplicationContext().getPackageName(), 128);
            String value = appInfo.metaData.getString(metaKey);
            int iValue = -1;
            if (value == null) {
                iValue = appInfo.metaData.getInt(metaKey, -1);
            }
            if (iValue != -1) {
                value = String.valueOf(iValue);
            }
            return value;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static JSONObject checkOrSetChannelCallbackEvent(String eventName, JSONObject properties, Context context) {
        if (properties == null) {
            properties = new JSONObject();
        }
        try {
            boolean isFirst = ChannelUtils.isFirstChannelEvent(eventName);
            properties.put("$is_channel_callback_event", isFirst);
            if (context != null && !ChannelUtils.hasUtmProperties(properties)) {
                ChannelUtils.mergeUtmByMetaData(context, properties);
            }
            properties.put("$channel_device_info", (Object)"1");
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        return properties;
    }

    public static boolean isFirstChannelEvent(String eventName) {
        boolean isDefault = SensorsDataAPI.getConfigOptions().getStorePlugins() == null || SensorsDataAPI.getConfigOptions().getStorePlugins().isEmpty();
        String secretEventName = isDefault ? eventName : (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptAES", new Object[]{eventName});
        boolean isFirst = DbAdapter.getInstance().isFirstChannelEvent(new String[]{secretEventName, eventName});
        if (isFirst) {
            DbAdapter.getInstance().addChannelEvent(secretEventName);
        }
        return isFirst;
    }

    public static boolean hasUtmByMetaData(Context context) {
        if (context == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : UTM_MAP.entrySet()) {
            String utmValue;
            if (entry == null || TextUtils.isEmpty((CharSequence)(utmValue = ChannelUtils.getApplicationMetaData(context, entry.getKey())))) continue;
            return true;
        }
        return false;
    }

    public static boolean isGetDeviceInfo(Context context, String androidId, String oaid) {
        try {
            return !TextUtils.isEmpty((CharSequence)androidId) || !TextUtils.isEmpty((CharSequence)oaid) || !TextUtils.isEmpty((CharSequence)SensorsDataUtils.getInternationalIdentifier((Context)context)) || !TextUtils.isEmpty((CharSequence)SensorsDataUtils.getInternationalIdOld((Context)context)) || !TextUtils.isEmpty((CharSequence)SensorsDataUtils.getSlot((Context)context, (int)0)) || !TextUtils.isEmpty((CharSequence)SensorsDataUtils.getSlot((Context)context, (int)1)) || !TextUtils.isEmpty((CharSequence)SensorsDataUtils.getEquipmentIdentifier((Context)context));
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return false;
        }
    }

    public static boolean isTrackInstallation() {
        try {
            return SAStoreManager.getInstance().isExists(SHARED_PREF_CORRECT_TRACK_INSTALLATION);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return false;
        }
    }

    public static boolean isCorrectTrackInstallation() {
        try {
            return SAStoreManager.getInstance().getBool(SHARED_PREF_CORRECT_TRACK_INSTALLATION, false);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return false;
        }
    }

    public static void saveCorrectTrackInstallation(boolean isCorrectTrackInstallation) {
        try {
            SAStoreManager.getInstance().setBool(SHARED_PREF_CORRECT_TRACK_INSTALLATION, isCorrectTrackInstallation);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static boolean checkDeviceInfo(Context context, String deviceInfo) {
        if (context == null || TextUtils.isEmpty((CharSequence)deviceInfo)) {
            return false;
        }
        String[] codes = deviceInfo.split("##");
        HashMap<String, String> deviceMaps = new HashMap<String, String>();
        if (codes.length == 0) {
            return false;
        }
        for (String code : codes) {
            String[] keyValue = code.trim().split("=");
            if (keyValue.length != 2) continue;
            deviceMaps.put(keyValue[0], keyValue[1]);
        }
        if (deviceMaps.isEmpty()) {
            return false;
        }
        return deviceMaps.containsKey("oaid") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("oaid")), (CharSequence)SAOaidHelper.getOpenAdIdentifier(context)) || deviceMaps.containsKey("imei") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("imei")), (CharSequence)SensorsDataUtils.getInternationalIdentifier((Context)context)) || deviceMaps.containsKey("imei_old") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("imei_old")), (CharSequence)SensorsDataUtils.getInternationalIdOld((Context)context)) || deviceMaps.containsKey("imei_slot1") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("imei_slot1")), (CharSequence)SensorsDataUtils.getSlot((Context)context, (int)0)) || deviceMaps.containsKey("imei_slot2") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("imei_slot2")), (CharSequence)SensorsDataUtils.getSlot((Context)context, (int)1)) || deviceMaps.containsKey("imei_meid") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("imei_meid")), (CharSequence)SensorsDataUtils.getEquipmentIdentifier((Context)context)) || deviceMaps.containsKey("android_id") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("android_id")), (CharSequence)SensorsDataUtils.getIdentifier((Context)context)) || deviceMaps.containsKey("mac") && TextUtils.equals((CharSequence)((CharSequence)deviceMaps.get("mac")), (CharSequence)SensorsDataUtils.getMediaAddress((Context)context));
    }

    public static boolean isDeepLinkBlackList(Activity activity) {
        if (activity != null) {
            for (String activityName : mDeepLinkBlackList) {
                try {
                    Class<?> clazz = Class.forName(activityName);
                    if (!clazz.isAssignableFrom(activity.getClass())) continue;
                    return true;
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        }
        return false;
    }

    public static boolean isExistRequestDeferredDeeplink() {
        return SAStoreManager.getInstance().isExists("request_deferrer_deeplink");
    }

    public static boolean isRequestDeferredDeeplink() {
        return SAStoreManager.getInstance().getBool("request_deferrer_deeplink", true);
    }

    public static void commitRequestDeferredDeeplink(boolean isRequest) {
        SAStoreManager.getInstance().setBool("request_deferrer_deeplink", isRequest);
    }
}

