/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.impl;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAAdvertisingConfig;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.DeepLinkManager;
import com.sensorsdata.analytics.android.sdk.advert.monitor.SensorsDataAdvertActivityLifeCallback;
import com.sensorsdata.analytics.android.sdk.advert.oaid.SAOaidHelper;
import com.sensorsdata.analytics.android.sdk.advert.plugin.LatestUtmPlugin;
import com.sensorsdata.analytics.android.sdk.advert.plugin.SAAdvertAppStartPlugin;
import com.sensorsdata.analytics.android.sdk.advert.plugin.SAAdvertAppViewScreenPlugin;
import com.sensorsdata.analytics.android.sdk.advert.scan.SAAdvertScanHelper;
import com.sensorsdata.analytics.android.sdk.advert.utils.ChannelUtils;
import com.sensorsdata.analytics.android.sdk.advert.utils.SAAdvertUtils;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeferredDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataLifecycleMonitorManager;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertiesFetcher;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertyFilter;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import java.util.Date;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class SAAdvertProtocolImpl {
    private final SAAdvertisingConfig mAdvertOptions;
    private SensorsDataAdvertActivityLifeCallback mLifecycleCallback;
    private final Context mContext;
    private final SAConfigOptions mOptions;
    private final SAContextManager mSAContextManager;
    private boolean mEnableDeepLinkInstallSource;
    private SAAdvertAppStartPlugin mStartPlugin;
    private SAAdvertAppViewScreenPlugin mViewScreenPlugin;
    private LatestUtmPlugin mLatestUtmPlugin;
    private SAPropertyPlugin mAdEventId;

    public SAAdvertProtocolImpl(SAContextManager contextManager) {
        this.mSAContextManager = contextManager;
        this.mContext = contextManager.getContext();
        this.mOptions = contextManager.getInternalConfigs().saConfigOptions;
        this.mAdvertOptions = this.mOptions.getAdvertConfig();
        this.init();
    }

    private void init() {
        this.mStartPlugin = new SAAdvertAppStartPlugin();
        this.mViewScreenPlugin = new SAAdvertAppViewScreenPlugin();
        this.mLatestUtmPlugin = new LatestUtmPlugin();
        this.mAdEventId = new SAPropertyPlugin(){

            public boolean isMatchedWithFilter(SAPropertyFilter filter) {
                if (SAAdvertProtocolImpl.this.mAdvertOptions != null && !TextUtils.isEmpty((CharSequence)((SAAdvertProtocolImpl)SAAdvertProtocolImpl.this).mAdvertOptions.serverUrl) && !((SAAdvertProtocolImpl)SAAdvertProtocolImpl.this).mAdvertOptions.eventNames.isEmpty()) {
                    return !TextUtils.isEmpty((CharSequence)filter.getEvent()) && ((SAAdvertProtocolImpl)SAAdvertProtocolImpl.this).mAdvertOptions.eventNames.contains(filter.getEvent());
                }
                return false;
            }

            public void properties(SAPropertiesFetcher fetcher) {
                try {
                    fetcher.getProperties().put("$sat_event_track_id", (Object)UUID.randomUUID().toString());
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        };
        ChannelUtils.setSourceChannelKeys(this.mOptions.channelSourceKeys);
        if (AppInfoUtils.isMainProcess((Context)this.mContext, null)) {
            ChannelUtils.commitRequestDeferredDeeplink(!ChannelUtils.isExistRequestDeferredDeeplink());
        }
    }

    protected void delayExecution() {
        try {
            if (this.mOptions.getDeeplinkCallback() != null) {
                DeepLinkManager.setDeferredDeepLinkCallback(this.mOptions.getDeeplinkCallback());
                if (this.mSAContextManager.getInternalConfigs().context instanceof Activity && this.mLifecycleCallback != null) {
                    this.mLifecycleCallback.onActivityStarted((Activity)this.mSAContextManager.getInternalConfigs().context);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public <T> T invokeModuleFunction(String methodName, Object ... argv) {
        switch (methodName) {
            case "trackInstallation": {
                if (argv.length == 3) {
                    this.trackInstallation((String)argv[0], (JSONObject)argv[1], (Boolean)argv[2]);
                    break;
                }
                if (argv.length == 2) {
                    this.trackInstallation((String)argv[0], (JSONObject)argv[1], false);
                    break;
                }
                this.trackInstallation((String)argv[0], null, false);
                break;
            }
            case "trackDeepLinkLaunch": {
                if (argv.length == 2) {
                    this.trackDeepLinkLaunch((String)argv[0], (String)argv[1]);
                    break;
                }
                this.trackDeepLinkLaunch((String)argv[0], null);
                break;
            }
            case "trackChannelEvent": {
                if (argv.length == 2) {
                    this.trackChannelEvent((String)argv[0], (JSONObject)argv[1]);
                    break;
                }
                this.trackChannelEvent((String)argv[0], null);
                break;
            }
            case "enableDeepLinkInstallSource": {
                this.enableDeepLinkInstallSource((Boolean)argv[0]);
                break;
            }
            case "setDeepLinkCallback": {
                DeepLinkManager.setDeepLinkCallback((SensorsDataDeepLinkCallback)argv[0]);
                break;
            }
            case "setDeepLinkCompletion": {
                DeepLinkManager.setDeferredDeepLinkCallback((SensorsDataDeferredDeepLinkCallback)argv[0]);
                break;
            }
            case "requestDeferredDeepLink": {
                this.requestDeferredDeepLink((JSONObject)argv[0]);
                break;
            }
            case "mergeChannelEventProperties": {
                return (T)this.mergeChannelEventProperties((String)argv[0], (JSONObject)argv[1]);
            }
            case "getLatestUtmProperties": {
                return (T)ChannelUtils.getLatestUtmProperties();
            }
            case "removeDeepLinkInfo": {
                ChannelUtils.removeDeepLinkInfo((JSONObject)argv[0]);
                break;
            }
            case "commitRequestDeferredDeeplink": {
                ChannelUtils.commitRequestDeferredDeeplink((Boolean)argv[0]);
                break;
            }
            case "handlerScanUri": {
                SAAdvertScanHelper.scanHandler((Activity)argv[0], (Uri)argv[1]);
                break;
            }
            case "sendEvent": {
                JSONObject rawJson;
                String eventName;
                if (this.mAdvertOptions == null || TextUtils.isEmpty((CharSequence)this.mAdvertOptions.serverUrl) || this.mAdvertOptions.eventNames.isEmpty() || TextUtils.isEmpty((CharSequence)(eventName = (rawJson = (JSONObject)argv[0]).optString("event"))) || !this.mAdvertOptions.eventNames.contains(eventName)) break;
                JSONObject event = (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptEventDataWithKey", new Object[]{rawJson, this.mAdvertOptions.secreteKey});
                SAAdvertUtils.sendData(this.mContext, this.mAdvertOptions.serverUrl, event, rawJson.toString());
            }
        }
        return null;
    }

    public void delayInitTask() {
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SAAdvertProtocolImpl.this.mOptions.isSaveDeepLinkInfo()) {
                        ChannelUtils.loadUtmByLocal();
                    } else {
                        ChannelUtils.clearLocalUtm();
                    }
                }
                catch (Exception ex) {
                    SALog.printStackTrace((Exception)ex);
                }
            }
        });
    }

    public void registerPropertyPlugin() {
        this.mSAContextManager.getPluginManager().registerPropertyPlugin((SAPropertyPlugin)this.mStartPlugin);
        this.mSAContextManager.getPluginManager().registerPropertyPlugin((SAPropertyPlugin)this.mViewScreenPlugin);
        this.mSAContextManager.getPluginManager().registerPropertyPlugin((SAPropertyPlugin)this.mLatestUtmPlugin);
        this.mSAContextManager.getPluginManager().registerPropertyPlugin(this.mAdEventId);
    }

    public void unregisterPropertyPlugin() {
        this.mSAContextManager.getPluginManager().unregisterPropertyPlugin((SAPropertyPlugin)this.mStartPlugin);
        this.mSAContextManager.getPluginManager().unregisterPropertyPlugin((SAPropertyPlugin)this.mViewScreenPlugin);
        this.mSAContextManager.getPluginManager().unregisterPropertyPlugin((SAPropertyPlugin)this.mLatestUtmPlugin);
        this.mSAContextManager.getPluginManager().unregisterPropertyPlugin(this.mAdEventId);
    }

    public void registerLifeCallback() {
        if (this.mLifecycleCallback == null) {
            this.mLifecycleCallback = new SensorsDataAdvertActivityLifeCallback(this.mOptions);
        }
        SensorsDataLifecycleMonitorManager.getInstance().addActivityLifeCallback((SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks)this.mLifecycleCallback);
    }

    public void unregisterLifecycleCallback() {
        if (this.mLifecycleCallback != null) {
            SensorsDataLifecycleMonitorManager.getInstance().removeActivityLifeCallback((SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks)this.mLifecycleCallback);
        }
    }

    private void trackDeepLinkLaunch(String deepLinkUrl, final String oaid) {
        final JSONObject properties = new JSONObject();
        try {
            properties.put("$deeplink_url", (Object)deepLinkUrl);
            properties.put("$time", (Object)new Date(System.currentTimeMillis()));
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                if (SAAdvertProtocolImpl.this.mEnableDeepLinkInstallSource) {
                    try {
                        String realOAID = oaid;
                        String reflectionOAID = "";
                        if (TextUtils.isEmpty((CharSequence)realOAID)) {
                            realOAID = SAOaidHelper.getOpenAdIdentifier(SAAdvertProtocolImpl.this.mContext);
                            reflectionOAID = SAOaidHelper.getOpenAdIdentifierByReflection(SAAdvertProtocolImpl.this.mContext);
                        }
                        properties.put("$ios_install_source", (Object)ChannelUtils.getDeviceInfo(SAAdvertProtocolImpl.this.mContext, SAAdvertUtils.getIdentifier(SAAdvertProtocolImpl.this.mContext), realOAID, reflectionOAID));
                    }
                    catch (JSONException e) {
                        SALog.printStackTrace((Exception)((Object)e));
                    }
                }
                SACoreHelper.getInstance().trackEvent(new InputData().setEventName("$AppDeeplinkLaunch").setProperties(properties));
            }
        });
    }

    private void trackInstallation(final String eventName, JSONObject properties, final boolean disableCallback) {
        try {
            if (!AppInfoUtils.isMainProcess((Context)this.mContext, null)) {
                return;
            }
            final JSONObject eventProperties = new JSONObject();
            JSONUtils.mergeJSONObject((JSONObject)properties, (JSONObject)eventProperties);
            SADataHelper.addTimeProperty((JSONObject)eventProperties);
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean firstTrackInstallation = SAAdvertUtils.isFirstTrackInstallation(disableCallback);
                        if (firstTrackInstallation) {
                            boolean isCorrectTrackInstallation = false;
                            try {
                                if (!ChannelUtils.hasUtmProperties(eventProperties)) {
                                    ChannelUtils.mergeUtmByMetaData(SAAdvertProtocolImpl.this.mContext, eventProperties);
                                }
                                if (!ChannelUtils.hasUtmProperties(eventProperties)) {
                                    String installSource;
                                    String oaid;
                                    String androidId = SAAdvertUtils.getIdentifier(SAAdvertProtocolImpl.this.mContext);
                                    if (eventProperties.has("$oaid")) {
                                        oaid = eventProperties.optString("$oaid");
                                        installSource = ChannelUtils.getDeviceInfo(SAAdvertProtocolImpl.this.mContext, androidId, oaid, "");
                                        SALog.i((String)"SA.Advert", (String)("properties has oaid " + oaid));
                                    } else {
                                        oaid = SAOaidHelper.getOpenAdIdentifier(SAAdvertProtocolImpl.this.mContext);
                                        installSource = ChannelUtils.getDeviceInfo(SAAdvertProtocolImpl.this.mContext, androidId, oaid, SAOaidHelper.getOpenAdIdentifierByReflection(SAAdvertProtocolImpl.this.mContext));
                                    }
                                    if (eventProperties.has("$gaid")) {
                                        installSource = String.format("%s##gaid=%s", installSource, eventProperties.optString("$gaid"));
                                    }
                                    isCorrectTrackInstallation = ChannelUtils.isGetDeviceInfo(SAAdvertProtocolImpl.this.mContext, androidId, oaid);
                                    eventProperties.put("$ios_install_source", (Object)installSource);
                                }
                                if (eventProperties.has("$oaid")) {
                                    eventProperties.remove("$oaid");
                                }
                                if (eventProperties.has("$gaid")) {
                                    eventProperties.remove("$gaid");
                                }
                                if (disableCallback) {
                                    eventProperties.put("$ios_install_disable_callback", disableCallback);
                                }
                            }
                            catch (Exception e) {
                                SALog.printStackTrace((Exception)e);
                            }
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName(eventName).setProperties(eventProperties));
                            JSONObject profileProperties = new JSONObject();
                            eventProperties.remove("$ios_install_disable_callback");
                            JSONUtils.mergeJSONObject((JSONObject)eventProperties, (JSONObject)profileProperties);
                            profileProperties.put("$first_visit_time", (Object)new Date());
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.PROFILE_SET_ONCE).setProperties(profileProperties));
                            SAAdvertUtils.setTrackInstallation(disableCallback);
                            ChannelUtils.saveCorrectTrackInstallation(isCorrectTrackInstallation);
                        }
                        SensorsDataAPI.sharedInstance().flush();
                    }
                    catch (Exception e) {
                        SALog.printStackTrace((Exception)e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private void trackChannelEvent(final String eventName, JSONObject properties) {
        if (this.mOptions.isAutoAddChannelCallbackEvent()) {
            SensorsDataAPI.sharedInstance().track(eventName, properties);
            return;
        }
        final JSONObject eventProperties = new JSONObject();
        JSONUtils.mergeJSONObject((JSONObject)properties, (JSONObject)eventProperties);
        SADataHelper.addTimeProperty((JSONObject)eventProperties);
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        eventProperties.put("$is_channel_callback_event", ChannelUtils.isFirstChannelEvent(eventName));
                        if (!ChannelUtils.hasUtmProperties(eventProperties)) {
                            ChannelUtils.mergeUtmByMetaData(SAAdvertProtocolImpl.this.mContext, eventProperties);
                        }
                        if (!ChannelUtils.hasUtmProperties(eventProperties)) {
                            if (eventProperties.has("$oaid")) {
                                String oaid = eventProperties.optString("$oaid");
                                eventProperties.put("$channel_device_info", (Object)ChannelUtils.getDeviceInfo(SAAdvertProtocolImpl.this.mContext, SAAdvertUtils.getIdentifier(SAAdvertProtocolImpl.this.mContext), oaid, ""));
                                SALog.i((String)"SA.Advert", (String)("properties has oaid " + oaid));
                            } else {
                                eventProperties.put("$channel_device_info", (Object)ChannelUtils.getDeviceInfo(SAAdvertProtocolImpl.this.mContext, SAAdvertUtils.getIdentifier(SAAdvertProtocolImpl.this.mContext), SAOaidHelper.getOpenAdIdentifier(SAAdvertProtocolImpl.this.mContext), SAOaidHelper.getOpenAdIdentifierByReflection(SAAdvertProtocolImpl.this.mContext)));
                            }
                        }
                        if (eventProperties.has("$oaid")) {
                            eventProperties.remove("$oaid");
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace((Exception)e);
                    }
                    SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName(eventName).setProperties(eventProperties));
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        });
    }

    private void enableDeepLinkInstallSource(boolean enable) {
        this.mEnableDeepLinkInstallSource = enable;
        DeepLinkManager.enableDeepLinkInstallSource(enable);
    }

    private void requestDeferredDeepLink(final JSONObject params) {
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ChannelUtils.isRequestDeferredDeeplink()) {
                        DeepLinkManager.requestDeferredDeepLink(SAAdvertProtocolImpl.this.mContext, params, SAAdvertUtils.getIdentifier(SAAdvertProtocolImpl.this.mContext), SAOaidHelper.getOpenAdIdentifier(SAAdvertProtocolImpl.this.mContext), SensorsDataAPI.sharedInstance().getPresetProperties(), SAAdvertProtocolImpl.this.mOptions.getCustomADChannelUrl(), SAAdvertProtocolImpl.this.mOptions.isSaveDeepLinkInfo());
                        ChannelUtils.commitRequestDeferredDeeplink(false);
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        });
    }

    private JSONObject mergeChannelEventProperties(String eventName, JSONObject properties) {
        if (this.mOptions.isAutoAddChannelCallbackEvent()) {
            return ChannelUtils.checkOrSetChannelCallbackEvent(eventName, properties, this.mContext);
        }
        return properties;
    }
}

