/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Looper;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.OAIDFactory;
import com.sensorsdata.analytics.android.sdk.core.business.SAPropertyManager;
import com.sensorsdata.analytics.android.sdk.internal.beans.LimitKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class SAOaidHelper {
    private static final String TAG = "SA.SAOaidHelper";
    private static String mOAID = "";
    private static String mReflectionOAID = "";
    private static CountDownLatch mCountDownLatch;
    private static Class<?> mIdentifyListener;
    private static Class<?> mIdSupplier;
    private static Class<?> jLibrary;
    private static Class<?> mMidSDKHelper;
    private static String mOidCertFilePath;
    private static final List<String> mLoadLibrary;

    public static synchronized String getOpenAdIdentifier(Context context) {
        if (SAPropertyManager.getInstance().isLimitKey(LimitKey.OAID)) {
            return SAPropertyManager.getInstance().getLimitValue(LimitKey.OAID);
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            SALog.i((String)TAG, (String)"function can not be called on main thread");
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)mOAID)) {
            return mOAID;
        }
        mOAID = SAOaidHelper.getMSAOAID(context);
        SALog.i((String)TAG, (String)("MSA OAID is " + mOAID));
        if (TextUtils.isEmpty((CharSequence)mOAID) || SAOaidHelper.allZero(mOAID)) {
            mReflectionOAID = SAOaidHelper.getROMOAID(context);
            if (TextUtils.isEmpty((CharSequence)mReflectionOAID) || SAOaidHelper.allZero(mReflectionOAID)) {
                mReflectionOAID = "";
            }
            mOAID = mReflectionOAID;
            SALog.i((String)TAG, (String)("Rom OAID is" + mOAID));
        }
        return mOAID;
    }

    private static boolean allZero(String id) {
        String replacedId = id.replace("-", "").replace("#", "").replace("_", "");
        for (int i = 0; i < replacedId.length(); ++i) {
            char c = replacedId.charAt(i);
            if (c == '0') continue;
            return false;
        }
        return true;
    }

    public static String getOpenAdIdentifierByReflection(Context context) {
        if (TextUtils.isEmpty((CharSequence)mOAID)) {
            SAOaidHelper.getOpenAdIdentifier(context);
        }
        return mReflectionOAID;
    }

    private static String getROMOAID(Context context) {
        return OAIDFactory.create(context).getRomOAID();
    }

    private static String getMSAOAID(Context context) {
        try {
            mCountDownLatch = new CountDownLatch(1);
            SAOaidHelper.initInvokeListener();
            if (mMidSDKHelper == null || mIdentifyListener == null || mIdSupplier == null) {
                SALog.i((String)TAG, (String)"OAID class create failed");
                return "";
            }
            if (!TextUtils.isEmpty((CharSequence)mOAID)) {
                return mOAID;
            }
            SAOaidHelper.getOAIDReflect(context, 2);
            try {
                mCountDownLatch.await();
            }
            catch (InterruptedException e) {
                SALog.printStackTrace((Exception)e);
            }
            SALog.i((String)TAG, (String)"CountDownLatch await");
            return mOAID;
        }
        catch (Throwable ex) {
            SALog.i((String)TAG, (String)ex.getMessage());
            return "";
        }
    }

    private static void getOAIDReflect(Context context, int retryCount) {
        block6: {
            try {
                if (retryCount == 0) {
                    return;
                }
                int INIT_ERROR_RESULT_DELAY = 1008614;
                int INIT_ERROR_RESULT_OK = 1008610;
                SAOaidHelper.initPemCert(context);
                if (jLibrary != null) {
                    Method initEntry = jLibrary.getDeclaredMethod("InitEntry", Context.class);
                    initEntry.invoke(null, context);
                }
                IdentifyListenerHandler handler = new IdentifyListenerHandler();
                Method initSDK = mMidSDKHelper.getDeclaredMethod("InitSdk", Context.class, Boolean.TYPE, mIdentifyListener);
                int errCode = (Integer)initSDK.invoke(null, context, true, Proxy.newProxyInstance(context.getClassLoader(), new Class[]{mIdentifyListener}, (InvocationHandler)handler));
                SALog.i((String)TAG, (String)("MdidSdkHelper ErrorCode : " + errCode));
                if (errCode != 1008614 && errCode != 1008610) {
                    SAOaidHelper.getOAIDReflect(context, --retryCount);
                    if (retryCount == 0) {
                        mCountDownLatch.countDown();
                    }
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        mCountDownLatch.countDown();
                    }
                }).start();
            }
            catch (Throwable ex) {
                SALog.i((String)TAG, (String)ex.getMessage());
                SAOaidHelper.getOAIDReflect(context, --retryCount);
                if (retryCount != 0) break block6;
                mCountDownLatch.countDown();
            }
        }
    }

    private static void initInvokeListener() {
        try {
            mMidSDKHelper = Class.forName("com.bun.miitmdid.core.MdidSdkHelper");
        }
        catch (ClassNotFoundException e) {
            SALog.i((String)TAG, (String)e.getMessage());
            return;
        }
        try {
            mIdentifyListener = Class.forName("com.bun.miitmdid.interfaces.IIdentifierListener");
            mIdSupplier = Class.forName("com.bun.miitmdid.interfaces.IdSupplier");
            return;
        }
        catch (Exception exception) {
            try {
                mIdentifyListener = Class.forName("com.bun.supplier.IIdentifierListener");
                mIdSupplier = Class.forName("com.bun.supplier.IdSupplier");
                jLibrary = Class.forName("com.bun.miitmdid.core.JLibrary");
                return;
            }
            catch (Exception exception2) {
                try {
                    mIdentifyListener = Class.forName("com.bun.miitmdid.core.IIdentifierListener");
                    mIdSupplier = Class.forName("com.bun.miitmdid.supplier.IdSupplier");
                    jLibrary = Class.forName("com.bun.miitmdid.core.JLibrary");
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private static void initSDKLibrary() {
        for (String library : mLoadLibrary) {
            try {
                System.loadLibrary(library);
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }

    private static void initPemCert(Context context) {
        try {
            String oaidCert = SAOaidHelper.loadPemFromAssetFile(context);
            if (!TextUtils.isEmpty((CharSequence)oaidCert)) {
                Method initCert = mMidSDKHelper.getDeclaredMethod("InitCert", Context.class, String.class);
                initCert.invoke(null, context, oaidCert);
            }
        }
        catch (Throwable e) {
            SALog.i((String)TAG, (String)e.getMessage());
        }
    }

    private static String loadPemFromAssetFile(Context context) {
        try {
            String line;
            InputStream is;
            String defaultPemCert = context.getPackageName() + ".cert.pem";
            AssetManager assetManager = context.getAssets();
            if (!TextUtils.isEmpty((CharSequence)mOidCertFilePath)) {
                try {
                    is = assetManager.open(mOidCertFilePath);
                }
                catch (IOException e) {
                    is = assetManager.open(defaultPemCert);
                }
            } else {
                is = assetManager.open(defaultPemCert);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            return builder.toString();
        }
        catch (IOException e) {
            SALog.i((String)TAG, (String)"loadPemFromAssetFile failed");
            return "";
        }
    }

    public static void setOaidCertFilePath(String filePath) {
        mOidCertFilePath = filePath;
    }

    static {
        mLoadLibrary = new LinkedList<String>(){
            {
                this.add("msaoaidsec");
                this.add("nllvm1632808251147706677");
                this.add("nllvm1630571663641560568");
                this.add("nllvm1623827671");
            }
        };
        SAOaidHelper.initSDKLibrary();
    }

    static class IdentifyListenerHandler
    implements InvocationHandler {
        IdentifyListenerHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("OnSupport".equalsIgnoreCase(method.getName())) {
                    Method getOAID = mIdSupplier.getDeclaredMethod("getOAID", new Class[0]);
                    if (args.length == 1) {
                        mOAID = (String)getOAID.invoke(args[0], new Object[0]);
                    } else {
                        mOAID = (String)getOAID.invoke(args[1], new Object[0]);
                    }
                    SALog.i((String)SAOaidHelper.TAG, (String)("oaid:" + mOAID));
                    mCountDownLatch.countDown();
                }
            }
            catch (Throwable ex) {
                mCountDownLatch.countDown();
            }
            return null;
        }
    }
}

