/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.pageleave;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.autotrack.core.business.SAPageTools;
import com.sensorsdata.analytics.android.autotrack.utils.AppPageLeaveUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.exceptions.SensorsDataExceptionHandler;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityPageLeaveCallbacks
implements SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks,
SensorsDataExceptionHandler.SAExceptionListener {
    private static final String START_TIME = "sa_start_time";
    private final HashMap<Integer, JSONObject> mResumedActivities = new HashMap();
    private List<Class<?>> mIgnoreList;
    private final String DIALOG_ACTIVITY = "com.sensorsdata.sf.ui.view.DialogActivity";
    private final boolean mIsEmpty;

    public ActivityPageLeaveCallbacks(List<Class<?>> ignoreList) {
        if (ignoreList != null && !ignoreList.isEmpty()) {
            this.mIgnoreList = ignoreList;
            this.mIsEmpty = false;
        } else {
            this.mIsEmpty = true;
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (!this.ignorePage(activity)) {
            this.trackActivityStart(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        try {
            int hashCode = activity.hashCode();
            if (this.mResumedActivities.containsKey(hashCode)) {
                JSONObject properties = this.mResumedActivities.get(hashCode);
                String referrer = properties == null ? "" : properties.optString("$referrer");
                long startTime = properties == null ? 0L : properties.optLong(START_TIME);
                properties = SAPageInfoUtils.getActivityPageInfo((Activity)activity);
                properties.put(START_TIME, startTime);
                String url = SAPageTools.getScreenUrl(activity);
                properties.put("$url", (Object)url);
                if (!TextUtils.isEmpty((CharSequence)referrer)) {
                    properties.put("$referrer", (Object)referrer);
                }
                this.trackAppPageLeave(properties);
                this.mResumedActivities.remove(hashCode);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onNewIntent(Intent intent) {
    }

    public void uncaughtException(Thread t, Throwable e) {
        try {
            Iterator<Integer> keyCodes = this.mResumedActivities.keySet().iterator();
            while (keyCodes.hasNext()) {
                int hashCode = keyCodes.next();
                JSONObject properties = this.mResumedActivities.get(hashCode);
                if (properties == null) continue;
                this.trackAppPageLeave(properties);
                keyCodes.remove();
            }
        }
        catch (Exception exception) {
            SALog.printStackTrace((Exception)exception);
        }
    }

    private void trackActivityStart(Activity activity) {
        try {
            if ("com.sensorsdata.sf.ui.view.DialogActivity".equals(activity.getClass().getCanonicalName())) {
                return;
            }
            JSONObject properties = SAPageInfoUtils.getActivityPageInfo((Activity)activity);
            String url = SAPageTools.getScreenUrl(activity);
            properties.put("$url", (Object)url);
            String referrer = AppPageLeaveUtils.getLastScreenUrl();
            if (!properties.has("$referrer") && !TextUtils.isEmpty((CharSequence)referrer)) {
                properties.put("$referrer", (Object)referrer);
            }
            properties.put(START_TIME, SystemClock.elapsedRealtime());
            this.mResumedActivities.put(activity.hashCode(), properties);
            AppPageLeaveUtils.setLastScreenUrl(url);
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    private void trackAppPageLeave(final JSONObject properties) {
        try {
            long resumeTime = properties.optLong(START_TIME);
            properties.remove(START_TIME);
            Float duration = TimeUtils.duration((long)resumeTime, (long)SystemClock.elapsedRealtime());
            if ((double)duration.floatValue() < 0.05) {
                return;
            }
            properties.put("event_duration", (Object)duration);
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.sharedInstance().getSAContextManager().trackEvent(new InputData().setEventName("$AppPageLeave").setProperties(properties).setEventType(EventType.TRACK));
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private boolean ignorePage(Object fragment) {
        if (!this.mIsEmpty) {
            return this.mIgnoreList.contains(fragment.getClass());
        }
        return false;
    }
}

