/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.utils;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RatingBar;
import android.widget.ToggleButton;
import com.sensorsdata.analytics.android.autotrack.R;
import com.sensorsdata.analytics.android.autotrack.core.beans.ViewContext;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.ScreenAutoTracker;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AopUtil {
    private static final String TAG = "SA.AopUtil";

    public static JSONObject buildTitleNoAutoTrackerProperties(Activity activity) {
        JSONObject propertyJSON;
        try {
            ScreenAutoTracker screenAutoTracker;
            JSONObject trackProperties;
            propertyJSON = SAViewUtils.buildTitleAndScreenName((Activity)activity);
            if (activity instanceof ScreenAutoTracker && (trackProperties = (screenAutoTracker = (ScreenAutoTracker)activity).getTrackProperties()) != null) {
                if (trackProperties.has("$screen_name")) {
                    propertyJSON.put("$screen_name", (Object)trackProperties.optString("$screen_name"));
                }
                if (trackProperties.has("$title")) {
                    propertyJSON.put("$title", (Object)trackProperties.optString("$title"));
                }
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
            return new JSONObject();
        }
        return propertyJSON;
    }

    public static JSONObject injectClickInfo(ViewContext viewContext, JSONObject properties, boolean isFromUser) {
        if (viewContext.view == null) {
            return properties;
        }
        try {
            JSONObject p;
            Object fragment;
            Activity activity;
            String viewText;
            if (!AopUtil.isTrackEvent(viewContext.view, isFromUser)) {
                return null;
            }
            Context context = viewContext.view.getContext();
            JSONObject eventJson = new JSONObject();
            String idString = SAViewUtils.getViewId((View)viewContext.view);
            if (!TextUtils.isEmpty((CharSequence)idString)) {
                eventJson.put("$element_id", (Object)idString);
            }
            if (!TextUtils.isEmpty((CharSequence)(viewText = SAViewUtils.getViewContent((View)viewContext.view)))) {
                eventJson.put("$element_content", (Object)viewText);
            }
            eventJson.put("$element_type", (Object)SAViewUtils.getViewType((View)viewContext.view));
            Activity activity2 = activity = viewContext.activity != null ? viewContext.activity : SAViewUtils.getActivityOfView((Context)context, (View)viewContext.view);
            if (activity != null) {
                JSONUtils.mergeJSONObject((JSONObject)SAPageInfoUtils.getActivityPageInfo((Activity)activity), (JSONObject)eventJson);
            }
            Object object = fragment = viewContext.fragment != null ? viewContext.fragment : SAFragmentUtils.getFragmentFromView((View)viewContext.view, (Activity)activity);
            if (fragment != null) {
                JSONUtils.mergeJSONObject((JSONObject)SAPageInfoUtils.getFragmentPageInfo((Activity)activity, (Object)fragment), (JSONObject)eventJson);
            }
            if ((p = (JSONObject)viewContext.view.getTag(R.id.sensors_analytics_tag_view_properties)) != null) {
                JSONUtils.mergeJSONObject((JSONObject)p, (JSONObject)eventJson);
            }
            JSONUtils.mergeDistinctProperty((JSONObject)eventJson, (JSONObject)properties);
            return properties;
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
            return properties;
        }
    }

    static boolean isTrackEvent(View view, boolean isFromUser) {
        if (view instanceof CheckBox ? !isFromUser : (view instanceof RadioButton ? !isFromUser : (view instanceof ToggleButton ? !isFromUser : view instanceof CompoundButton && !isFromUser))) {
            return false;
        }
        if (view instanceof RatingBar) {
            return isFromUser;
        }
        return true;
    }
}

