/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.utils;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TabHost;
import com.sensorsdata.analytics.android.autotrack.core.beans.ViewContext;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import java.lang.reflect.Field;

public class AutoTrackViewUtils {
    public static ViewContext getTabLayoutContext(Object objectTab, View tabLayoutView) {
        try {
            Object fragment = null;
            Activity activity = null;
            if (objectTab instanceof Context) {
                activity = SAViewUtils.getActivityOfView((Context)((Context)objectTab), null);
            } else {
                Field[] fields;
                for (Field field : fields = objectTab.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    Object bridgeObject = field.get(objectTab);
                    if (bridgeObject instanceof Activity) {
                        activity = (Activity)bridgeObject;
                        break;
                    }
                    if (SAFragmentUtils.isFragment((Object)bridgeObject)) {
                        fragment = bridgeObject;
                        break;
                    }
                    if (!(bridgeObject instanceof View)) continue;
                    View view = (View)bridgeObject;
                    activity = SAViewUtils.getActivityOfView((Context)view.getContext(), null);
                    break;
                }
            }
            if (tabLayoutView != null) {
                if (activity == null) {
                    activity = SAViewUtils.getActivityOfView((Context)tabLayoutView.getContext(), null);
                }
                if (fragment == null) {
                    fragment = SAFragmentUtils.getFragmentFromView((View)tabLayoutView, (Activity)activity);
                }
            }
            if (activity == null && fragment != null) {
                activity = SAFragmentUtils.getActivityFromFragment(fragment);
            }
            return new ViewContext(activity, fragment, tabLayoutView);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return null;
        }
    }

    public static View getTabView(String tabName) {
        View view = WindowHelper.getClickView((String)tabName);
        if (view != null) {
            View currentView = view;
            View tabHostView = null;
            while (null == tabHostView && null != currentView && null != currentView.getParent()) {
                if (!((currentView = (View)currentView.getParent()) instanceof TabHost)) continue;
                tabHostView = currentView;
            }
            if (null != tabHostView && SAViewUtils.isViewIgnored(tabHostView)) {
                return null;
            }
        }
        return view;
    }

    public static String getTabLayoutText(View view, Object tab) {
        String viewText = null;
        try {
            if (view != null) {
                if (view instanceof ViewGroup) {
                    StringBuilder stringBuilder = new StringBuilder();
                    viewText = SAViewUtils.traverseView((StringBuilder)stringBuilder, (ViewGroup)((ViewGroup)view));
                    if (!TextUtils.isEmpty((CharSequence)viewText)) {
                        viewText = viewText.substring(0, viewText.length() - 1);
                    }
                } else {
                    viewText = SAViewUtils.getViewContent((View)view);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        if (TextUtils.isEmpty(viewText)) {
            viewText = (String)ReflectUtil.callMethod((Object)tab, (String)"getText", (Object[])new Object[0]);
        }
        return viewText;
    }

    public static View getTabLayout(Object tab) {
        View view = AutoTrackViewUtils.getAndroidXTabLayout(tab);
        if (view == null) {
            view = AutoTrackViewUtils.getSupportTabLayout(tab);
        }
        return view;
    }

    private static View getSupportTabLayout(Object tab) {
        View view = null;
        try {
            Class<?> supportTabLayoutCLass = Class.forName("android.support.design.widget.TabLayout");
            if (SAViewUtils.isViewIgnored(supportTabLayoutCLass)) {
                return null;
            }
            if (ReflectUtil.isInstance((Object)tab, (String[])new String[]{"android.support.design.widget.TabLayout$Tab"}) && null != (view = (View)ReflectUtil.findField((String[])new String[]{"android.support.design.widget.TabLayout$Tab"}, (Object)tab, (String[])new String[]{"mParent"})) && ReflectUtil.isInstance((Object)view, (String[])new String[]{"android.support.design.widget.TabLayout"}) && SAViewUtils.isViewIgnored((View)view)) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return view;
    }

    private static View getAndroidXTabLayout(Object tab) {
        View view = null;
        try {
            Class<?> androidXTabLayoutCLass = Class.forName("com.google.android.material.tabs.TabLayout");
            if (SAViewUtils.isViewIgnored(androidXTabLayoutCLass)) {
                return null;
            }
            if (ReflectUtil.isInstance((Object)tab, (String[])new String[]{"com.google.android.material.tabs.TabLayout$Tab"}) && null != (view = (View)ReflectUtil.findField((String[])new String[]{"com.google.android.material.tabs.TabLayout$Tab"}, (Object)tab, (String[])new String[]{"parent"})) && ReflectUtil.isInstance((Object)view, (String[])new String[]{"com.google.android.material.tabs.TabLayout"}) && SAViewUtils.isViewIgnored((View)view)) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return view;
    }
}

