/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core;

import android.app.Activity;
import android.app.Dialog;
import android.view.View;
import com.sensorsdata.analytics.android.autotrack.aop.FragmentTrackHelper;
import com.sensorsdata.analytics.android.autotrack.core.autotrack.ActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.autotrack.core.autotrack.FragmentViewScreenCallbacks;
import com.sensorsdata.analytics.android.autotrack.core.business.SAPageTools;
import com.sensorsdata.analytics.android.autotrack.core.impl.AutoTrackProtocolIml;
import com.sensorsdata.analytics.android.autotrack.core.pageleave.ActivityPageLeaveCallbacks;
import com.sensorsdata.analytics.android.autotrack.core.pageleave.FragmentPageLeaveCallbacks;
import com.sensorsdata.analytics.android.autotrack.core.plugins.AutoTrackEventPlugin;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.exceptions.SensorsDataExceptionHandler;
import com.sensorsdata.analytics.android.sdk.internal.beans.InternalConfigOptions;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataLifecycleMonitorManager;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import java.util.List;
import org.json.JSONObject;

public class AutoTrackContextHelper {
    private static final String TAG = "AutoTrackContextHelper";
    private final InternalConfigOptions mInternalConfigs;
    private final SAContextManager mSAContextManager;
    private ActivityLifecycleCallbacks mActivityLifecycleCallbacks;
    private final AutoTrackProtocolIml mProtocolImp;

    public AutoTrackContextHelper(SAContextManager contextManager) {
        this.mSAContextManager = contextManager;
        this.mInternalConfigs = this.mSAContextManager.getInternalConfigs();
        this.mProtocolImp = new AutoTrackProtocolIml(contextManager);
        this.registerListener();
        this.mSAContextManager.getPluginManager().registerPropertyPlugin((SAPropertyPlugin)new AutoTrackEventPlugin());
        try {
            if (contextManager.getInternalConfigs().context instanceof Activity) {
                this.delayExecution((Activity)contextManager.getInternalConfigs().context);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void registerListener() {
        this.mActivityLifecycleCallbacks = new ActivityLifecycleCallbacks(this.mSAContextManager);
        SensorsDataLifecycleMonitorManager.getInstance().addActivityLifeCallback((SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks)this.mActivityLifecycleCallbacks);
        SensorsDataExceptionHandler.addExceptionListener((SensorsDataExceptionHandler.SAExceptionListener)this.mActivityLifecycleCallbacks);
        FragmentTrackHelper.addFragmentCallbacks(new FragmentViewScreenCallbacks());
        if (this.mInternalConfigs.saConfigOptions.isTrackPageLeave()) {
            ActivityPageLeaveCallbacks pageLeaveCallbacks = new ActivityPageLeaveCallbacks(this.mInternalConfigs.saConfigOptions.getIgnorePageLeave());
            SensorsDataLifecycleMonitorManager.getInstance().addActivityLifeCallback((SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks)pageLeaveCallbacks);
            SensorsDataExceptionHandler.addExceptionListener((SensorsDataExceptionHandler.SAExceptionListener)pageLeaveCallbacks);
            if (this.mInternalConfigs.saConfigOptions.isTrackFragmentPageLeave()) {
                FragmentPageLeaveCallbacks fragmentPageLeaveCallbacks = new FragmentPageLeaveCallbacks(this.mInternalConfigs.saConfigOptions.getIgnorePageLeave());
                FragmentTrackHelper.addFragmentCallbacks(fragmentPageLeaveCallbacks);
                SensorsDataExceptionHandler.addExceptionListener((SensorsDataExceptionHandler.SAExceptionListener)fragmentPageLeaveCallbacks);
            }
        }
    }

    protected void delayExecution(Activity activity) {
        if (this.mActivityLifecycleCallbacks != null) {
            this.mActivityLifecycleCallbacks.onActivityCreated(activity, null);
            this.mActivityLifecycleCallbacks.onActivityStarted(activity);
        }
        if (SALog.isLogEnabled()) {
            SALog.i((String)TAG, (String)("SDK init success by\uff1a" + activity.getClass().getName()));
        }
    }

    public <T> T invokeModuleFunction(String methodName, Object ... argv) {
        switch (methodName) {
            case "enableAutoTrack": {
                this.mProtocolImp.enableAutoTrack((List)argv[0]);
                break;
            }
            case "disableAutoTrack": {
                if (argv[0] instanceof SensorsDataAPI.AutoTrackEventType) {
                    this.mProtocolImp.disableAutoTrack((SensorsDataAPI.AutoTrackEventType)argv[0]);
                    break;
                }
                this.mProtocolImp.disableAutoTrack((List)argv[0]);
                break;
            }
            case "isAutoTrackEnabled": {
                return (T)Boolean.valueOf(this.mProtocolImp.isAutoTrackEnabled());
            }
            case "ignoreAutoTrackActivities": {
                this.mProtocolImp.ignoreAutoTrackActivities((List)argv[0]);
                break;
            }
            case "resumeAutoTrackActivities": {
                this.mProtocolImp.resumeAutoTrackActivities((List)argv[0]);
                break;
            }
            case "ignoreAutoTrackActivity": {
                this.mProtocolImp.ignoreAutoTrackActivity((Class)argv[0]);
                break;
            }
            case "resumeAutoTrackActivity": {
                this.mProtocolImp.resumeAutoTrackActivity((Class)argv[0]);
                break;
            }
            case "ignoreAutoTrackFragments": {
                this.mProtocolImp.ignoreAutoTrackFragments((List)argv[0]);
                break;
            }
            case "ignoreAutoTrackFragment": {
                this.mProtocolImp.ignoreAutoTrackFragment((Class)argv[0]);
                break;
            }
            case "resumeIgnoredAutoTrackFragments": {
                this.mProtocolImp.resumeIgnoredAutoTrackFragments((List)argv[0]);
                break;
            }
            case "resumeIgnoredAutoTrackFragment": {
                this.mProtocolImp.resumeIgnoredAutoTrackFragment((Class)argv[0]);
                break;
            }
            case "isActivityAutoTrackAppViewScreenIgnored": {
                return (T)Boolean.valueOf(this.mProtocolImp.isActivityAutoTrackAppViewScreenIgnored((Class)argv[0]));
            }
            case "isActivityAutoTrackAppClickIgnored": {
                return (T)Boolean.valueOf(this.mProtocolImp.isActivityAutoTrackAppClickIgnored((Class)argv[0]));
            }
            case "isTrackFragmentAppViewScreenEnabled": {
                return (T)Boolean.valueOf(this.mProtocolImp.isTrackFragmentAppViewScreenEnabled());
            }
            case "isFragmentAutoTrackAppViewScreen": {
                return (T)Boolean.valueOf(this.mProtocolImp.isFragmentAutoTrackAppViewScreen((Class)argv[0]));
            }
            case "isAutoTrackEventTypeIgnored": {
                if (argv[0] instanceof Integer) {
                    return (T)Boolean.valueOf(this.mProtocolImp.isAutoTrackEventTypeIgnored((Integer)argv[0]));
                }
                return (T)Boolean.valueOf(this.mProtocolImp.isAutoTrackEventTypeIgnored((SensorsDataAPI.AutoTrackEventType)argv[0]));
            }
            case "setViewID": {
                if (argv[0] instanceof View) {
                    this.mProtocolImp.setViewID((View)argv[0], (String)argv[1]);
                    break;
                }
                if (argv[0] instanceof Dialog) {
                    this.mProtocolImp.setViewID((Dialog)argv[0], (String)argv[1]);
                    break;
                }
                this.mProtocolImp.setViewID(argv[0], (String)argv[1]);
                break;
            }
            case "setViewActivity": {
                this.mProtocolImp.setViewActivity((View)argv[0], (Activity)argv[1]);
                break;
            }
            case "setViewFragmentName": {
                this.mProtocolImp.setViewFragmentName((View)argv[0], (String)argv[1]);
                break;
            }
            case "trackFragmentAppViewScreen": {
                this.mProtocolImp.trackFragmentAppViewScreen();
                break;
            }
            case "enableAutoTrackFragment": {
                this.mProtocolImp.enableAutoTrackFragment((Class)argv[0]);
                break;
            }
            case "enableAutoTrackFragments": {
                this.mProtocolImp.enableAutoTrackFragments((List)argv[0]);
                break;
            }
            case "ignoreView": {
                if (argv.length == 1) {
                    this.mProtocolImp.ignoreView((View)argv[0]);
                    break;
                }
                this.mProtocolImp.ignoreView((View)argv[0], (Boolean)argv[1]);
                break;
            }
            case "setViewProperties": {
                this.mProtocolImp.setViewProperties((View)argv[0], (JSONObject)argv[1]);
                break;
            }
            case "getIgnoredViewTypeList": {
                return (T)this.mProtocolImp.getIgnoredViewTypeList();
            }
            case "ignoreViewType": {
                this.mProtocolImp.ignoreViewType((Class)argv[0]);
                break;
            }
            case "getLastScreenUrl": {
                return (T)this.mProtocolImp.getLastScreenUrl();
            }
            case "clearReferrerWhenAppEnd": {
                this.mProtocolImp.clearReferrerWhenAppEnd();
                break;
            }
            case "getLastScreenTrackProperties": {
                return (T)this.mProtocolImp.getLastScreenTrackProperties();
            }
            case "clearLastScreenUrl": {
                this.mProtocolImp.clearLastScreenUrl();
                break;
            }
            case "trackViewScreen": {
                if (argv.length == 1) {
                    if (argv[0] instanceof Activity) {
                        this.mProtocolImp.trackViewScreen((Activity)argv[0]);
                        break;
                    }
                    this.mProtocolImp.trackViewScreen(argv[0]);
                    break;
                }
                this.mProtocolImp.trackViewScreen((String)argv[0], (JSONObject)argv[1]);
                break;
            }
            case "trackViewAppClick": {
                if (argv.length == 1) {
                    this.mProtocolImp.trackViewAppClick((View)argv[0]);
                    break;
                }
                this.mProtocolImp.trackViewAppClick((View)argv[0], (JSONObject)argv[1]);
                break;
            }
            case "getReferrerScreenTitle": {
                return (T)SAPageTools.getReferrerTitle();
            }
        }
        return null;
    }
}

