/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.autotrack;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.GridView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.TabHost;
import com.sensorsdata.analytics.android.autotrack.R;
import com.sensorsdata.analytics.android.autotrack.core.beans.ViewContext;
import com.sensorsdata.analytics.android.autotrack.core.business.SAPageTools;
import com.sensorsdata.analytics.android.autotrack.utils.AopUtil;
import com.sensorsdata.analytics.android.autotrack.utils.AutoTrackViewUtils;
import com.sensorsdata.analytics.android.autotrack.utils.KeyboardViewUtil;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsAdapterViewItemTrackProperties;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsExpandableListViewItemTrackProperties;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AppClickTrackImpl {
    private static final String TAG = "AppClickTrackImpl";
    private static final HashMap<Integer, Long> eventTimestamp = new HashMap();

    public static void trackExpandableListViewOnGroupClick(SensorsDataAPI sensorsDataAPI, ExpandableListView expandableListView, View view, int groupPosition) {
        try {
            if (expandableListView == null || view == null || AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI)) {
                return;
            }
            ViewContext viewContext = AppClickTrackImpl.getAppClickViewContext((View)expandableListView, ExpandableListView.class);
            if (viewContext == null) {
                return;
            }
            JSONObject properties = AppClickTrackImpl.buildPageProperty(viewContext.activity, viewContext.fragment);
            String idString = SAViewUtils.getViewId((View)expandableListView);
            if (!TextUtils.isEmpty((CharSequence)idString)) {
                properties.put("$element_id", (Object)idString);
            }
            properties.put("$element_type", (Object)"ExpandableListView");
            String viewText = null;
            if (view instanceof ViewGroup) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    viewText = SAViewUtils.traverseView((StringBuilder)stringBuilder, (ViewGroup)((ViewGroup)view));
                    if (!TextUtils.isEmpty((CharSequence)viewText)) {
                        viewText = viewText.substring(0, viewText.length() - 1);
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            } else {
                viewText = SAViewUtils.getViewContent((View)view);
            }
            if (!TextUtils.isEmpty((CharSequence)viewText)) {
                properties.put("$element_content", (Object)viewText);
            }
            JSONUtils.mergeJSONObject((JSONObject)AppClickTrackImpl.getExpandListViewExtendProperty(expandableListView, groupPosition, -1), (JSONObject)properties);
            JSONUtils.mergeJSONObject((JSONObject)((JSONObject)view.getTag(R.id.sensors_analytics_tag_view_properties)), (JSONObject)properties);
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, view);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackExpandableListViewOnChildClick(SensorsDataAPI sensorsDataAPI, ExpandableListView expandableListView, View view, int groupPosition, int childPosition) {
        try {
            if (expandableListView == null || view == null || SAViewUtils.isViewIgnored((View)view) || AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI)) {
                return;
            }
            ViewContext viewContext = AppClickTrackImpl.getAppClickViewContext((View)expandableListView, ExpandableListView.class);
            if (viewContext == null) {
                return;
            }
            JSONObject properties = AppClickTrackImpl.buildPageProperty(viewContext.activity, viewContext.fragment);
            String idString = SAViewUtils.getViewId((View)expandableListView);
            if (!TextUtils.isEmpty((CharSequence)idString)) {
                properties.put("$element_id", (Object)idString);
            }
            properties.put("$element_type", (Object)"ExpandableListView");
            String viewText = null;
            if (view instanceof ViewGroup) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    viewText = SAViewUtils.traverseView((StringBuilder)stringBuilder, (ViewGroup)((ViewGroup)view));
                    if (!TextUtils.isEmpty((CharSequence)viewText)) {
                        viewText = viewText.substring(0, viewText.length() - 1);
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            } else {
                viewText = SAViewUtils.getViewContent((View)view);
            }
            if (!TextUtils.isEmpty((CharSequence)viewText)) {
                properties.put("$element_content", (Object)viewText);
            }
            JSONUtils.mergeJSONObject((JSONObject)AppClickTrackImpl.getExpandListViewExtendProperty(expandableListView, groupPosition, childPosition), (JSONObject)properties);
            JSONUtils.mergeJSONObject((JSONObject)((JSONObject)view.getTag(R.id.sensors_analytics_tag_view_properties)), (JSONObject)properties);
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, view);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackTabHost(SensorsDataAPI sensorsDataAPI, String tabName) {
        try {
            if (AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI)) {
                return;
            }
            ViewContext viewContext = AppClickTrackImpl.getAppClickViewContext(AutoTrackViewUtils.getTabView(tabName), TabHost.class);
            if (viewContext == null) {
                return;
            }
            JSONObject properties = null;
            try {
                properties = AppClickTrackImpl.buildPageProperty(viewContext.activity, viewContext.fragment);
                String elementContent = SAViewUtils.getViewContent((View)viewContext.view);
                if (TextUtils.isEmpty((CharSequence)elementContent)) {
                    elementContent = tabName;
                }
                properties.put("$element_content", (Object)elementContent);
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            if (properties == null) {
                properties = new JSONObject();
            }
            properties.put("$element_type", (Object)"TabHost");
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, viewContext.view);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackTabLayoutSelected(SensorsDataAPI sensorsDataAPI, Object objectTab, Object tab) {
        try {
            if (tab == null || AppClickTrackImpl.isDeBounceTrack(tab) || AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI)) {
                return;
            }
            View tabLayout = AutoTrackViewUtils.getTabLayout(tab);
            ViewContext viewContext = AutoTrackViewUtils.getTabLayoutContext(objectTab, tabLayout);
            if (viewContext == null) {
                return;
            }
            if (viewContext.activity != null && sensorsDataAPI.isActivityAutoTrackAppClickIgnored(viewContext.activity.getClass())) {
                return;
            }
            if (viewContext.fragment != null && sensorsDataAPI.isActivityAutoTrackAppClickIgnored(viewContext.fragment.getClass())) {
                return;
            }
            JSONObject properties = AppClickTrackImpl.buildPageProperty(viewContext.activity, viewContext.fragment);
            properties.put("$element_type", (Object)"TabLayout");
            Class<?> currentTabClass = null;
            try {
                currentTabClass = Class.forName("com.google.android.material.tabs.TabLayout$Tab");
            }
            catch (Exception e) {
                try {
                    currentTabClass = Class.forName("android.support.design.widget.TabLayout$Tab");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            View tabView = null;
            if (currentTabClass != null) {
                boolean isBindViewPager;
                View tabCustomView = (View)ReflectUtil.findField(currentTabClass, (Object)tab, (String[])new String[]{"mCustomView", "customView"});
                String text = AutoTrackViewUtils.getTabLayoutText(tabCustomView, tab);
                if (text != null) {
                    properties.put("$element_content", (Object)text);
                }
                if (tabCustomView == null || tabCustomView.getId() == -1) {
                    tabCustomView = tabLayout;
                }
                if (tabCustomView != null) {
                    String resourceId;
                    if (tabCustomView.getId() != -1 && viewContext.activity != null && !TextUtils.isEmpty((CharSequence)(resourceId = viewContext.activity.getResources().getResourceEntryName(tabCustomView.getId())))) {
                        properties.put("$element_id", (Object)resourceId);
                    }
                    JSONObject p = (JSONObject)tabCustomView.getTag(R.id.sensors_analytics_tag_view_properties);
                    JSONUtils.mergeJSONObject((JSONObject)p, (JSONObject)properties);
                }
                if ((tabView = (View)ReflectUtil.findField(currentTabClass, (Object)tab, (String[])new String[]{"view"})) == null) {
                    tabView = (View)ReflectUtil.findField(currentTabClass, (Object)tab, (String[])new String[]{"mView"});
                }
                if (tabLayout != null && tabView != null && ((isBindViewPager = AutoTrackViewUtils.isBindViewPager(tabLayout)) && !tabView.isPressed() || !isBindViewPager && tabView.isPressed())) {
                    properties.put("$referrer_title", (Object)SAPageTools.getCurrentTitle());
                }
            }
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, tabView);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackMenuItem(SensorsDataAPI sensorsDataAPI, Object object, MenuItem menuItem) {
        try {
            if (menuItem == null || AppClickTrackImpl.isDeBounceTrack(menuItem) || AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI)) {
                return;
            }
            ViewContext viewContext = AppClickTrackImpl.getAppClickViewContext(object, WindowHelper.getClickView((MenuItem)menuItem), MenuItem.class);
            if (viewContext == null) {
                return;
            }
            JSONObject properties = AppClickTrackImpl.buildPageProperty(viewContext.activity, viewContext.fragment);
            try {
                String idString;
                if (viewContext.activity != null && !TextUtils.isEmpty((CharSequence)(idString = viewContext.activity.getResources().getResourceEntryName(menuItem.getItemId())))) {
                    properties.put("$element_id", (Object)idString);
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            if (menuItem.getTitle() != null) {
                String elementContent = menuItem.getTitle().toString();
                if (viewContext.view != null && TextUtils.isEmpty((CharSequence)elementContent)) {
                    elementContent = SAViewUtils.getViewContent((View)viewContext.view);
                }
                properties.put("$element_content", (Object)elementContent);
            }
            properties.put("$element_type", (Object)"MenuItem");
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, viewContext.view);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackRadioGroup(SensorsDataAPI sensorsDataAPI, RadioGroup view, int checkedId) {
        try {
            if (view == null || AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI)) {
                return;
            }
            View childView = view.findViewById(checkedId);
            if (childView == null || !childView.isPressed()) {
                return;
            }
            ViewContext viewContext = AppClickTrackImpl.getAppClickViewContext((View)view, RadioGroup.class);
            if (viewContext == null) {
                return;
            }
            JSONObject properties = AppClickTrackImpl.buildPageProperty(viewContext.activity, viewContext.fragment);
            String idString = SAViewUtils.getViewId((View)view);
            if (!TextUtils.isEmpty((CharSequence)idString)) {
                properties.put("$element_id", (Object)idString);
            }
            properties.put("$element_type", (Object)SAViewUtils.getViewType((View)childView));
            RadioButton radioButton = null;
            try {
                if (viewContext.activity != null && (radioButton = (RadioButton)viewContext.activity.findViewById(view.getCheckedRadioButtonId())) != null && !TextUtils.isEmpty((CharSequence)radioButton.getText())) {
                    properties.put("$element_content", (Object)radioButton.getText().toString());
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            JSONObject p = (JSONObject)view.getTag(R.id.sensors_analytics_tag_view_properties);
            JSONUtils.mergeJSONObject((JSONObject)p, (JSONObject)properties);
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, (View)radioButton);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackDialog(SensorsDataAPI sensorsDataAPI, DialogInterface dialogInterface, int whichButton) {
        try {
            if (AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI) || SAViewUtils.isViewIgnored(Dialog.class)) {
                return;
            }
            JSONObject properties = new JSONObject();
            Dialog dialog = null;
            if (dialogInterface instanceof Dialog) {
                dialog = (Dialog)dialogInterface;
            }
            if (dialog == null || AppClickTrackImpl.isDeBounceTrack(dialog)) {
                return;
            }
            Context context = dialog.getContext();
            Activity activity = SAViewUtils.getActivityOfView((Context)context, null);
            if (activity == null) {
                activity = dialog.getOwnerActivity();
            }
            if (activity == null || sensorsDataAPI.isActivityAutoTrackAppClickIgnored(activity.getClass())) {
                return;
            }
            JSONUtils.mergeJSONObject((JSONObject)SAPageInfoUtils.getActivityPageInfo((Activity)activity), (JSONObject)properties);
            try {
                String idString;
                Window window = dialog.getWindow();
                if (window != null && window.isActive() && !TextUtils.isEmpty((CharSequence)(idString = (String)dialog.getWindow().getDecorView().getTag(R.id.sensors_analytics_tag_view_id)))) {
                    properties.put("$element_id", (Object)idString);
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            JSONUtils.mergeDuplicateProperty((JSONObject)SAPageInfoUtils.getRNPageInfo(), (JSONObject)properties);
            properties.put("$element_type", (Object)"Dialog");
            Class<?> currentAlertDialogClass = null;
            try {
                currentAlertDialogClass = Class.forName("android.support.v7.app.AlertDialog");
            }
            catch (Exception e) {
                try {
                    currentAlertDialogClass = Class.forName("androidx.appcompat.app.AlertDialog");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (currentAlertDialogClass == null) {
                return;
            }
            Button view = null;
            if (dialog instanceof AlertDialog) {
                AlertDialog alertDialog = (AlertDialog)dialog;
                Button button = alertDialog.getButton(whichButton);
                if (button != null) {
                    if (!TextUtils.isEmpty((CharSequence)button.getText())) {
                        properties.put("$element_content", (Object)button.getText());
                    }
                    view = button;
                } else {
                    ListView listView = alertDialog.getListView();
                    if (listView != null) {
                        ListAdapter listAdapter = listView.getAdapter();
                        Object object = listAdapter.getItem(whichButton);
                        if (object != null && object instanceof String) {
                            properties.put("$element_content", object);
                        }
                        view = listView.getChildAt(whichButton);
                    }
                }
            } else if (currentAlertDialogClass.isInstance(dialog)) {
                Button button = null;
                try {
                    Method getButtonMethod = dialog.getClass().getMethod("getButton", Integer.TYPE);
                    button = (Button)getButtonMethod.invoke((Object)dialog, whichButton);
                }
                catch (Exception getButtonMethod) {
                    // empty catch block
                }
                if (button != null) {
                    if (!TextUtils.isEmpty((CharSequence)button.getText())) {
                        properties.put("$element_content", (Object)button.getText());
                    }
                    view = button;
                } else {
                    try {
                        Method getListViewMethod = dialog.getClass().getMethod("getListView", new Class[0]);
                        ListView listView = (ListView)getListViewMethod.invoke((Object)dialog, new Object[0]);
                        if (listView != null) {
                            ListAdapter listAdapter = listView.getAdapter();
                            Object object = listAdapter.getItem(whichButton);
                            if (object != null && object instanceof String) {
                                properties.put("$element_content", object);
                            }
                            view = listView.getChildAt(whichButton);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, view);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackListView(SensorsDataAPI sensorsDataAPI, AdapterView<?> adapterView, View view, int position) {
        try {
            String viewText;
            Adapter adapter;
            String idString;
            if (view == null || AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI) || SAViewUtils.isViewIgnored(adapterView) || KeyboardViewUtil.isKeyboardView(view)) {
                return;
            }
            Class<ListView> viewType = null;
            String element_type = "";
            if (adapterView instanceof ListView) {
                viewType = ListView.class;
                element_type = "ListView";
            } else if (adapterView instanceof GridView) {
                viewType = GridView.class;
                element_type = "GridView";
            } else if (adapterView instanceof Spinner) {
                viewType = Spinner.class;
                element_type = "Spinner";
            }
            ViewContext viewContext = AppClickTrackImpl.getAppClickViewContext(adapterView, view, viewType);
            if (viewContext == null) {
                return;
            }
            JSONObject properties = AppClickTrackImpl.buildPageProperty(viewContext.activity, viewContext.fragment);
            if (!TextUtils.isEmpty((CharSequence)element_type)) {
                properties.put("$element_type", (Object)element_type);
            }
            if (!TextUtils.isEmpty((CharSequence)(idString = SAViewUtils.getViewId(adapterView)))) {
                properties.put("$element_id", (Object)idString);
            }
            if ((adapter = adapterView.getAdapter()) instanceof HeaderViewListAdapter) {
                adapter = ((HeaderViewListAdapter)adapter).getWrappedAdapter();
            }
            if (adapter instanceof SensorsAdapterViewItemTrackProperties) {
                try {
                    SensorsAdapterViewItemTrackProperties objectProperties = (SensorsAdapterViewItemTrackProperties)adapter;
                    JSONObject jsonObject = objectProperties.getSensorsItemTrackProperties(position);
                    JSONUtils.mergeJSONObject((JSONObject)jsonObject, (JSONObject)properties);
                }
                catch (JSONException e) {
                    SALog.printStackTrace((Exception)((Object)e));
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(viewText = SAViewUtils.getViewContent((View)view)))) {
                properties.put("$element_content", (Object)viewText);
            }
            JSONObject p = (JSONObject)view.getTag(R.id.sensors_analytics_tag_view_properties);
            JSONUtils.mergeJSONObject((JSONObject)p, (JSONObject)properties);
            AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, view);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackDrawerOpened(SensorsDataAPI sensorsDataAPI, View view) {
        try {
            if (view == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("$element_content", (Object)"Open");
            sensorsDataAPI.setViewProperties(view, jsonObject);
            AppClickTrackImpl.trackViewOnClick(sensorsDataAPI, view, view.isPressed());
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackDrawerClosed(SensorsDataAPI sensorsDataAPI, View view) {
        try {
            if (view == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("$element_content", (Object)"Close");
            sensorsDataAPI.setViewProperties(view, jsonObject);
            AppClickTrackImpl.trackViewOnClick(sensorsDataAPI, view, view.isPressed());
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackViewOnClick(SensorsDataAPI sensorsDataAPI, View view, boolean isFromUser) {
        try {
            if (view == null || AppClickTrackImpl.isAppClickIgnore(sensorsDataAPI) || AppClickTrackImpl.isDeBounceTrack(view) || KeyboardViewUtil.isKeyboardView(view)) {
                return;
            }
            ViewContext viewContext = AppClickTrackImpl.getAppClickViewContext(view, view.getClass());
            if (viewContext == null) {
                return;
            }
            JSONObject properties = new JSONObject();
            if ((properties = AopUtil.injectClickInfo(viewContext, properties, isFromUser)) != null) {
                AppClickTrackImpl.trackAutoEvent(sensorsDataAPI, properties, view);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void track(final SensorsDataAPI sensorsDataAPI, final String eventName, String properties) {
        try {
            if (TextUtils.isEmpty((CharSequence)eventName)) {
                return;
            }
            JSONObject pro = null;
            if (!TextUtils.isEmpty((CharSequence)properties)) {
                try {
                    pro = new JSONObject(properties);
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
            final JSONObject finalPro = pro;
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    sensorsDataAPI.getSAContextManager().trackEvent(new InputData().setEventName(eventName).setProperties(finalPro).setEventType(EventType.TRACK));
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private static void trackAutoEvent(final SensorsDataAPI sensorsDataAPI, final JSONObject properties, final View view) {
        final JSONObject eventProperties = SADataHelper.appendLibMethodAutoTrack((JSONObject)properties);
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                if (view != null) {
                    SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "mergeVisualProperties", new Object[]{properties, view});
                }
                sensorsDataAPI.getSAContextManager().trackEvent(new InputData().setEventName("$AppClick").setEventType(EventType.TRACK).setProperties(eventProperties));
            }
        });
    }

    private static boolean isAppClickIgnore(SensorsDataAPI sensorsDataAPI) {
        return !sensorsDataAPI.isAutoTrackEnabled() || sensorsDataAPI.isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_CLICK);
    }

    private static ViewContext getAppClickViewContext(View view, Class<?> classType) {
        return AppClickTrackImpl.getAppClickViewContext(null, view, classType);
    }

    private static ViewContext getAppClickViewContext(Object parent, View view, Class<?> classType) {
        Activity activity;
        Context context;
        if (SAViewUtils.isViewIgnored(classType)) {
            return null;
        }
        Context context2 = context = parent instanceof Context ? (Context)parent : null;
        if (view != null) {
            if (SAViewUtils.isViewIgnored((View)view)) {
                return null;
            }
            if (context == null && (context = view.getContext()) == null) {
                return null;
            }
        }
        if ((activity = SAViewUtils.getActivityOfView((Context)context, (View)view)) != null && SensorsDataAPI.sharedInstance().isActivityAutoTrackAppClickIgnored(activity.getClass())) {
            return null;
        }
        Object fragment = SAFragmentUtils.getFragmentFromView((View)view, (Activity)activity);
        if (fragment != null && SensorsDataAPI.sharedInstance().isActivityAutoTrackAppClickIgnored(fragment.getClass())) {
            return null;
        }
        return new ViewContext(activity, fragment, view);
    }

    private static JSONObject getExpandListViewExtendProperty(ExpandableListView expandableListView, int groupPosition, int childPosition) {
        try {
            ExpandableListAdapter listAdapter = expandableListView.getExpandableListAdapter();
            if (listAdapter instanceof SensorsExpandableListViewItemTrackProperties) {
                SensorsExpandableListViewItemTrackProperties trackProperties = (SensorsExpandableListViewItemTrackProperties)listAdapter;
                return childPosition == -1 ? trackProperties.getSensorsGroupItemTrackProperties(groupPosition) : trackProperties.getSensorsChildItemTrackProperties(groupPosition, childPosition);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return null;
    }

    public static JSONObject buildPageProperty(Activity activity, Object fragment) {
        JSONObject properties = new JSONObject();
        if (fragment != null) {
            JSONUtils.mergeJSONObject((JSONObject)SAPageInfoUtils.getFragmentPageInfo((Activity)activity, (Object)fragment), (JSONObject)properties);
        } else if (activity != null) {
            JSONUtils.mergeJSONObject((JSONObject)SAPageInfoUtils.getActivityPageInfo((Activity)activity), (JSONObject)properties);
        }
        return properties;
    }

    private static boolean isDeBounceTrack(Object object) {
        long lastOnClickTimestamp;
        long currentOnClickTimestamp = SystemClock.elapsedRealtime();
        Long targetObject = eventTimestamp.get(object.hashCode());
        if (targetObject != null && currentOnClickTimestamp - (lastOnClickTimestamp = targetObject.longValue()) < 500L) {
            return true;
        }
        eventTimestamp.put(object.hashCode(), currentOnClickTimestamp);
        return false;
    }
}

