/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.pageleave;

import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.autotrack.core.autotrack.SAFragmentLifecycleCallbacks;
import com.sensorsdata.analytics.android.autotrack.core.business.SAPageTools;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.exceptions.SensorsDataExceptionHandler;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.util.Dispatcher;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class FragmentPageLeaveCallbacks
implements SAFragmentLifecycleCallbacks,
SensorsDataExceptionHandler.SAExceptionListener {
    private final HashMap<Integer, JSONObject> mResumedFragments = new HashMap();
    private List<Class<?>> mIgnoreList;
    private final boolean mIsEmpty;
    private static final String START_TIME = "sa_start_time";

    public FragmentPageLeaveCallbacks(List<Class<?>> ignoreList) {
        if (ignoreList != null && !ignoreList.isEmpty()) {
            this.mIgnoreList = ignoreList;
            this.mIsEmpty = false;
        } else {
            this.mIsEmpty = true;
        }
    }

    @Override
    public void onCreate(Object object) {
    }

    @Override
    public void onViewCreated(Object object, View rootView, Bundle bundle) {
    }

    @Override
    public void onStart(Object object) {
    }

    @Override
    public void onResume(Object object) {
        if (!this.ignorePage(object) && SAFragmentUtils.isFragmentVisible((Object)object)) {
            this.trackFragmentStart(object);
        }
    }

    @Override
    public void onPause(Object object) {
        try {
            int hashCode = object.hashCode();
            if (this.mResumedFragments.containsKey(hashCode)) {
                this.trackAppPageLeave(object);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public void onStop(Object object) {
    }

    @Override
    public void onHiddenChanged(Object object, boolean hidden) {
        if (!this.ignorePage(object)) {
            if (SAFragmentUtils.isFragmentVisible((Object)object)) {
                this.trackFragmentStart(object);
            } else {
                this.trackAppPageLeave(object);
            }
        }
    }

    @Override
    public void setUserVisibleHint(Object object, boolean isVisibleToUser) {
        if (!this.ignorePage(object)) {
            if (SAFragmentUtils.isFragmentVisible((Object)object)) {
                this.trackFragmentStart(object);
            } else {
                this.trackAppPageLeave(object);
            }
        }
    }

    private void trackAppPageLeave(Object object) {
        try {
            int hashCode = object.hashCode();
            if (this.mResumedFragments.containsKey(hashCode)) {
                JSONObject properties = this.mResumedFragments.get(hashCode);
                this.mResumedFragments.remove(hashCode);
                this.trackPageLeaveEvent(properties);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private void trackFragmentStart(final Object object) {
        Dispatcher.getInstance().postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    String referrer;
                    JSONObject properties = new JSONObject();
                    properties.put(FragmentPageLeaveCallbacks.START_TIME, SystemClock.elapsedRealtime());
                    String url = SAPageTools.getScreenUrl(object);
                    properties.put("$url", (Object)url);
                    if (SensorsDataAPI.sharedInstance().isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_VIEW_SCREEN) || !SensorsDataAPI.sharedInstance().isTrackFragmentAppViewScreenEnabled()) {
                        SAPageTools.setCurrentScreenUrl(url);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(referrer = SAPageTools.getReferrer()))) {
                        properties.put("$referrer", (Object)referrer);
                    }
                    properties.put("$referrer_title", (Object)SAPageTools.getReferrerTitle());
                    JSONUtils.mergeJSONObject((JSONObject)SAPageInfoUtils.getFragmentPageInfo(null, (Object)object), (JSONObject)properties);
                    SALog.i((String)"SA.FragmentPageLeave", (String)("trackFragmentStart = " + properties));
                    FragmentPageLeaveCallbacks.this.mResumedFragments.put(object.hashCode(), properties);
                }
                catch (JSONException e) {
                    SALog.printStackTrace((Exception)((Object)e));
                }
            }
        }, 300L);
    }

    public void uncaughtException(Thread t, Throwable e) {
        try {
            Iterator<Integer> keyCodes = this.mResumedFragments.keySet().iterator();
            while (keyCodes.hasNext()) {
                int hashCode = keyCodes.next();
                JSONObject properties = this.mResumedFragments.get(hashCode);
                if (properties == null) continue;
                this.trackPageLeaveEvent(properties);
                keyCodes.remove();
            }
        }
        catch (Exception exception) {
            SALog.printStackTrace((Exception)exception);
        }
    }

    private void trackPageLeaveEvent(final JSONObject properties) {
        try {
            long resumeTime = properties.optLong(START_TIME);
            properties.remove(START_TIME);
            Float duration = TimeUtils.duration((long)resumeTime, (long)SystemClock.elapsedRealtime());
            if ((double)duration.floatValue() < 0.05) {
                return;
            }
            properties.put("event_duration", (Object)duration);
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.sharedInstance().getSAContextManager().trackEvent(new InputData().setEventName("$AppPageLeave").setProperties(properties).setEventType(EventType.TRACK));
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private boolean ignorePage(Object fragment) {
        if (!this.mIsEmpty) {
            return this.mIgnoreList.contains(fragment.getClass());
        }
        return false;
    }
}

