/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.impl;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import com.sensorsdata.analytics.android.autotrack.R;
import com.sensorsdata.analytics.android.autotrack.core.beans.ViewContext;
import com.sensorsdata.analytics.android.autotrack.core.business.SAPageTools;
import com.sensorsdata.analytics.android.autotrack.core.impl.FragmentAPI;
import com.sensorsdata.analytics.android.autotrack.utils.AopUtil;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.ScreenAutoTracker;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataFragmentTitle;
import com.sensorsdata.analytics.android.sdk.SensorsDataIgnoreTrackAppClick;
import com.sensorsdata.analytics.android.sdk.SensorsDataIgnoreTrackAppViewScreen;
import com.sensorsdata.analytics.android.sdk.SensorsDataIgnoreTrackAppViewScreenAndAppClick;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.core.mediator.autotrack.AutoTrackProtocol;
import com.sensorsdata.analytics.android.sdk.core.mediator.autotrack.IFragmentAPI;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class AutoTrackProtocolIml
implements AutoTrackProtocol {
    private static final String TAG = "SA.AutoTrackProtocolIml";
    protected IFragmentAPI mFragmentAPI;
    private final SAConfigOptions mSAConfigOptions;
    private final SAContextManager mContextManager;
    protected List<Class<?>> mIgnoredViewTypeList = new ArrayList();
    protected List<Integer> mAutoTrackIgnoredActivities;
    protected boolean mClearReferrerWhenAppEnd = false;
    protected boolean mAutoTrack;

    public AutoTrackProtocolIml(SAContextManager contextManager) {
        this.mFragmentAPI = new FragmentAPI();
        this.mAutoTrackIgnoredActivities = new ArrayList<Integer>();
        this.mContextManager = contextManager;
        this.mSAConfigOptions = contextManager.getInternalConfigs().saConfigOptions;
        Bundle configBundle = AppInfoUtils.getAppInfoBundle((Context)this.mContextManager.getContext());
        this.mAutoTrack = configBundle.getBoolean("com.sensorsdata.analytics.android.AutoTrack", false);
        if (this.mSAConfigOptions.getAutoTrackEventType() != 0) {
            this.enableAutoTrack(this.mSAConfigOptions.getAutoTrackEventType());
            this.mAutoTrack = true;
        }
    }

    public void enableAutoTrack(List<SensorsDataAPI.AutoTrackEventType> eventTypeList) {
        try {
            if (eventTypeList == null || eventTypeList.isEmpty()) {
                return;
            }
            this.mAutoTrack = true;
            for (SensorsDataAPI.AutoTrackEventType autoTrackEventType : eventTypeList) {
                this.mSAConfigOptions.setAutoTrackEventType(this.mSAConfigOptions.getAutoTrackEventType() | autoTrackEventType.eventValue);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void disableAutoTrack(List<SensorsDataAPI.AutoTrackEventType> eventTypeList) {
        try {
            if (eventTypeList == null) {
                return;
            }
            if (this.mSAConfigOptions.getAutoTrackEventType() == 0) {
                return;
            }
            for (SensorsDataAPI.AutoTrackEventType autoTrackEventType : eventTypeList) {
                if ((this.mSAConfigOptions.getAutoTrackEventType() | autoTrackEventType.eventValue) != this.mSAConfigOptions.getAutoTrackEventType()) continue;
                this.mSAConfigOptions.setAutoTrackEventType(this.mSAConfigOptions.getAutoTrackEventType() ^ autoTrackEventType.eventValue);
            }
            if (this.mSAConfigOptions.getAutoTrackEventType() == 0) {
                this.mAutoTrack = false;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void disableAutoTrack(SensorsDataAPI.AutoTrackEventType autoTrackEventType) {
        try {
            if (autoTrackEventType == null) {
                return;
            }
            if (this.mSAConfigOptions.getAutoTrackEventType() == 0) {
                return;
            }
            int union = this.mSAConfigOptions.getAutoTrackEventType() | autoTrackEventType.eventValue;
            if (union == autoTrackEventType.eventValue) {
                this.mSAConfigOptions.setAutoTrackEventType(0);
            } else {
                this.mSAConfigOptions.setAutoTrackEventType(autoTrackEventType.eventValue ^ union);
            }
            if (this.mSAConfigOptions.getAutoTrackEventType() == 0) {
                this.mAutoTrack = false;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public boolean isAutoTrackEnabled() {
        Boolean isAutoTrackEnabled;
        if (this.mContextManager.getRemoteManager() != null && (isAutoTrackEnabled = this.mContextManager.getRemoteManager().isAutoTrackEnabled()) != null) {
            return isAutoTrackEnabled;
        }
        return this.mAutoTrack;
    }

    public void ignoreAutoTrackActivities(List<Class<?>> activitiesList) {
        if (activitiesList == null || activitiesList.size() == 0) {
            return;
        }
        if (this.mAutoTrackIgnoredActivities == null) {
            this.mAutoTrackIgnoredActivities = new ArrayList<Integer>();
        }
        for (Class<?> activity : activitiesList) {
            int hashCode;
            if (activity == null || this.mAutoTrackIgnoredActivities.contains(hashCode = activity.hashCode())) continue;
            this.mAutoTrackIgnoredActivities.add(hashCode);
        }
    }

    public void resumeAutoTrackActivities(List<Class<?>> activitiesList) {
        if (activitiesList == null || activitiesList.size() == 0) {
            return;
        }
        if (this.mAutoTrackIgnoredActivities == null) {
            this.mAutoTrackIgnoredActivities = new ArrayList<Integer>();
        }
        try {
            for (Class<?> activity : activitiesList) {
                int hashCode;
                if (activity == null || !this.mAutoTrackIgnoredActivities.contains(hashCode = activity.hashCode())) continue;
                this.mAutoTrackIgnoredActivities.remove((Object)hashCode);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void ignoreAutoTrackActivity(Class<?> activity) {
        if (activity == null) {
            return;
        }
        if (this.mAutoTrackIgnoredActivities == null) {
            this.mAutoTrackIgnoredActivities = new ArrayList<Integer>();
        }
        try {
            int hashCode = activity.hashCode();
            if (!this.mAutoTrackIgnoredActivities.contains(hashCode)) {
                this.mAutoTrackIgnoredActivities.add(hashCode);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void resumeAutoTrackActivity(Class<?> activity) {
        if (activity == null) {
            return;
        }
        if (this.mAutoTrackIgnoredActivities == null) {
            this.mAutoTrackIgnoredActivities = new ArrayList<Integer>();
        }
        try {
            int hashCode = activity.hashCode();
            if (this.mAutoTrackIgnoredActivities.contains(hashCode)) {
                this.mAutoTrackIgnoredActivities.remove((Object)hashCode);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public boolean isActivityAutoTrackAppViewScreenIgnored(Class<?> activity) {
        if (activity == null) {
            return false;
        }
        if (this.mAutoTrackIgnoredActivities != null && this.mAutoTrackIgnoredActivities.contains(activity.hashCode())) {
            return true;
        }
        if (activity.getAnnotation(SensorsDataIgnoreTrackAppViewScreenAndAppClick.class) != null) {
            return true;
        }
        return activity.getAnnotation(SensorsDataIgnoreTrackAppViewScreen.class) != null;
    }

    public boolean isActivityAutoTrackAppClickIgnored(Class<?> activity) {
        if (activity == null) {
            return false;
        }
        if (this.mAutoTrackIgnoredActivities != null && this.mAutoTrackIgnoredActivities.contains(activity.hashCode())) {
            return true;
        }
        if (activity.getAnnotation(SensorsDataIgnoreTrackAppViewScreenAndAppClick.class) != null) {
            return true;
        }
        return activity.getAnnotation(SensorsDataIgnoreTrackAppClick.class) != null;
    }

    public boolean isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType eventType) {
        if (eventType == null) {
            return false;
        }
        return this.isAutoTrackEventTypeIgnored(eventType.eventValue);
    }

    public boolean isAutoTrackEventTypeIgnored(int autoTrackEventType) {
        Boolean isIgnored;
        if (this.mContextManager.getRemoteManager() != null && (isIgnored = this.mContextManager.getRemoteManager().isAutoTrackEventTypeIgnored(autoTrackEventType)) != null) {
            if (isIgnored.booleanValue()) {
                SALog.i((String)TAG, (String)("remote config: " + SensorsDataAPI.AutoTrackEventType.autoTrackEventName((int)autoTrackEventType) + " is ignored by remote config"));
            }
            return isIgnored;
        }
        return (this.mSAConfigOptions.getAutoTrackEventType() | autoTrackEventType) != this.mSAConfigOptions.getAutoTrackEventType();
    }

    public void setViewID(View view, String viewID) {
        if (view != null && !TextUtils.isEmpty((CharSequence)viewID)) {
            view.setTag(R.id.sensors_analytics_tag_view_id, (Object)viewID);
        }
    }

    public void setViewID(Dialog view, String viewID) {
        try {
            if (view != null && !TextUtils.isEmpty((CharSequence)viewID) && view.getWindow() != null) {
                view.getWindow().getDecorView().setTag(R.id.sensors_analytics_tag_view_id, (Object)viewID);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void setViewID(Object alertDialog, String viewID) {
        try {
            if (alertDialog == null) {
                return;
            }
            Class<?> supportAlertDialogClass = null;
            Class<?> androidXAlertDialogClass = null;
            try {
                supportAlertDialogClass = Class.forName("android.support.v7.app.AlertDialog");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                androidXAlertDialogClass = Class.forName("androidx.appcompat.app.AlertDialog");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class<?> currentAlertDialogClass = supportAlertDialogClass != null ? supportAlertDialogClass : androidXAlertDialogClass;
            if (currentAlertDialogClass == null) {
                return;
            }
            if (!currentAlertDialogClass.isInstance(alertDialog)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)viewID)) {
                Method getWindowMethod = alertDialog.getClass().getMethod("getWindow", new Class[0]);
                if (getWindowMethod == null) {
                    return;
                }
                Window window = (Window)getWindowMethod.invoke(alertDialog, new Object[0]);
                if (window != null) {
                    window.getDecorView().setTag(R.id.sensors_analytics_tag_view_id, (Object)viewID);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void setViewActivity(View view, Activity activity) {
        try {
            if (view == null || activity == null) {
                return;
            }
            view.setTag(R.id.sensors_analytics_tag_view_activity, (Object)activity);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void setViewFragmentName(View view, String fragmentName) {
        try {
            if (view == null || TextUtils.isEmpty((CharSequence)fragmentName)) {
                return;
            }
            view.setTag(R.id.sensors_analytics_tag_view_fragment_name2, (Object)fragmentName);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void ignoreView(View view) {
        if (view != null) {
            view.setTag(R.id.sensors_analytics_tag_view_ignored, (Object)"1");
        }
    }

    public void ignoreView(View view, boolean ignore) {
        if (view != null) {
            view.setTag(R.id.sensors_analytics_tag_view_ignored, (Object)(ignore ? "1" : "0"));
        }
    }

    public void setViewProperties(View view, JSONObject properties) {
        if (view == null || properties == null) {
            return;
        }
        view.setTag(R.id.sensors_analytics_tag_view_properties, (Object)properties);
    }

    public List<Class<?>> getIgnoredViewTypeList() {
        if (this.mIgnoredViewTypeList == null) {
            this.mIgnoredViewTypeList = new ArrayList();
        }
        return this.mIgnoredViewTypeList;
    }

    public void ignoreViewType(Class<?> viewType) {
        if (viewType == null) {
            return;
        }
        if (this.mIgnoredViewTypeList == null) {
            this.mIgnoredViewTypeList = new ArrayList();
        }
        if (!this.mIgnoredViewTypeList.contains(viewType)) {
            this.mIgnoredViewTypeList.add(viewType);
        }
    }

    public String getLastScreenUrl() {
        return SAPageTools.getLastScreenUrl();
    }

    public void clearReferrerWhenAppEnd() {
        this.mClearReferrerWhenAppEnd = true;
    }

    public void clearLastScreenUrl() {
        if (this.mClearReferrerWhenAppEnd) {
            SAPageTools.setLastScreenUrl(null);
        }
    }

    public JSONObject getLastScreenTrackProperties() {
        try {
            JSONObject jsonObject = JSONUtils.cloneJsonObject((JSONObject)SAPageTools.getLastTrackProperties());
            if (jsonObject != null) {
                jsonObject.remove("$lib_method");
            }
            return jsonObject;
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return new JSONObject();
        }
    }

    public void trackViewScreen(final String url, JSONObject properties) {
        try {
            final JSONObject cloneProperties = JSONUtils.cloneJsonObject((JSONObject)properties);
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!TextUtils.isEmpty((CharSequence)url) || cloneProperties != null) {
                            JSONObject trackProperties = new JSONObject();
                            String currentUrl = url;
                            if (cloneProperties != null) {
                                if (cloneProperties.has("$title")) {
                                    SAPageTools.setCurrentTitle(cloneProperties.getString("$title"));
                                } else {
                                    SAPageTools.setCurrentTitle(null);
                                }
                                if (cloneProperties.has("$url")) {
                                    currentUrl = cloneProperties.optString("$url");
                                }
                            }
                            SAPageTools.setCurrentScreenUrl(currentUrl);
                            if (SAPageTools.getReferrer() != null) {
                                trackProperties.put("$referrer", (Object)SAPageTools.getReferrer());
                            }
                            trackProperties.put("$url", (Object)SAPageTools.getCurrentScreenUrl());
                            if (cloneProperties != null) {
                                JSONUtils.mergeJSONObject((JSONObject)cloneProperties, (JSONObject)trackProperties);
                            }
                            SAPageTools.setCurrentScreenTrackProperties(trackProperties);
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventName("$AppViewScreen").setEventType(EventType.TRACK).setProperties(trackProperties));
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace((Exception)e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void trackViewScreen(Activity activity) {
        try {
            if (activity == null) {
                return;
            }
            JSONObject properties = SAPageInfoUtils.getActivityPageInfo((Activity)activity);
            this.trackViewScreen(SAPageTools.getScreenUrl(activity), properties);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void trackViewScreen(Object fragment) {
        if (fragment == null) {
            return;
        }
        Class<?> supportFragmentClass = null;
        Class<?> appFragmentClass = null;
        Class<?> androidXFragmentClass = null;
        try {
            try {
                supportFragmentClass = Class.forName("android.support.v4.app.Fragment");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                appFragmentClass = Class.forName("android.app.Fragment");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                androidXFragmentClass = Class.forName("androidx.fragment.app.Fragment");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!(supportFragmentClass != null && supportFragmentClass.isInstance(fragment) || appFragmentClass != null && appFragmentClass.isInstance(fragment) || androidXFragmentClass != null && androidXFragmentClass.isInstance(fragment))) {
            return;
        }
        try {
            ScreenAutoTracker screenAutoTracker;
            JSONObject otherProperties;
            SensorsDataFragmentTitle sensorsDataFragmentTitle;
            JSONObject properties = new JSONObject();
            String screenName = fragment.getClass().getCanonicalName();
            String title = null;
            if (fragment.getClass().isAnnotationPresent(SensorsDataFragmentTitle.class) && (sensorsDataFragmentTitle = fragment.getClass().getAnnotation(SensorsDataFragmentTitle.class)) != null) {
                title = sensorsDataFragmentTitle.title();
            }
            if (Build.VERSION.SDK_INT >= 11) {
                Object activity = null;
                try {
                    Method getActivityMethod = fragment.getClass().getMethod("getActivity", new Class[0]);
                    if (getActivityMethod != null) {
                        activity = (Activity)getActivityMethod.invoke(fragment, new Object[0]);
                    }
                }
                catch (Exception getActivityMethod) {
                    // empty catch block
                }
                if (activity != null) {
                    if (TextUtils.isEmpty((CharSequence)title)) {
                        title = SensorsDataUtils.getActivityTitle(activity);
                    }
                    screenName = String.format(TimeUtils.SDK_LOCALE, "%s|%s", activity.getClass().getCanonicalName(), screenName);
                }
            }
            if (!TextUtils.isEmpty(title)) {
                properties.put("$title", title);
            }
            properties.put("$screen_name", (Object)screenName);
            if (fragment instanceof ScreenAutoTracker && (otherProperties = (screenAutoTracker = (ScreenAutoTracker)fragment).getTrackProperties()) != null) {
                JSONUtils.mergeJSONObject((JSONObject)otherProperties, (JSONObject)properties);
            }
            this.trackViewScreen(SAPageTools.getScreenUrl(fragment), properties);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void trackViewAppClick(View view) {
        this.trackViewAppClick(view, null);
    }

    public void trackViewAppClick(final View view, JSONObject properties) {
        if (view == null) {
            return;
        }
        try {
            JSONObject cloneProperties = properties != null ? JSONUtils.cloneJsonObject((JSONObject)properties) : new JSONObject();
            final JSONObject propertyJson = AopUtil.injectClickInfo(new ViewContext(view), cloneProperties, true);
            if (propertyJson != null) {
                SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "mergeVisualProperties", new Object[]{propertyJson, view});
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventName("$AppClick").setEventType(EventType.TRACK).setProperties(propertyJson));
                        }
                        catch (Exception e) {
                            SALog.printStackTrace((Exception)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void trackFragmentAppViewScreen() {
        this.mFragmentAPI.trackFragmentAppViewScreen();
    }

    public boolean isTrackFragmentAppViewScreenEnabled() {
        return this.mFragmentAPI.isTrackFragmentAppViewScreenEnabled();
    }

    public void enableAutoTrackFragment(Class<?> fragment) {
        this.mFragmentAPI.enableAutoTrackFragment(fragment);
    }

    public void enableAutoTrackFragments(List<Class<?>> fragmentsList) {
        this.mFragmentAPI.enableAutoTrackFragments(fragmentsList);
    }

    public boolean isFragmentAutoTrackAppViewScreen(Class<?> fragment) {
        return this.mFragmentAPI.isFragmentAutoTrackAppViewScreen(fragment);
    }

    public void ignoreAutoTrackFragments(List<Class<?>> fragmentList) {
        this.mFragmentAPI.ignoreAutoTrackFragments(fragmentList);
    }

    public void ignoreAutoTrackFragment(Class<?> fragment) {
        this.mFragmentAPI.ignoreAutoTrackFragment(fragment);
    }

    public void resumeIgnoredAutoTrackFragments(List<Class<?>> fragmentList) {
        this.mFragmentAPI.resumeIgnoredAutoTrackFragments(fragmentList);
    }

    public void resumeIgnoredAutoTrackFragment(Class<?> fragment) {
        this.mFragmentAPI.resumeIgnoredAutoTrackFragment(fragment);
    }

    private void enableAutoTrack(int autoTrackEventType) {
        try {
            if (autoTrackEventType <= 0 || autoTrackEventType > 15) {
                return;
            }
            this.mAutoTrack = true;
            this.mSAConfigOptions.setAutoTrackEventType(this.mSAConfigOptions.getAutoTrackEventType() | autoTrackEventType);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

