/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewTreeObserver;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.exposure.AppPageChange;
import com.sensorsdata.analytics.android.sdk.exposure.SAExposedProcess;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import java.lang.ref.WeakReference;

public class ExposedTransform
implements SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks {
    private final String TAG = "SA.ExposedTransform";
    private final AppPageChange mAppPageChange;
    private final SAExposedProcess.CallBack mCallBack;
    private WeakReference<Activity> mActivityWeakReference;
    private volatile boolean isMonitor = false;
    private volatile int windowCount = -1;
    private View[] views;

    public void onNewIntent(Intent intent) {
    }

    public synchronized void observerWindow(Activity activity) {
        int originWindowCount = this.windowCount;
        this.processViews();
        SALog.i((String)"SA.ExposedTransform", (String)("originWindowCount:" + originWindowCount + ",windowCount:" + this.windowCount));
        if (originWindowCount != this.windowCount) {
            this.viewsRemoveTreeObserver(activity);
            this.onActivityResumed(activity);
            return;
        }
        if (!this.isMonitor) {
            this.onActivityResumed(activity);
        }
    }

    private void processViews() {
        WindowHelper.init();
        this.views = WindowHelper.getSortedWindowViews();
        this.windowCount = this.views != null && this.views.length > 0 ? this.views.length : 0;
    }

    public ExposedTransform(final SAExposedProcess.CallBack callBack) {
        this.mCallBack = callBack;
        LayoutCallBack layoutCallBack = new LayoutCallBack(){

            @Override
            public void viewLayoutChange() {
                Activity activity;
                if (ExposedTransform.this.mActivityWeakReference != null && (activity = (Activity)ExposedTransform.this.mActivityWeakReference.get()) != null) {
                    callBack.viewLayoutChange(activity);
                }
            }
        };
        this.mAppPageChange = new AppPageChange(layoutCallBack);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
    }

    public void onActivityStarted(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResumed(Activity activity) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        SALog.i((String)"SA.ExposedTransform", (String)("onActivityResumed:" + activity));
        ExposedTransform exposedTransform = this;
        synchronized (exposedTransform) {
            this.viewsAddTreeObserver(activity);
            this.mCallBack.onActivityResumed(activity);
        }
    }

    private void viewTreeObserver(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mAppPageChange);
        if (Build.VERSION.SDK_INT >= 18) {
            viewTreeObserver.addOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this.mAppPageChange);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            viewTreeObserver.addOnDrawListener((ViewTreeObserver.OnDrawListener)this.mAppPageChange);
        }
        viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.mAppPageChange);
        viewTreeObserver.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mAppPageChange);
    }

    private void viewRemoveTreeObserver(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mAppPageChange);
        if (Build.VERSION.SDK_INT >= 18) {
            viewTreeObserver.removeOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this.mAppPageChange);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            viewTreeObserver.removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.mAppPageChange);
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.mAppPageChange);
        viewTreeObserver.removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mAppPageChange);
    }

    private void viewsAddTreeObserver(Activity activity) {
        SALog.i((String)"SA.ExposedTransform", (String)("viewsAddTreeObserver:" + this.isMonitor));
        if (!this.isMonitor) {
            if (this.mCallBack.getExposureViewSize(activity) <= 0) {
                return;
            }
            this.processViews();
            boolean flag = true;
            View decorView = activity.getWindow().getDecorView();
            if (this.views != null && this.views.length > 0) {
                for (View view : this.views) {
                    if (decorView == view) {
                        flag = false;
                    }
                    this.viewTreeObserver(view);
                }
                if (flag) {
                    this.viewTreeObserver(decorView);
                }
            } else {
                this.viewTreeObserver(activity.getWindow().getDecorView());
            }
            this.isMonitor = true;
        }
    }

    private void viewsRemoveTreeObserver(Activity activity) {
        SALog.i((String)"SA.ExposedTransform", (String)("viewsRemoveTreeObserver:" + this.isMonitor));
        if (this.isMonitor) {
            this.isMonitor = false;
            if (this.views != null && this.views.length > 0) {
                for (View view : this.views) {
                    this.viewRemoveTreeObserver(view);
                }
            } else {
                this.viewRemoveTreeObserver(activity.getWindow().getDecorView());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityPaused(Activity activity) {
        SALog.i((String)"SA.ExposedTransform", (String)"onActivityPaused");
        ExposedTransform exposedTransform = this;
        synchronized (exposedTransform) {
            this.viewsRemoveTreeObserver(activity);
            this.mCallBack.onActivityPaused(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    static interface LayoutCallBack {
        public void viewLayoutChange();
    }
}

