/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import java.util.HashMap;

public class ExposureVisible {
    private final HashMap<String, Boolean> mVisible = new HashMap();

    public void cleanVisible() {
        this.mVisible.clear();
    }

    public boolean isVisible(View view, Rect rect) {
        if (!this.isViewSelfVisible(view, rect)) {
            return false;
        }
        if (!this.isParentVisible(view)) {
            return false;
        }
        return view.isShown();
    }

    private boolean isViewSelfVisible(View view, Rect rect) {
        boolean viewLocalVisible;
        if (view == null || view.getWindowVisibility() == 8) {
            return false;
        }
        if (WindowHelper.isDecorView(view.getClass())) {
            return true;
        }
        Boolean localVisible = this.mVisible.get(view.hashCode() + "");
        if (localVisible == null) {
            viewLocalVisible = view.getLocalVisibleRect(rect);
            this.mVisible.put(view.hashCode() + "", viewLocalVisible);
        } else {
            viewLocalVisible = localVisible;
        }
        if (view.getWidth() <= 0 || view.getHeight() <= 0 || view.getAlpha() <= 0.0f || !viewLocalVisible) {
            return false;
        }
        boolean flag = view.getVisibility() == 0 || view.getAnimation() == null || !view.getAnimation().getFillAfter();
        boolean bl = flag = flag && view.getVisibility() != 0;
        return !flag;
    }

    private boolean isParentVisible(View view) {
        if (view == null) {
            return false;
        }
        ViewParent viewParent = view.getParent();
        do {
            if (!(viewParent instanceof View)) {
                return true;
            }
            if (this.isViewSelfVisible((View)viewParent, new Rect())) continue;
            return false;
        } while ((viewParent = viewParent.getParent()) != null);
        return false;
    }
}

