/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureConfig;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureData;
import com.sensorsdata.analytics.android.sdk.exposure.ExposedPage;
import com.sensorsdata.analytics.android.sdk.exposure.ExposedTransform;
import com.sensorsdata.analytics.android.sdk.exposure.ExposureView;
import com.sensorsdata.analytics.android.sdk.exposure.StayDurationRunnable;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataLifecycleMonitorManager;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;

public class SAExposedProcess {
    private static final String TAG = "SA.SAExposedProcess";
    private static final long DELAY_TIME = 500L;
    private final SAExposureConfig mExposureConfig;
    private WeakHashMap<Activity, ExposedPage> mExposedPageWeakHashMap;
    private CallBack mCallBack;
    private Handler mHandler;
    private ExposureRunnable mExposureRunnable;
    private String mLastActivityUrl = "";
    private boolean isActivityChange;
    private WeakHashMap<View, StayDurationRunnable> mStayDurationRunnableWeakHashMap;
    private ExposedTransform mExposedTransform;

    private synchronized void init() {
        try {
            if (this.mExposedPageWeakHashMap == null) {
                this.mExposedPageWeakHashMap = new WeakHashMap();
                this.mStayDurationRunnableWeakHashMap = new WeakHashMap();
                HandlerThread handlerThread = new HandlerThread("SA.Exposured");
                handlerThread.start();
                this.mHandler = new Handler(handlerThread.getLooper());
                this.mCallBack = new CallBack(){

                    @Override
                    public void viewLayoutChange(Activity activity) {
                        if (SAExposedProcess.this.mExposureRunnable != null) {
                            SAExposedProcess.this.mHandler.removeCallbacks((Runnable)SAExposedProcess.this.mExposureRunnable);
                        }
                        SAExposedProcess.this.removeStayDurationRunnable();
                        ExposedPage exposedPage = (ExposedPage)SAExposedProcess.this.mExposedPageWeakHashMap.get(activity);
                        if (exposedPage != null) {
                            SAExposedProcess.this.mExposureRunnable = new ExposureRunnable(exposedPage, null);
                            if (SAExposedProcess.this.mExposureConfig != null) {
                                SALog.i((String)SAExposedProcess.TAG, (String)("delayTime:" + SAExposedProcess.this.mExposureConfig.getDelayTime()));
                                SAExposedProcess.this.mHandler.postDelayed((Runnable)SAExposedProcess.this.mExposureRunnable, SAExposedProcess.this.mExposureConfig.getDelayTime());
                            } else {
                                SALog.i((String)SAExposedProcess.TAG, (String)"delayTime->500ms");
                                SAExposedProcess.this.mHandler.postDelayed((Runnable)SAExposedProcess.this.mExposureRunnable, 500L);
                            }
                        }
                    }

                    @Override
                    public void onActivityResumed(Activity activity) {
                        try {
                            ExposedPage exposedPage;
                            String currentUrl = activity.getClass().getCanonicalName();
                            SAExposedProcess.this.isActivityChange = !SAExposedProcess.this.mLastActivityUrl.equals(currentUrl);
                            SAExposedProcess.this.mLastActivityUrl = currentUrl;
                            if (SAExposedProcess.this.isActivityChange && (exposedPage = (ExposedPage)SAExposedProcess.this.mExposedPageWeakHashMap.get(activity)) != null) {
                                Collection<ExposureView> exposureViews = exposedPage.getExposureViews();
                                for (ExposureView exposureView : exposureViews) {
                                    if (exposureView == null) continue;
                                    exposureView.setActivityChange(true);
                                }
                            }
                            this.viewLayoutChange(activity);
                        }
                        catch (Exception exception) {
                            SALog.printStackTrace((Exception)exception);
                        }
                    }

                    @Override
                    public void onActivityPaused(Activity activity) {
                        try {
                            if (SAExposedProcess.this.mExposedPageWeakHashMap == null) {
                                return;
                            }
                            ExposedPage exposedPage = (ExposedPage)SAExposedProcess.this.mExposedPageWeakHashMap.get(activity);
                            if (exposedPage != null) {
                                exposedPage.invisibleElement();
                            }
                            SAExposedProcess.this.removeStayDurationRunnable();
                        }
                        catch (Exception e) {
                            SALog.printStackTrace((Exception)e);
                        }
                    }

                    @Override
                    public int getExposureViewSize(Activity activity) {
                        try {
                            ExposedPage exposedPage;
                            if (SAExposedProcess.this.mExposedPageWeakHashMap != null && (exposedPage = (ExposedPage)SAExposedProcess.this.mExposedPageWeakHashMap.get(activity)) != null) {
                                return exposedPage.getExposureViewSize();
                            }
                        }
                        catch (Exception e) {
                            SALog.printStackTrace((Exception)e);
                        }
                        return 0;
                    }
                };
                this.mExposedTransform = new ExposedTransform(this.mCallBack);
                SensorsDataLifecycleMonitorManager.getInstance().addActivityLifeCallback((SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks)this.mExposedTransform);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public SAExposedProcess(SAExposureConfig exposureConfig) {
        this.mExposureConfig = exposureConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStayDurationRunnable() {
        WeakHashMap<View, StayDurationRunnable> weakHashMap = this.mStayDurationRunnableWeakHashMap;
        synchronized (weakHashMap) {
            if (this.mStayDurationRunnableWeakHashMap == null) {
                return;
            }
            Iterator<View> iterator = this.mStayDurationRunnableWeakHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                View view = iterator.next();
                if (view == null) continue;
                StayDurationRunnable stayDurationRunnable = this.mStayDurationRunnableWeakHashMap.get(view);
                this.mHandler.removeCallbacks((Runnable)stayDurationRunnable);
                iterator.remove();
            }
        }
    }

    private Activity exposureProcess(View view, SAExposureData exposureData, boolean isAddExposureView) throws Exception {
        SAExposureConfig saExposureConfig;
        if (view == null || exposureData == null) {
            return null;
        }
        Activity activity = SAViewUtils.getActivityOfView((Context)view.getContext(), (View)view);
        if (activity == null) {
            activity = AppStateTools.getInstance().getForegroundActivity();
        }
        if (activity == null) {
            return null;
        }
        this.init();
        ExposedPage exposedPage = this.mExposedPageWeakHashMap.get(activity);
        if (exposedPage == null) {
            exposedPage = new ExposedPage();
            this.mExposedPageWeakHashMap.put(activity, exposedPage);
        }
        if (isAddExposureView && (saExposureConfig = exposureData.getExposureConfig()) == null) {
            exposureData.setExposureConfig(this.mExposureConfig);
        }
        ExposureView exposureView = null;
        String identifier = exposureData.getIdentifier();
        if (!TextUtils.isEmpty((CharSequence)identifier)) {
            ExposureView tmpExposureView = exposedPage.getExposureView(identifier);
            ExposureView oldExposureView = exposedPage.getExposureView(view);
            if (oldExposureView != null && oldExposureView.getExposureData() != null && oldExposureView.getExposureData().getIdentifier() != null && !oldExposureView.getExposureData().getIdentifier().equals(exposureData.getIdentifier())) {
                oldExposureView.setLastVisible(false);
            }
            if (tmpExposureView != null) {
                exposureView = tmpExposureView.clone();
                exposureView.setView(view);
                if (isAddExposureView) {
                    exposureView.setExposureData(exposureData);
                }
            }
        } else if (exposedPage.getExposureView(view) != null) {
            exposureView = exposedPage.getExposureView(view);
            exposureView.setExposureData(exposureData);
        }
        if (exposureView == null) {
            exposureView = new ExposureView(exposureData, false, false, view);
        }
        if (isAddExposureView) {
            exposureView.setAddExposureView(true);
        }
        SALog.i((String)TAG, (String)("addExposureView:" + exposureView));
        exposedPage.addExposureView(view, exposureView);
        exposedPage.addExposureView(exposureData.getIdentifier(), exposureView);
        return activity;
    }

    public void setExposureIdentifier(View view, String exposureIdentifier) {
        SAExposureData exposureData = new SAExposureData(null, null, exposureIdentifier, null);
        try {
            this.exposureProcess(view, exposureData, false);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void addExposureView(View view, SAExposureData exposureData) {
        try {
            if (!this.verifyExposureData(exposureData)) {
                return;
            }
            Activity activity = this.exposureProcess(view, exposureData, true);
            if (activity == null) {
                return;
            }
            this.mCallBack.viewLayoutChange(activity);
            if (this.mExposedTransform != null) {
                this.mExposedTransform.observerWindow(activity);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private boolean verifyExposureData(SAExposureData exposureData) {
        if (exposureData == null) {
            SALog.i((String)TAG, (String)"SAExposureData is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)exposureData.getEvent())) {
            SALog.i((String)TAG, (String)"EventName is empty or null");
            return false;
        }
        SAExposureConfig exposureConfig = exposureData.getExposureConfig();
        if (exposureConfig != null) {
            if (exposureConfig.getAreaRate() > 1.0f || exposureConfig.getAreaRate() < 0.0f) {
                SALog.i((String)TAG, (String)"SAExposureConfig areaRate must be 0~1");
                exposureConfig.setAreaRate(0.0f);
                return true;
            }
        } else if (this.mExposureConfig != null && (this.mExposureConfig.getAreaRate() > 1.0f || this.mExposureConfig.getAreaRate() < 0.0f)) {
            SALog.i((String)TAG, (String)"Global SAExposureConfig areaRate must be 0~1");
            exposureConfig = new SAExposureConfig(0.0f, this.mExposureConfig.getStayDuration(), this.mExposureConfig.isRepeated());
            exposureData.setExposureConfig(exposureConfig);
            return true;
        }
        return true;
    }

    public void removeExposureView(View view, String identifier) {
        if (view == null) {
            return;
        }
        Activity activity = SAViewUtils.getActivityOfView((Context)view.getContext(), (View)view);
        if (activity == null) {
            activity = AppStateTools.getInstance().getForegroundActivity();
        }
        if (activity == null) {
            return;
        }
        ExposedPage exposedPage = null;
        if (this.mExposedPageWeakHashMap != null) {
            exposedPage = this.mExposedPageWeakHashMap.get(activity);
        }
        if (exposedPage != null) {
            exposedPage.removeExposureView(view, identifier);
        }
    }

    class ExposureRunnable
    implements Runnable {
        private final ExposedPage mExposedPage;
        private final View mView;

        public ExposureRunnable(ExposedPage exposedPage, View view) {
            this.mExposedPage = exposedPage;
            this.mView = view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                List<ExposureView> exposureViewList = this.mExposedPage.getExposureViewList(this.mView);
                for (ExposureView exposureView : exposureViewList) {
                    View view;
                    if (SAExposedProcess.this.isActivityChange) {
                        exposureView.setActivityChange(true);
                        SAExposedProcess.this.isActivityChange = false;
                    }
                    if ((view = exposureView.getView()) == null) continue;
                    WeakHashMap weakHashMap = SAExposedProcess.this.mStayDurationRunnableWeakHashMap;
                    synchronized (weakHashMap) {
                        StayDurationRunnable mStayDurationRunnable = (StayDurationRunnable)SAExposedProcess.this.mStayDurationRunnableWeakHashMap.get(view);
                        if (mStayDurationRunnable != null) {
                            SAExposedProcess.this.mHandler.removeCallbacks((Runnable)mStayDurationRunnable);
                            SAExposedProcess.this.mStayDurationRunnableWeakHashMap.remove(view);
                        }
                        SALog.i((String)SAExposedProcess.TAG, (String)("ExposureRunnable->exposureView:" + exposureView));
                        SAExposureData exposureData = exposureView.getExposureData();
                        if (exposureData != null) {
                            long delay = (long)(exposureData.getExposureConfig().getStayDuration() * 1000.0);
                            mStayDurationRunnable = new StayDurationRunnable(exposureView);
                            SAExposedProcess.this.mStayDurationRunnableWeakHashMap.put(view, mStayDurationRunnable);
                            SAExposedProcess.this.mHandler.postDelayed((Runnable)mStayDurationRunnable, delay);
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    static interface CallBack {
        public void viewLayoutChange(Activity var1);

        public void onActivityResumed(Activity var1);

        public void onActivityPaused(Activity var1);

        public int getExposureViewSize(Activity var1);
    }
}

