/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.exposure.ExposureView;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewTreeStatusObservable;
import org.json.JSONObject;

public class StayDurationRunnable
implements Runnable {
    private final ExposureView mExposureView;
    private static final String TAG = "SA.StayDurationRunnable";

    public StayDurationRunnable(ExposureView exposureView) {
        this.mExposureView = exposureView;
    }

    @Override
    public void run() {
        try {
            String viewText;
            JSONObject exposureProperties = this.mExposureView.getExposureData().getProperties();
            JSONObject jsonObject = exposureProperties == null ? new JSONObject() : new JSONObject(exposureProperties.toString());
            View view = this.mExposureView.getView();
            if (view == null) {
                return;
            }
            Activity activity = SAViewUtils.getActivityOfView((Context)view.getContext(), (View)view);
            if (activity == null) {
                return;
            }
            SALog.i((String)TAG, (String)("StayDurationRunnable:" + this.mExposureView));
            JSONObject activityProperty = SAViewUtils.getScreenNameAndTitle((View)view);
            if (activityProperty == null || TextUtils.isEmpty((CharSequence)activityProperty.toString())) {
                activityProperty = SAViewUtils.buildTitleAndScreenName((Activity)activity);
            }
            JSONUtils.mergeJSONObject((JSONObject)activityProperty, (JSONObject)jsonObject);
            ViewNode viewNode = ViewTreeStatusObservable.getInstance().getViewNode(view);
            if (viewNode != null) {
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPath())) {
                    jsonObject.put("$element_path", (Object)viewNode.getViewPath());
                }
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPosition())) {
                    jsonObject.put("$element_position", (Object)viewNode.getViewPosition());
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(viewText = SAViewUtils.getViewContent((View)view)))) {
                jsonObject.put("$element_content", (Object)viewText);
            }
            jsonObject.put("$element_type", (Object)SAViewUtils.getViewType((View)view));
            String eventName = this.mExposureView.getExposureData().getEvent();
            SensorsDataAPI.sharedInstance().track(eventName, jsonObject);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        this.mExposureView.setLastVisible(true);
        this.mExposureView.setExposed(true);
        this.mExposureView.setActivityChange(false);
    }
}

