/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual;

import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.visual.HeatMapService;
import com.sensorsdata.analytics.android.sdk.visual.NodesProcess;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackService;
import java.lang.ref.WeakReference;

public class WebViewVisualInterface {
    private static final String TAG = "SA.Visual.WebViewVisualInterface";
    private WeakReference<View> mWebView;

    public WebViewVisualInterface(View webView) {
        this.mWebView = new WeakReference<View>(webView);
    }

    @JavascriptInterface
    public void sensorsdata_hover_web_nodes(String msg) {
        try {
            NodesProcess.getInstance().getWebNodesManager().handlerMessage(msg);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @JavascriptInterface
    public boolean sensorsdata_visualized_mode() {
        return VisualizedAutoTrackService.getInstance().isServiceRunning() || HeatMapService.getInstance().isServiceRunning();
    }

    @JavascriptInterface
    public void sensorsdata_visualized_alert_info(final String msg) {
        try {
            SALog.i((String)TAG, (String)("sensorsdata_visualized_alert_info msg: " + msg));
            if (this.mWebView.get() != null) {
                ((View)this.mWebView.get()).post(new Runnable(){

                    @Override
                    public void run() {
                        String url = (String)ReflectUtil.callMethod(WebViewVisualInterface.this.mWebView.get(), (String)"getUrl", (Object[])new Object[0]);
                        if (!TextUtils.isEmpty((CharSequence)url)) {
                            SALog.i((String)WebViewVisualInterface.TAG, (String)("sensorsdata_visualized_alert_info url: " + url));
                            NodesProcess.getInstance().getWebNodesManager().handlerFailure(url, msg);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

