/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.RatingBar;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewTreeStatusObservable;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewUtil;
import com.sensorsdata.analytics.android.sdk.visual.model.SnapInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualUtil {
    public static int getVisibility(View view) {
        if (view instanceof Spinner) {
            return 8;
        }
        if (!SAViewUtils.isViewSelfVisible((View)view)) {
            return 8;
        }
        if (!view.isShown()) {
            return 8;
        }
        return 0;
    }

    public static boolean isSupportElementContent(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            return !(view instanceof SeekBar) && !(view instanceof RatingBar) && !(view instanceof Switch);
        }
        return false;
    }

    public static boolean isForbiddenClick(View v) {
        if (ViewUtil.instanceOfWebView((Object)v) || v instanceof AdapterView) {
            return true;
        }
        if (v instanceof TextView) {
            TextView textView = (TextView)v;
            if (Build.VERSION.SDK_INT >= 15) {
                return textView.isTextSelectable() && !textView.hasOnClickListeners();
            }
        }
        return false;
    }

    public static boolean isSupportClick(View v) {
        ViewParent parent = v.getParent();
        if (parent instanceof AdapterView || ViewUtil.instanceOfRecyclerView((Object)parent)) {
            return true;
        }
        return v instanceof RatingBar || v instanceof SeekBar;
    }

    public static JSONObject getScreenNameAndTitle(View view, SnapInfo info) {
        if (view == null) {
            return null;
        }
        JSONObject object = null;
        Activity activity = SAViewUtils.getActivityOfView((Context)view.getContext(), (View)view);
        if (activity == null) {
            activity = AppStateTools.getInstance().getForegroundActivity();
        }
        if (activity != null && activity.getWindow() != null && activity.getWindow().isActive()) {
            Object fragment = SAFragmentUtils.getFragmentFromView((View)view, (Activity)activity);
            if (fragment != null) {
                object = SAPageInfoUtils.getFragmentPageInfo((Activity)activity, (Object)fragment);
                if (info != null && !info.hasFragment) {
                    info.hasFragment = true;
                }
            } else {
                object = SAPageInfoUtils.getActivityPageInfo((Activity)activity);
                JSONObject rnJson = SAPageInfoUtils.getRNPageInfo();
                JSONUtils.mergeDuplicateProperty((JSONObject)rnJson, (JSONObject)object);
            }
        }
        return object;
    }

    public static ViewNode addViewPathProperties(Activity activity, View view, JSONObject properties) {
        try {
            if (view == null || activity == null) {
                return null;
            }
            if (properties == null) {
                properties = new JSONObject();
            }
            ViewNode viewNode = ViewTreeStatusObservable.getInstance().getViewNode(view);
            if (SensorsDataAPI.sharedInstance().isVisualizedAutoTrackEnabled() && SensorsDataAPI.sharedInstance().isVisualizedAutoTrackActivity(activity.getClass()) || SensorsDataAPI.sharedInstance().isHeatMapEnabled() && SensorsDataAPI.sharedInstance().isHeatMapActivity(activity.getClass())) {
                String elementSelector = SAViewUtils.getElementSelector((View)view);
                if (!TextUtils.isEmpty((CharSequence)elementSelector)) {
                    properties.put("$element_selector", (Object)elementSelector);
                }
                if (viewNode != null && !TextUtils.isEmpty((CharSequence)viewNode.getViewPath())) {
                    properties.put("$element_path", (Object)viewNode.getViewPath());
                }
            }
            if (viewNode != null && !TextUtils.isEmpty((CharSequence)viewNode.getViewPosition())) {
                properties.put("$element_position", (Object)viewNode.getViewPosition());
            }
            return viewNode;
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
            return null;
        }
    }
}

