/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Build;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.sensorsdata.analytics.android.sdk.visual.view.IPairingCodeInterface;
import java.util.Timer;
import java.util.TimerTask;

public class PairingCodeEditText
extends EditText
implements IPairingCodeInterface,
TextWatcher {
    private static final int DEFAULT_CURSOR_DURATION = 400;
    private int mFigures;
    private int mPairingCodeMargin;
    private int mBottomSelectedColor;
    private int mBottomNormalColor;
    private float mBottomLineHeight;
    private int mSelectedBackgroundColor;
    private int mCursorWidth;
    private int mCursorColor;
    private int mCursorDuration;
    private boolean isCursorShowing;
    private IPairingCodeInterface.OnPairingCodeChangedListener onCodeChangedListener;
    private int mCurrentPosition = 0;
    private int mEachRectLength = 0;
    private Paint mSelectedBackgroundPaint;
    private Paint mNormalBackgroundPaint;
    private Paint mBottomSelectedPaint;
    private Paint mBottomNormalPaint;
    private Paint mCursorPaint;
    private TimerTask mCursorTimerTask;
    private Timer mCursorTimer;

    public PairingCodeEditText(Context context) {
        this(context, null);
    }

    public PairingCodeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PairingCodeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs();
        this.setBackgroundColor(this.getColor(17170445));
        this.initPaint();
        this.initCursorTimer();
        this.setFocusableInTouchMode(true);
        this.setSelection(this.getText().length());
        this.requestFocus();
        super.addTextChangedListener((TextWatcher)this);
    }

    private void initPaint() {
        this.mSelectedBackgroundPaint = new Paint();
        this.mSelectedBackgroundPaint.setColor(this.mSelectedBackgroundColor);
        this.mNormalBackgroundPaint = new Paint();
        this.mNormalBackgroundPaint.setColor(this.getColor(17170445));
        this.mBottomSelectedPaint = new Paint();
        this.mBottomNormalPaint = new Paint();
        this.mBottomSelectedPaint.setColor(this.mBottomSelectedColor);
        this.mBottomNormalPaint.setColor(this.mBottomNormalColor);
        this.mBottomSelectedPaint.setStrokeWidth(this.mBottomLineHeight);
        this.mBottomNormalPaint.setStrokeWidth(this.mBottomLineHeight);
        this.mCursorPaint = new Paint();
        this.mCursorPaint.setAntiAlias(true);
        this.mCursorPaint.setColor(this.mCursorColor);
        this.mCursorPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mCursorPaint.setStrokeWidth((float)this.mCursorWidth);
    }

    private void initAttrs() {
        this.mFigures = 4;
        this.mPairingCodeMargin = this.dp2px(10);
        this.mBottomSelectedColor = Color.parseColor((String)"#00c48e");
        this.mBottomNormalColor = this.getColor(0x1060000);
        this.mBottomLineHeight = this.dp2px(2);
        this.mSelectedBackgroundColor = this.getColor(17170445);
        this.mCursorWidth = this.dp2px(1);
        this.mCursorColor = Color.parseColor((String)"#00c48e");
        this.mCursorDuration = 400;
        if (Build.VERSION.SDK_INT >= 17) {
            this.setLayoutDirection(0);
        }
    }

    private void initCursorTimer() {
        this.mCursorTimerTask = new TimerTask(){

            @Override
            public void run() {
                PairingCodeEditText.this.isCursorShowing = !PairingCodeEditText.this.isCursorShowing;
                PairingCodeEditText.this.postInvalidate();
            }
        };
        this.mCursorTimer = new Timer();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCursorTimer.scheduleAtFixedRate(this.mCursorTimerTask, 0L, (long)this.mCursorDuration);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCursorTimer.cancel();
    }

    public final void setCursorVisible(boolean visible) {
        super.setCursorVisible(visible);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthResult = 0;
        int heightResult = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        widthResult = widthMode == 0x40000000 ? widthSize : PairingCodeEditText.getScreenWidth(this.getContext());
        this.mEachRectLength = (widthResult - this.mPairingCodeMargin * (this.mFigures - 1)) / this.mFigures;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        heightResult = heightMode == 0x40000000 ? heightSize : this.mEachRectLength;
        this.setMeasuredDimension(widthResult, heightResult);
    }

    protected void onDraw(Canvas canvas) {
        int i;
        this.mCurrentPosition = this.getText().length();
        int width = this.mEachRectLength - this.getPaddingLeft() - this.getPaddingRight();
        int height = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        for (int i2 = 0; i2 < this.mFigures; ++i2) {
            canvas.save();
            int start = width * i2 + i2 * this.mPairingCodeMargin;
            int end = width + start;
            if (i2 == this.mCurrentPosition) {
                canvas.drawRect((float)start, 0.0f, (float)end, (float)height, this.mSelectedBackgroundPaint);
            } else {
                canvas.drawRect((float)start, 0.0f, (float)end, (float)height, this.mNormalBackgroundPaint);
            }
            canvas.restore();
        }
        String value = this.getText().toString();
        for (i = 0; i < value.length(); ++i) {
            canvas.save();
            int start = width * i + i * this.mPairingCodeMargin;
            float x = start + width / 2;
            TextPaint paint = this.getPaint();
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setColor(this.getCurrentTextColor());
            Paint.FontMetrics fontMetrics = paint.getFontMetrics();
            float baseline = ((float)height - fontMetrics.bottom + fontMetrics.top) / 2.0f - fontMetrics.top;
            canvas.drawText(String.valueOf(value.charAt(i)), x, baseline, (Paint)paint);
            canvas.restore();
        }
        for (i = 0; i < this.mFigures; ++i) {
            canvas.save();
            float lineY = (float)height - this.mBottomLineHeight / 2.0f;
            int start = width * i + i * this.mPairingCodeMargin;
            int end = width + start;
            if (i < this.mCurrentPosition) {
                canvas.drawLine((float)start, lineY, (float)end, lineY, this.mBottomSelectedPaint);
            } else {
                canvas.drawLine((float)start, lineY, (float)end, lineY, this.mBottomNormalPaint);
            }
            canvas.restore();
        }
        boolean isCursorVisible = true;
        if (Build.VERSION.SDK_INT >= 16) {
            isCursorVisible = this.isCursorVisible();
        }
        if (!this.isCursorShowing && isCursorVisible && this.mCurrentPosition < this.mFigures && this.hasFocus()) {
            canvas.save();
            int startX = this.mCurrentPosition * (width + this.mPairingCodeMargin) + width / 2;
            int startY = height / 4;
            int endX = startX;
            int endY = height - height / 4;
            canvas.drawLine((float)startX, (float)startY, (float)endX, (float)endY, this.mCursorPaint);
            canvas.restore();
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.mCurrentPosition = this.getText().length();
        this.postInvalidate();
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.mCurrentPosition = this.getText().length();
        this.postInvalidate();
        if (this.onCodeChangedListener != null) {
            this.onCodeChangedListener.onPairingCodeChanged((CharSequence)this.getText(), start, before, count);
        }
    }

    public void afterTextChanged(Editable s) {
        this.mCurrentPosition = this.getText().length();
        this.postInvalidate();
        if (this.getText().length() == this.mFigures) {
            if (this.onCodeChangedListener != null) {
                this.onCodeChangedListener.onInputCompleted((CharSequence)this.getText());
            }
        } else if (this.getText().length() > this.mFigures) {
            this.getText().delete(this.mFigures, this.getText().length());
        }
    }

    @Override
    public void setFigures(int figures) {
        this.mFigures = figures;
        this.postInvalidate();
    }

    @Override
    public void setPairingCodeMargin(int margin) {
        this.mPairingCodeMargin = margin;
        this.postInvalidate();
    }

    @Override
    public void setBottomSelectedColor(int bottomSelectedColor) {
        this.mBottomSelectedColor = this.getColor(bottomSelectedColor);
        this.postInvalidate();
    }

    @Override
    public void setBottomNormalColor(int bottomNormalColor) {
        this.mBottomSelectedColor = this.getColor(bottomNormalColor);
        this.postInvalidate();
    }

    @Override
    public void setSelectedBackgroundColor(int selectedBackground) {
        this.mSelectedBackgroundColor = this.getColor(selectedBackground);
        this.postInvalidate();
    }

    @Override
    public void setBottomLineHeight(int bottomLineHeight) {
        this.mBottomLineHeight = bottomLineHeight;
        this.postInvalidate();
    }

    @Override
    public void setOnPairingCodeChangedListener(IPairingCodeInterface.OnPairingCodeChangedListener listener) {
        this.onCodeChangedListener = listener;
    }

    private int getColor(int color2) {
        return this.getContext().getResources().getColor(color2);
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    static int getScreenWidth(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(metrics);
        }
        return metrics.widthPixels;
    }

    void showKeyBoard(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm != null) {
            imm.showSoftInput((View)this, 2);
        }
    }

    void hiddenKeyBord() {
        InputMethodManager mInputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (mInputMethodManager != null) {
            mInputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
    }

    void clearText() {
        this.getText().delete(0, this.getText().length());
    }
}

