/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import com.sensorsdata.analytics.android.sdk.visual.NodesProcess;
import com.sensorsdata.analytics.android.sdk.visual.VTrack;
import com.sensorsdata.analytics.android.sdk.visual.ViewSnapshot;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackService;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackViewCrawler;
import com.sensorsdata.analytics.android.sdk.visual.model.SnapInfo;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;
import com.sensorsdata.analytics.android.sdk.visual.snap.EditProtocol;
import com.sensorsdata.analytics.android.sdk.visual.snap.EditState;
import com.sensorsdata.analytics.android.sdk.visual.snap.ResourceReader;
import com.sensorsdata.analytics.android.sdk.visual.utils.AlertMessageUtils;
import com.sensorsdata.analytics.android.sdk.visual.utils.FlutterUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractViewCrawler
implements VTrack {
    private static final String TAG = "SA.AbstractViewCrawler";
    private static final int MESSAGE_SEND_STATE_FOR_EDITING = 1;
    public static final String TYPE_HEAT_MAP = "heat_map";
    public static final String TYPE_VISUAL = "visual";
    private final Context mContext;
    private final LifecycleCallbacks mLifecycleCallbacks;
    private final EditState mEditState;
    private final ViewCrawlerHandler mMessageThreadHandler;
    private final Handler mMainThreadHandler;
    private String mFeatureCode;
    private String mPostUrl;
    private String mAppVersion;
    private boolean mServiceRunning = false;
    private String mType;

    AbstractViewCrawler(Activity activity, String resourcePackageName, String featureCode, String postUrl, String type) {
        this.mContext = activity.getApplicationContext();
        this.mFeatureCode = featureCode;
        this.mEditState = new EditState();
        this.mType = type;
        this.mEditState.add(activity);
        this.mLifecycleCallbacks = new LifecycleCallbacks();
        try {
            this.mPostUrl = URLDecoder.decode(postUrl, "UTF-8");
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        Application app = (Application)this.mContext.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 14) {
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mLifecycleCallbacks);
        }
        try {
            PackageManager manager = activity.getPackageManager();
            PackageInfo info = manager.getPackageInfo(activity.getPackageName(), 0);
            this.mAppVersion = info.versionName;
        }
        catch (Exception e) {
            this.mAppVersion = "";
        }
        HandlerThread thread = new HandlerThread(VisualizedAutoTrackViewCrawler.class.getCanonicalName(), 10);
        thread.start();
        this.mMessageThreadHandler = new ViewCrawlerHandler(this.mContext, thread.getLooper(), resourcePackageName);
        this.mMainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void startUpdates() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mFeatureCode) && !TextUtils.isEmpty((CharSequence)this.mPostUrl)) {
                Application app = (Application)this.mContext.getApplicationContext();
                if (Build.VERSION.SDK_INT >= 14) {
                    app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mLifecycleCallbacks);
                }
                this.mMessageThreadHandler.start();
                this.mMessageThreadHandler.sendMessage(this.mMessageThreadHandler.obtainMessage(1));
                if (!this.mServiceRunning) {
                    FlutterUtils.visualizedConnectionStatusChanged();
                }
                this.mServiceRunning = true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public void stopUpdates(boolean clear) {
        try {
            if (clear) {
                this.mFeatureCode = null;
                this.mPostUrl = null;
            }
            this.mMessageThreadHandler.removeMessages(1);
            Application app = (Application)this.mContext.getApplicationContext();
            if (Build.VERSION.SDK_INT >= 14) {
                app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mLifecycleCallbacks);
            }
            if (this.mServiceRunning) {
                FlutterUtils.visualizedConnectionStatusChanged();
                this.mServiceRunning = false;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public boolean isServiceRunning() {
        return this.mServiceRunning;
    }

    private class ViewCrawlerHandler
    extends Handler {
        private final EditProtocol mProtocol;
        private ViewSnapshot mSnapshot;
        private boolean mUseGzip;
        private StringBuilder mLastImageHash;
        private String mAppId;
        private final String mSDKVersion;

        private ViewCrawlerHandler(Context context, Looper looper, String resourcePackageName) {
            super(looper);
            this.mSnapshot = null;
            ResourceReader.Ids resourceIds = new ResourceReader.Ids(resourcePackageName, context);
            this.mProtocol = new EditProtocol(resourceIds);
            this.mLastImageHash = new StringBuilder();
            this.mUseGzip = true;
            this.mAppId = AppInfoUtils.getProcessName((Context)context);
            this.mSDKVersion = SensorsDataAPI.sharedInstance().getSDKVersion();
        }

        public void start() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.sendSnapshot();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendSnapshot() {
            long startSnapshot = System.currentTimeMillis();
            try {
                this.mSnapshot = this.mProtocol.readSnapshotConfig(AbstractViewCrawler.this.mMainThreadHandler);
                if (null == this.mSnapshot) {
                    SALog.i((String)AbstractViewCrawler.TAG, (String)"Snapshot should be initialize at first calling.");
                    return;
                }
            }
            catch (EditProtocol.BadInstructionsException e) {
                SALog.i((String)AbstractViewCrawler.TAG, (String)"VisualizedAutoTrack server sent malformed message with snapshot request", (Throwable)e);
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream writer = new BufferedOutputStream(out);
            ByteArrayOutputStream payload_out = null;
            DeflaterOutputStream gos = null;
            ByteArrayOutputStream os = null;
            SnapInfo info = null;
            try {
                String fragmentScreenName;
                ((OutputStream)writer).write("{".getBytes());
                ((OutputStream)writer).write("\"type\": \"snapshot_response\",".getBytes());
                ((OutputStream)writer).write(("\"feature_code\": \"" + AbstractViewCrawler.this.mFeatureCode + "\",").getBytes());
                ((OutputStream)writer).write(("\"app_version\": \"" + AbstractViewCrawler.this.mAppVersion + "\",").getBytes());
                ((OutputStream)writer).write(("\"lib_version\": \"" + this.mSDKVersion + "\",").getBytes());
                ((OutputStream)writer).write("\"os\": \"Android\",".getBytes());
                ((OutputStream)writer).write("\"lib\": \"Android\",".getBytes());
                ((OutputStream)writer).write(("\"app_id\": \"" + this.mAppId + "\",").getBytes());
                ((OutputStream)writer).write(("\"app_enablevisualizedproperties\": " + SensorsDataAPI.getConfigOptions().isVisualizedPropertiesEnabled() + ",").getBytes());
                try {
                    JSONArray array = new JSONArray();
                    if (!SensorsDataAPI.sharedInstance().isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_CLICK)) {
                        array.put((Object)"$AppClick");
                    }
                    if (!SensorsDataAPI.sharedInstance().isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_VIEW_SCREEN)) {
                        array.put((Object)"$AppViewScreen");
                    }
                    ((OutputStream)writer).write(("\"app_autotrack\": " + array.toString() + ",").getBytes());
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
                String version = VisualPropertiesManager.getInstance().getVisualConfigVersion();
                if (!TextUtils.isEmpty((CharSequence)version)) {
                    ((OutputStream)writer).write(("\"config_version\": \"" + version + "\",").getBytes());
                }
                if (this.mUseGzip) {
                    String visualLogInfo;
                    payload_out = new ByteArrayOutputStream();
                    BufferedOutputStream payload_writer = new BufferedOutputStream(payload_out);
                    ((OutputStream)payload_writer).write("{\"activities\":".getBytes());
                    ((OutputStream)payload_writer).flush();
                    info = this.mSnapshot.snapshots(payload_out, this.mLastImageHash);
                    long snapshotTime = System.currentTimeMillis() - startSnapshot;
                    ((OutputStream)payload_writer).write(",\"snapshot_time_millis\": ".getBytes());
                    ((OutputStream)payload_writer).write(Long.toString(snapshotTime).getBytes());
                    String visualDebugInfo = VisualizedAutoTrackService.getInstance().getDebugInfo();
                    if (!TextUtils.isEmpty((CharSequence)visualDebugInfo)) {
                        ((OutputStream)payload_writer).write(",".getBytes());
                        ((OutputStream)payload_writer).write("\"event_debug\": ".getBytes());
                        ((OutputStream)payload_writer).write(visualDebugInfo.getBytes());
                    }
                    if (!TextUtils.isEmpty((CharSequence)(visualLogInfo = VisualizedAutoTrackService.getInstance().getVisualLogInfo()))) {
                        ((OutputStream)payload_writer).write(",".getBytes());
                        ((OutputStream)payload_writer).write("\"log_info\":".getBytes());
                        ((OutputStream)payload_writer).write(visualLogInfo.getBytes());
                    }
                    ((OutputStream)payload_writer).write("}".getBytes());
                    ((OutputStream)payload_writer).flush();
                    payload_out.close();
                    byte[] payloadData = payload_out.toString().getBytes();
                    os = new ByteArrayOutputStream(payloadData.length);
                    gos = new GZIPOutputStream(os);
                    gos.write(payloadData);
                    gos.close();
                    byte[] compressed = os.toByteArray();
                    os.close();
                    ((OutputStream)writer).write(("\"gzip_payload\": \"" + new String(Base64Coder.encode((byte[])compressed)) + "\"").getBytes());
                } else {
                    ((OutputStream)writer).write("\"payload\": {".getBytes());
                    ((OutputStream)writer).write("\"activities\":".getBytes());
                    ((OutputStream)writer).flush();
                    info = this.mSnapshot.snapshots(out, this.mLastImageHash);
                    long snapshotTime = System.currentTimeMillis() - startSnapshot;
                    ((OutputStream)writer).write(",\"snapshot_time_millis\": ".getBytes());
                    ((OutputStream)writer).write(Long.toString(snapshotTime).getBytes());
                    ((OutputStream)writer).write("}".getBytes());
                }
                String pageName = null;
                if (!TextUtils.isEmpty((CharSequence)info.screenName)) {
                    ((OutputStream)writer).write((",\"screen_name\": \"" + info.screenName + "\"").getBytes());
                    pageName = info.screenName;
                }
                if (info.hasFragment && !TextUtils.isEmpty((CharSequence)(fragmentScreenName = AppStateTools.getInstance().getFragmentScreenName()))) {
                    pageName = fragmentScreenName;
                }
                SALog.i((String)AbstractViewCrawler.TAG, (String)("page_name\uff1a " + pageName));
                if (!TextUtils.isEmpty((CharSequence)pageName)) {
                    ((OutputStream)writer).write((",\"page_name\": \"" + pageName + "\"").getBytes());
                }
                if (!TextUtils.isEmpty((CharSequence)info.activityTitle)) {
                    ((OutputStream)writer).write((",\"title\": \"" + info.activityTitle + "\"").getBytes());
                }
                ((OutputStream)writer).write((",\"is_webview\": " + info.isWebView).getBytes());
                if (!TextUtils.isEmpty((CharSequence)info.webLibVersion)) {
                    ((OutputStream)writer).write((",\"web_lib_version\": \"" + info.webLibVersion + "\"").getBytes());
                }
                if (info.isWebView && !TextUtils.isEmpty((CharSequence)info.webViewUrl)) {
                    AlertMessageUtils.buildH5AlertInfo(writer, AbstractViewCrawler.this.mType, info, AbstractViewCrawler.this.mContext);
                }
                if (!TextUtils.isEmpty((CharSequence)info.flutterLibVersion)) {
                    ((OutputStream)writer).write((",\"flutter_lib_version\": \"" + info.flutterLibVersion + "\"").getBytes());
                }
                if (info.isFlutter && !TextUtils.isEmpty((CharSequence)info.activityName)) {
                    AlertMessageUtils.buildFlutterAlertInfo(writer, AbstractViewCrawler.this.mType, info, AbstractViewCrawler.this.mContext);
                }
                ((OutputStream)writer).write("}".getBytes());
                ((OutputStream)writer).flush();
            }
            catch (IOException e) {
                SALog.i((String)AbstractViewCrawler.TAG, (String)"Can't write snapshot request to server", (Throwable)e);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e) {
                    SALog.i((String)AbstractViewCrawler.TAG, (String)"Can't close os.", (Throwable)e);
                }
                try {
                    if (gos != null) {
                        gos.close();
                    }
                }
                catch (Exception e) {
                    SALog.i((String)AbstractViewCrawler.TAG, (String)"Can't close gos.", (Throwable)e);
                }
                try {
                    if (payload_out != null) {
                        payload_out.close();
                    }
                }
                catch (Exception e) {
                    SALog.i((String)AbstractViewCrawler.TAG, (String)"Can't close payload_out.", (Throwable)e);
                }
                try {
                    ((OutputStream)writer).close();
                }
                catch (IOException e) {
                    SALog.i((String)AbstractViewCrawler.TAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
            SALog.i((String)AbstractViewCrawler.TAG, (String)("sendSnapshot = " + out));
            this.onSnapFinished(info);
            this.postSnapshot(out);
        }

        private void onSnapFinished(SnapInfo info) {
            if (info != null && !NodesProcess.getInstance().getWebNodesManager().hasThirdView()) {
                NodesProcess.getInstance().getWebNodesManager().clear();
            }
            if (info != null && !NodesProcess.getInstance().getFlutterNodesManager().hasThirdView()) {
                NodesProcess.getInstance().getFlutterNodesManager().clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSnapshot(ByteArrayOutputStream out) {
            boolean rePostSnapshot = true;
            if (TextUtils.isEmpty((CharSequence)AbstractViewCrawler.this.mFeatureCode) || TextUtils.isEmpty((CharSequence)AbstractViewCrawler.this.mPostUrl)) {
                return;
            }
            InputStream in = null;
            OutputStream out2 = null;
            FilterOutputStream bout = null;
            try {
                URL url = new URL(AbstractViewCrawler.this.mPostUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                SAConfigOptions configOptions = SensorsDataAPI.getConfigOptions();
                if (configOptions != null) {
                    if (configOptions.isDisableSDK()) {
                        AbstractViewCrawler.this.mMessageThreadHandler.sendMessageDelayed(AbstractViewCrawler.this.mMessageThreadHandler.obtainMessage(1), 1000L);
                        return;
                    }
                    if (configOptions.getSSLSocketFactory() != null && connection instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)connection).setSSLSocketFactory(configOptions.getSSLSocketFactory());
                    }
                }
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-type", "text/plain");
                out2 = connection.getOutputStream();
                bout = new BufferedOutputStream(out2);
                bout.write(out.toString().getBytes("UTF-8"));
                ((BufferedOutputStream)bout).flush();
                int responseCode = connection.getResponseCode();
                try {
                    in = connection.getInputStream();
                }
                catch (FileNotFoundException e) {
                    in = connection.getErrorStream();
                }
                byte[] responseBody = this.slurp(in);
                String response = new String(responseBody, "UTF-8");
                SALog.i((String)AbstractViewCrawler.TAG, (String)("request url =" + AbstractViewCrawler.this.mPostUrl));
                SALog.i((String)AbstractViewCrawler.TAG, (String)("responseCode=" + responseCode));
                SALog.i((String)AbstractViewCrawler.TAG, (String)("response=" + response));
                JSONObject responseJson = new JSONObject(response);
                if (responseCode == 200) {
                    int delay = responseJson.getInt("delay");
                    if (delay < 0) {
                        rePostSnapshot = false;
                    }
                    String visualizedConfig = responseJson.optString("visualized_sdk_config");
                    boolean visualizedConfigDisabled = responseJson.optBoolean("visualized_config_disabled");
                    if ((!TextUtils.isEmpty((CharSequence)visualizedConfig) || visualizedConfigDisabled) && SensorsDataAPI.getConfigOptions().isVisualizedPropertiesEnabled()) {
                        VisualPropertiesManager.getInstance().save2Cache(visualizedConfig);
                    }
                    VisualizedAutoTrackService.getInstance().setDebugModeEnabled(responseJson.optBoolean("visualized_debug_mode_enabled"));
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
                try {
                    if (out2 != null) {
                        out2.close();
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
            if (rePostSnapshot) {
                AbstractViewCrawler.this.mMessageThreadHandler.sendMessageDelayed(AbstractViewCrawler.this.mMessageThreadHandler.obtainMessage(1), 1000L);
            } else {
                AbstractViewCrawler.this.stopUpdates(true);
            }
        }

        private byte[] slurp(InputStream inputStream) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private LifecycleCallbacks() {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            AbstractViewCrawler.this.mEditState.add(activity);
        }

        public void onActivityPaused(Activity activity) {
            AbstractViewCrawler.this.mEditState.remove(activity);
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

