/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.property;

import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.listener.SAEventListener;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewTreeStatusObservable;
import com.sensorsdata.analytics.android.sdk.visual.bridge.JSBridgeHelper;
import com.sensorsdata.analytics.android.sdk.visual.bridge.OnBridgeCallback;
import com.sensorsdata.analytics.android.sdk.visual.bridge.WebViewJavascriptBridge;
import com.sensorsdata.analytics.android.sdk.visual.model.VisualConfig;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualPropertiesH5Helper
implements WebViewJavascriptBridge {
    private JSBridgeHelper mJSBridgeHelper;
    private SAEventListener mSAEventListener;
    private SparseArray<JSONArray> mSparseArray = new SparseArray();

    public VisualPropertiesH5Helper() {
        this.mJSBridgeHelper = new JSBridgeHelper();
    }

    void mergeJSVisualProperties(final JSONObject srcObject, HashSet<String> hashSet, String eventName) {
        try {
            if (hashSet == null || hashSet.size() == 0) {
                return;
            }
            Iterator<String> entries = hashSet.iterator();
            final CountDownLatch latch = new CountDownLatch(hashSet.size());
            while (entries.hasNext()) {
                View view;
                String webViewElementPath = entries.next();
                ViewNode viewNode = ViewTreeStatusObservable.getInstance().getViewNode(webViewElementPath);
                if (viewNode == null || viewNode.getView() == null || (view = (View)viewNode.getView().get()) == null) continue;
                this.getJSVisualProperties(view, viewNode.getViewPath(), eventName, new OnBridgeCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCallBack(String data) {
                        try {
                            JSONObject obj = new JSONObject(data);
                            Iterator iterator = obj.keys();
                            while (iterator.hasNext()) {
                                String key = (String)iterator.next();
                                String value = obj.optString(key);
                                if (TextUtils.isEmpty((CharSequence)key)) continue;
                                srcObject.put(key, (Object)value);
                            }
                        }
                        catch (JSONException e) {
                            SALog.printStackTrace((Exception)((Object)e));
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                SALog.printStackTrace((Exception)e);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private void getJSVisualProperties(View webView, String elementPath, String eventName, OnBridgeCallback onBridgeCallback) {
        try {
            JSONArray array = VisualPropertiesManager.getInstance().getVisualPropertiesCache().getH5JsonArrayFromCache(eventName, elementPath);
            if (array == null) {
                return;
            }
            JSONObject obj = new JSONObject();
            try {
                obj.put("sensorsdata_js_visual_properties", (Object)array);
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
            this.sendToWeb(webView, "getJSVisualProperties", obj, onBridgeCallback);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void registerListeners() {
        try {
            this.mJSBridgeHelper.addSAJSListener();
            this.addSAEventListener();
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private void addSAEventListener() {
        if (this.mSAEventListener == null) {
            this.mSAEventListener = new SAEventListener(){

                public void trackEvent(JSONObject jsonObject) {
                    try {
                        String eventType = jsonObject.optString("event");
                        if (!TextUtils.equals((CharSequence)"$WebClick", (CharSequence)eventType)) {
                            return;
                        }
                        JSONObject propertiesObj = jsonObject.optJSONObject("properties");
                        if (propertiesObj == null) {
                            return;
                        }
                        if (propertiesObj.has("sensorsdata_web_visual_eventName")) {
                            VisualPropertiesH5Helper.this.mSparseArray.put(jsonObject.hashCode(), (Object)propertiesObj.optJSONArray("sensorsdata_web_visual_eventName"));
                            propertiesObj.remove("sensorsdata_web_visual_eventName");
                        }
                        String base64Message = propertiesObj.optString("sensorsdata_app_visual_properties");
                        propertiesObj.remove("sensorsdata_app_visual_properties");
                        if (TextUtils.isEmpty((CharSequence)base64Message) || !SensorsDataAPI.getConfigOptions().isVisualizedPropertiesEnabled()) {
                            return;
                        }
                        String appVisualProperties = Base64Coder.decodeString((String)base64Message);
                        if (TextUtils.isEmpty((CharSequence)appVisualProperties)) {
                            return;
                        }
                        try {
                            JSONArray array = new JSONArray(appVisualProperties);
                            ViewTreeStatusObservable.getInstance().clearViewNodeCache();
                            if (array.length() > 0) {
                                for (int i = 0; i < array.length(); ++i) {
                                    JSONObject obj = array.getJSONObject(i);
                                    VisualConfig.VisualProperty visualProperty = new VisualConfig.VisualProperty();
                                    visualProperty.elementPath = obj.optString("element_path");
                                    visualProperty.elementPosition = obj.optString("element_position");
                                    visualProperty.screenName = obj.optString("screen_name");
                                    visualProperty.name = obj.optString("name");
                                    visualProperty.regular = obj.optString("regular");
                                    visualProperty.isH5 = obj.optBoolean("h5");
                                    visualProperty.type = obj.optString("type");
                                    visualProperty.webViewElementPath = obj.optString("webview_element_path");
                                    VisualPropertiesManager.getInstance().mergeAppVisualProperty(visualProperty, null, propertiesObj, null);
                                }
                            }
                        }
                        catch (JSONException e) {
                            SALog.printStackTrace((Exception)((Object)e));
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace((Exception)e);
                    }
                }

                public void login() {
                }

                public void logout() {
                }

                public void identify() {
                }

                public void resetAnonymousId() {
                }
            };
            SensorsDataAPI.sharedInstance().addEventListener(this.mSAEventListener);
        }
    }

    public JSONArray getEventName(int hashCode) {
        try {
            return (JSONArray)this.mSparseArray.get(hashCode);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return null;
        }
    }

    public void clearCache(int hashCode) {
        try {
            this.mSparseArray.remove(hashCode);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public void sendToWeb(View webView, String methodName, Object data, OnBridgeCallback responseCallback) {
        this.mJSBridgeHelper.sendToWeb(webView, methodName, data, responseCallback);
    }

    @Override
    public void sendToWeb(View webView, String methodName, Object data) {
        this.mJSBridgeHelper.sendToWeb(webView, methodName, data);
    }

    private static String Base642string(String s) {
        return new String(Base64.decode((byte[])s.getBytes(), (int)0));
    }
}

