/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.view;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.visual.HeatMapService;
import com.sensorsdata.analytics.android.sdk.visual.R;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackService;

public class VisualDialog {
    public static void showOpenHeatMapDialog(final Activity context, final String featureCode, final String postUrl) {
        boolean isWifi = false;
        try {
            String networkType = NetworkUtils.networkType((Context)context);
            if ("WIFI".equals(networkType)) {
                isWifi = true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setTitle((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_common_title));
        if (isWifi) {
            builder.setMessage((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_heatmap_wifi_name));
        } else {
            builder.setMessage((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_heatmap_mobile_name));
        }
        builder.setCancelable(false);
        builder.setNegativeButton((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_common_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SensorsDataDialogUtils.startLaunchActivity((Context)context);
            }
        });
        builder.setPositiveButton((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_common_continue), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HeatMapService.getInstance().start(context, featureCode, postUrl);
                SensorsDataDialogUtils.startLaunchActivity((Context)context);
            }
        });
        AlertDialog dialog = builder.create();
        SensorsDataDialogUtils.dialogShowDismissOld((Dialog)dialog);
        try {
            dialog.getButton(-2).setTextColor(-16777216);
            dialog.getButton(-2).setBackgroundColor(-1);
            dialog.getButton(-1).setTextColor(-65536);
            dialog.getButton(-1).setBackgroundColor(-1);
            if (Build.VERSION.SDK_INT >= 16) {
                dialog.getButton(-2).setBackground((Drawable)SensorsDataDialogUtils.getDrawable());
                dialog.getButton(-1).setBackground((Drawable)SensorsDataDialogUtils.getDrawable());
            } else {
                dialog.getButton(-2).setBackgroundDrawable((Drawable)SensorsDataDialogUtils.getDrawable());
                dialog.getButton(-1).setBackgroundDrawable((Drawable)SensorsDataDialogUtils.getDrawable());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void showOpenVisualizedAutoTrackDialog(final Activity context, final String featureCode, final String postUrl) {
        boolean isWifi = false;
        try {
            String networkType = NetworkUtils.networkType((Context)context);
            if ("WIFI".equals(networkType)) {
                isWifi = true;
            }
        }
        catch (Exception networkType) {
            // empty catch block
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setTitle((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_common_title));
        if (isWifi) {
            builder.setMessage((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_wifi_name));
        } else {
            builder.setMessage((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_mobile_name));
        }
        builder.setCancelable(false);
        builder.setNegativeButton((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_common_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SensorsDataDialogUtils.startLaunchActivity((Context)context);
            }
        });
        builder.setPositiveButton((CharSequence)SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_common_continue), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VisualizedAutoTrackService.getInstance().start(context, featureCode, postUrl);
                SensorsDataDialogUtils.startLaunchActivity((Context)context);
            }
        });
        AlertDialog dialog = builder.create();
        SensorsDataDialogUtils.dialogShowDismissOld((Dialog)dialog);
        try {
            dialog.getButton(-2).setTextColor(-16777216);
            dialog.getButton(-2).setBackgroundColor(-1);
            dialog.getButton(-1).setTextColor(-65536);
            dialog.getButton(-1).setBackgroundColor(-1);
            if (Build.VERSION.SDK_INT >= 16) {
                dialog.getButton(-2).setBackground((Drawable)SensorsDataDialogUtils.getDrawable());
                dialog.getButton(-1).setBackground((Drawable)SensorsDataDialogUtils.getDrawable());
            } else {
                dialog.getButton(-2).setBackgroundDrawable((Drawable)SensorsDataDialogUtils.getDrawable());
                dialog.getButton(-1).setBackgroundDrawable((Drawable)SensorsDataDialogUtils.getDrawable());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

