/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.property;

import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewTreeStatusObservable;
import com.sensorsdata.analytics.android.sdk.visual.model.VisualConfig;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;
import com.sensorsdata.analytics.android.sdk.visual.utils.FlutterUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualPropertiesCache {
    private static final String TAG = "SA.VP.VisualPropertiesCache";

    public void save2Cache(String config) {
        SALog.i((String)TAG, (String)("save2Cache config is:" + config));
        PersistentLoader.getInstance().getVisualConfigPst().commit((Object)config);
        this.doOnSaveCache(config);
        FlutterUtils.visualizedPropertiesConfigChanged();
    }

    public String getVisualCache() {
        return (String)PersistentLoader.getInstance().getVisualConfigPst().get();
    }

    public VisualConfig getVisualConfig() {
        String persistentVisualConfig = (String)PersistentLoader.getInstance().getVisualConfigPst().get();
        SALog.i((String)TAG, (String)("local visual config is :" + persistentVisualConfig));
        if (TextUtils.isEmpty((CharSequence)persistentVisualConfig)) {
            return null;
        }
        try {
            VisualConfig config = new VisualConfig();
            JSONObject object = new JSONObject(persistentVisualConfig);
            config.appId = object.optString("app_id");
            config.os = object.optString("os");
            config.project = object.optString("project");
            config.version = object.optString("version");
            JSONArray jsonArray = object.optJSONArray("events");
            if (jsonArray != null && jsonArray.length() > 0) {
                ArrayList<VisualConfig.VisualPropertiesConfig> visualPropertiesConfigs = new ArrayList<VisualConfig.VisualPropertiesConfig>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject visualPropertiesObject = jsonArray.optJSONObject(i);
                    if (visualPropertiesObject == null) continue;
                    VisualConfig.VisualPropertiesConfig propertiesConfig = new VisualConfig.VisualPropertiesConfig();
                    propertiesConfig.eventName = visualPropertiesObject.optString("event_name");
                    propertiesConfig.eventType = visualPropertiesObject.optString("event_type");
                    JSONObject eventObject = visualPropertiesObject.optJSONObject("event");
                    if (eventObject != null) {
                        VisualConfig.VisualEvent event = new VisualConfig.VisualEvent();
                        event.elementPath = eventObject.optString("element_path");
                        event.elementPosition = eventObject.optString("element_position");
                        event.elementContent = eventObject.optString("element_content");
                        event.screenName = eventObject.optString("screen_name");
                        event.limitElementPosition = eventObject.optBoolean("limit_element_position");
                        event.limitElementContent = eventObject.optBoolean("limit_element_content");
                        event.isH5 = eventObject.optBoolean("h5");
                        propertiesConfig.event = event;
                    }
                    ArrayList<VisualConfig.VisualProperty> visualProperties = new ArrayList<VisualConfig.VisualProperty>();
                    JSONArray properties = visualPropertiesObject.optJSONArray("properties");
                    if (properties != null && properties.length() > 0) {
                        for (int j = 0; j < properties.length(); ++j) {
                            JSONObject propertyObject = properties.optJSONObject(j);
                            VisualConfig.VisualProperty visualProperty = new VisualConfig.VisualProperty();
                            visualProperty.elementPath = propertyObject.optString("element_path");
                            visualProperty.elementPosition = propertyObject.optString("element_position");
                            visualProperty.screenName = propertyObject.optString("screen_name");
                            visualProperty.name = propertyObject.optString("name");
                            visualProperty.regular = propertyObject.optString("regular");
                            visualProperty.isH5 = propertyObject.optBoolean("h5");
                            visualProperty.type = propertyObject.optString("type");
                            visualProperty.webViewElementPath = propertyObject.optString("webview_element_path");
                            visualProperties.add(visualProperty);
                        }
                        propertiesConfig.properties = visualProperties;
                    }
                    visualPropertiesConfigs.add(propertiesConfig);
                }
                config.events = visualPropertiesConfigs;
            }
            return config;
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
            return null;
        }
    }

    private void doOnSaveCache(String config) {
        try {
            List viewList = ViewTreeStatusObservable.getInstance().getCurrentWebView();
            if (viewList == null || viewList.size() == 0) {
                return;
            }
            for (View view : viewList) {
                VisualPropertiesManager.getInstance().getVisualPropertiesH5Helper().sendToWeb(view, "updateH5VisualConfig", config);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public JSONArray getH5JsonArrayFromCache(String eventName, String webViewElementPath) {
        String persistentVisualConfig = (String)PersistentLoader.getInstance().getVisualConfigPst().get();
        if (TextUtils.isEmpty((CharSequence)persistentVisualConfig)) {
            return null;
        }
        try {
            JSONObject object = new JSONObject(persistentVisualConfig);
            JSONArray array = new JSONArray();
            JSONArray jsonArray = object.optJSONArray("events");
            if (jsonArray != null && jsonArray.length() > 0) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONArray properties;
                    JSONObject visualPropertiesObject = jsonArray.optJSONObject(i);
                    if (visualPropertiesObject == null) continue;
                    VisualConfig.VisualPropertiesConfig propertiesConfig = new VisualConfig.VisualPropertiesConfig();
                    propertiesConfig.eventName = visualPropertiesObject.optString("event_name");
                    if (!TextUtils.equals((CharSequence)propertiesConfig.eventName, (CharSequence)eventName) || (properties = visualPropertiesObject.optJSONArray("properties")) == null || properties.length() <= 0) continue;
                    for (int j = 0; j < properties.length(); ++j) {
                        JSONObject propertyObject = properties.optJSONObject(j);
                        VisualConfig.VisualProperty visualProperty = new VisualConfig.VisualProperty();
                        visualProperty.webViewElementPath = propertyObject.optString("webview_element_path");
                        if (!TextUtils.equals((CharSequence)visualProperty.webViewElementPath, (CharSequence)webViewElementPath)) continue;
                        array.put((Object)propertyObject);
                    }
                }
                return array;
            }
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return null;
    }
}

