/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.property;

import android.content.Context;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.visual.R;
import com.sensorsdata.analytics.android.sdk.visual.model.VisualConfig;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualPropertiesLog
implements VisualPropertiesManager.CollectLogListener {
    private JSONArray mJSONArray;
    private Builder mBuilder;
    private final Object object = new Object();
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getVisualPropertiesLog() {
        Object object = this.object;
        synchronized (object) {
            this.mContext = SensorsDataAPI.sharedInstance().getSAContextManager().getContext();
            if (this.mJSONArray != null) {
                return this.mJSONArray.toString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void add2JsonArray(JSONObject jsonObject) {
        Object object = this.object;
        synchronized (object) {
            if (this.mJSONArray == null) {
                this.mJSONArray = new JSONArray();
            }
            this.mJSONArray.put((Object)jsonObject);
        }
    }

    @Override
    public void onStart(String eventType, String screenName, ViewNode viewNode) {
        String elementPath = null;
        String elementPosition = null;
        String elementContent = null;
        if (viewNode != null) {
            elementPath = viewNode.getViewPath();
            elementPosition = viewNode.getViewPosition();
            elementContent = viewNode.getViewContent();
        }
        this.mBuilder = new Builder(this.mContext, eventType, screenName, elementPath, elementPosition, elementContent);
    }

    @Override
    public void onSwitchClose() {
        this.mBuilder.buildSwitchControl();
        this.add2JsonArray(this.mBuilder.build());
    }

    @Override
    public void onCheckVisualConfigFailure(String message) {
        this.mBuilder.buildVisualConfig(message);
        this.add2JsonArray(this.mBuilder.build());
    }

    @Override
    public void onCheckEventConfigFailure() {
        this.mBuilder.buildEventConfig();
        this.add2JsonArray(this.mBuilder.build());
    }

    @Override
    public void onFindPropertyElementFailure(String propertyName, String propertyElementPath, String propertyElementPosition) {
        this.mBuilder.buildPropertyElement(String.format(SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_property_error), propertyName, propertyElementPath, propertyElementPosition));
        this.add2JsonArray(this.mBuilder.build());
    }

    @Override
    public void onParsePropertyContentFailure(String propertyName, String propertyType, String elementContent, String regular) {
        this.mBuilder.buildPropertyContentParse(String.format(SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_regex_error), propertyName, elementContent, regular, propertyType));
        this.add2JsonArray(this.mBuilder.build());
    }

    @Override
    public void onOtherError(String message) {
        this.mBuilder.buildOtherError(message);
        this.add2JsonArray(this.mBuilder.build());
    }

    public static class Builder {
        private JSONObject switchControl;
        private JSONObject visualConfig;
        private JSONObject eventConfig;
        private JSONObject propertyElement;
        private JSONObject propertyContentParse;
        private JSONObject otherError;
        private String eventType;
        private String screenName;
        private String elementPath;
        private String elementPosition;
        private String elementContent;
        private String localConfig;
        private Context mContext;

        Builder(Context context, String eventType, String screenName, String elementPath, String elementPosition, String elementContent) {
            this.mContext = context;
            this.eventType = eventType;
            this.screenName = screenName;
            this.elementPath = elementPath;
            this.elementPosition = elementPosition;
            this.elementContent = elementContent;
            this.localConfig = null;
            VisualConfig config = VisualPropertiesManager.getInstance().getVisualConfig();
            if (config != null) {
                this.localConfig = config.toString();
            }
        }

        private void buildSwitchControl() {
            try {
                this.switchControl = new JSONObject().put("title", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_switch_error)).put("message", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_property_switch_error));
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }

        private void buildVisualConfig(String message) {
            try {
                this.visualConfig = new JSONObject().put("title", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_config_error)).put("message", (Object)message);
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }

        private void buildEventConfig() {
            try {
                this.eventConfig = new JSONObject().put("title", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_event_error)).put("message", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_cache_error));
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }

        private void buildPropertyElement(String message) {
            try {
                this.propertyElement = new JSONObject().put("title", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_getProperty_error)).put("message", (Object)message);
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }

        private void buildPropertyContentParse(String message) {
            try {
                this.propertyContentParse = new JSONObject().put("title", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_parseProperty_error)).put("message", (Object)message);
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }

        private void buildOtherError(String message) {
            try {
                this.otherError = new JSONObject().put("title", (Object)SADisplayUtil.getStringResource((Context)this.mContext, (int)R.string.sensors_analytics_visual_other_error)).put("message", (Object)message);
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }

        private JSONObject build() {
            JSONObject object = new JSONObject();
            try {
                object.put("event_type", (Object)this.eventType);
                object.put("element_path", (Object)this.elementPath);
                object.put("element_position", (Object)this.elementPosition);
                object.put("element_content", (Object)this.elementContent);
                object.put("screen_name", (Object)this.screenName);
                object.put("local_config", (Object)this.localConfig);
                JSONArray message = new JSONArray();
                if (this.switchControl != null) {
                    message.put((Object)this.switchControl);
                }
                if (this.visualConfig != null) {
                    message.put((Object)this.visualConfig);
                }
                if (this.eventConfig != null) {
                    message.put((Object)this.eventConfig);
                }
                if (this.propertyElement != null) {
                    message.put((Object)this.propertyElement);
                }
                if (this.propertyContentParse != null) {
                    message.put((Object)this.propertyContentParse);
                }
                if (this.otherError != null) {
                    message.put((Object)this.otherError);
                }
                object.put("message", (Object)message);
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
            return object;
        }
    }
}

