/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.cmdline;

import com.senzing.cmdline.CommandLineOption;
import com.senzing.cmdline.CommandLineSource;
import com.senzing.cmdline.SpecifiedOption;
import com.senzing.cmdline.SpecifiedOptionException;
import java.util.List;

public class BadOptionParameterCountException
extends SpecifiedOptionException {
    private List<String> parameters;

    public BadOptionParameterCountException(CommandLineSource source, CommandLineOption option, String specifier, List<String> params) {
        super(source, option, specifier, BadOptionParameterCountException.buildErrorMessage(source, option, specifier, params));
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public static String buildErrorMessage(CommandLineSource source, CommandLineOption option, String specifier, List<String> params) throws NullPointerException, IllegalArgumentException {
        int minCount = option.getMaximumParameterCount();
        int maxCount = option.getMaximumParameterCount();
        int paramCount = params.size();
        StringBuilder sb = new StringBuilder("Too ");
        if (paramCount < minCount) {
            sb.append("few");
        } else if (maxCount > 0 && paramCount > maxCount) {
            sb.append("many");
        } else {
            throw new IllegalArgumentException("The specified parameter list has a parameter count that is valid for the specified option.  source=[ " + source + " ], option=[ " + option + " ], specifier=[ " + specifier + " ], count=[ " + paramCount + " ], minCount=[ " + minCount + " ], maxCount=[ " + maxCount + " ], params=[ " + params + " ]");
        }
        sb.append(" parameters for the ");
        sb.append(SpecifiedOption.sourceDescriptor(source, option, specifier));
        sb.append(".  Expected at ");
        if (paramCount < minCount) {
            sb.append("least ").append(minCount);
        } else if (maxCount > 0 && paramCount > maxCount) {
            sb.append("most ").append(maxCount);
        }
        sb.append(" parameters but received ").append(paramCount).append(": ");
        String prefix = "";
        for (String param : params) {
            sb.append(prefix).append(param);
            prefix = ", ";
        }
        return sb.toString();
    }
}

