/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.cmdline;

import com.senzing.cmdline.BadOptionParameterCountException;
import com.senzing.cmdline.BadOptionParametersException;
import com.senzing.cmdline.CommandLineException;
import com.senzing.cmdline.CommandLineOption;
import com.senzing.cmdline.CommandLineSource;
import com.senzing.cmdline.CommandLineValue;
import com.senzing.cmdline.ConflictingOptionsException;
import com.senzing.cmdline.DeprecatedOptionWarning;
import com.senzing.cmdline.MissingDependenciesException;
import com.senzing.cmdline.NoPrimaryOptionException;
import com.senzing.cmdline.ParameterProcessor;
import com.senzing.cmdline.RepeatedOptionException;
import com.senzing.cmdline.TooFewArgumentsException;
import com.senzing.cmdline.UnrecognizedOptionException;
import com.senzing.util.JsonUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public class CommandLineUtilities {
    public static final String REDACTED_SENSITIVE_VALUE = "********";
    private static final Pattern JSON_ARRAY_PATTERN = Pattern.compile("\\s*\\[\\s*((\\\".*\\\"\\s*,\\s*)+(\\\".*\\\")|(\\\".*\\\")?)\\s*\\]\\s*");
    public static final String JAR_FILE_NAME;
    public static final String JAR_BASE_URL;
    public static final String PATH_TO_JAR;

    private CommandLineUtilities() {
    }

    public static String[] shiftArguments(String[] args, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("The specified count cannot be negative: " + count);
        }
        if (args.length - count < 0) {
            throw new TooFewArgumentsException("The specified shift count cannot be greater than the array length.  arrayLength=[ " + args.length + " ], shiftCount=[ " + count + " ]");
        }
        String[] args2 = new String[args.length - count];
        for (int index = 0; index < args2.length; ++index) {
            args2[index] = args[index + count];
        }
        return args2;
    }

    public static <T extends Enum<T>, B extends Enum<B>> void putValue(Map<CommandLineOption, CommandLineValue> optionMap, CommandLineValue value) throws CommandLineException {
        CommandLineOption option = value.getOption();
        Set<CommandLineOption> optionKeys = optionMap.keySet();
        CommandLineValue prevValue = optionMap.get(option);
        if (prevValue != null) {
            HashSet<String> flags = new HashSet<String>();
            if (value.getSource() == CommandLineSource.COMMAND_LINE) {
                flags.add(value.getSpecifier());
            }
            if (prevValue.getSource() == CommandLineSource.COMMAND_LINE) {
                flags.add(prevValue.getSpecifier());
            }
            throw new RepeatedOptionException(option, flags);
        }
        if (!CommandLineUtilities.checkNoArgFalse(value) && value.getSource() != CommandLineSource.DEFAULT) {
            Set<CommandLineOption> conflicts = option.getConflicts();
            for (CommandLineOption opt : optionKeys) {
                CommandLineValue conflictValue;
                Set<CommandLineOption> revConflicts = opt.getConflicts();
                if ((conflicts == null || !conflicts.contains(opt)) && (revConflicts == null || !revConflicts.contains(option)) || (conflictValue = optionMap.get(opt)).getSource() == CommandLineSource.DEFAULT || CommandLineUtilities.checkNoArgFalse(conflictValue)) continue;
                throw new ConflictingOptionsException(conflictValue, value);
            }
        }
        optionMap.put(option, value);
    }

    private static <T extends Enum<T>, B extends Enum<B>> boolean checkNoArgFalse(CommandLineValue cmdLineValue) {
        CommandLineOption option = cmdLineValue.getOption();
        int minParamCount = option.getMinimumParameterCount();
        int maxParamCount = option.getMaximumParameterCount();
        List<String> defaultParams = option.getDefaultParameters();
        List<String> actualParams = cmdLineValue.getParameters();
        return minParamCount == 0 && maxParamCount >= 0 && defaultParams != null && defaultParams.size() == 1 && "false".equalsIgnoreCase(defaultParams.get(0)) && actualParams != null && actualParams.size() == 1 && "false".equalsIgnoreCase(actualParams.get(0));
    }

    public static <T extends Enum<T>, B extends Enum<B>> T lookup(Class<T> enumClass, String commandLineFlag) {
        EnumSet<Enum> enumSet = EnumSet.allOf(enumClass);
        for (Enum enumVal : enumSet) {
            if (((CommandLineOption)((Object)enumVal)).getCommandLineFlag().equals(commandLineFlag)) {
                return (T)enumVal;
            }
            if (!((CommandLineOption)((Object)enumVal)).getSynonymFlags().contains(commandLineFlag)) continue;
            return (T)enumVal;
        }
        return null;
    }

    private static <T extends Enum<T>, B extends Enum<B>> boolean checkPrimaryRequired(Class<T> enumClass) {
        boolean primaryRequired = false;
        EnumSet<Enum> enumSet = EnumSet.allOf(enumClass);
        for (Enum enumVal : enumSet) {
            if (!((CommandLineOption)((Object)enumVal)).isPrimary()) continue;
            return true;
        }
        Class baseType = ((CommandLineOption)enumSet.iterator().next()).getBaseOptionType();
        if (baseType != null && Enum.class.isAssignableFrom(baseType)) {
            return CommandLineUtilities.checkPrimaryRequired(baseType);
        }
        return false;
    }

    private static <T extends Enum<T>, B extends Enum<B>> Set<CommandLineOption> getPrimaryOptions(Class<T> enumClass) {
        LinkedHashSet<CommandLineOption> result = new LinkedHashSet<CommandLineOption>();
        CommandLineUtilities.populatePrimaryOptions(result, enumClass);
        return result;
    }

    private static <T extends Enum<T>, B extends Enum<B>> void populatePrimaryOptions(Set<CommandLineOption> set, Class<T> enumClass) {
        EnumSet<Enum> enumSet = EnumSet.allOf(enumClass);
        for (Enum enumVal : enumSet) {
            if (!((CommandLineOption)((Object)enumVal)).isPrimary()) continue;
            set.add((CommandLineOption)((Object)enumVal));
        }
        Class baseType = ((CommandLineOption)enumSet.iterator().next()).getBaseOptionType();
        if (baseType != null && Enum.class.isAssignableFrom(baseType)) {
            CommandLineUtilities.populatePrimaryOptions(set, baseType);
        }
    }

    private static <T extends Enum<T>, B extends Enum<B>> Set<Class<? extends CommandLineOption>> getTypeChain(Class<T> enumClass) {
        LinkedHashSet<Class<? extends CommandLineOption>> result = new LinkedHashSet<Class<? extends CommandLineOption>>();
        CommandLineUtilities.populateTypeChain(result, enumClass);
        return result;
    }

    private static <T extends Enum<T>, B extends Enum<B>> void populateTypeChain(Set<Class<? extends CommandLineOption>> set, Class<T> enumClass) {
        if (enumClass == null) {
            return;
        }
        set.add(enumClass);
        EnumSet<T> enumSet = EnumSet.allOf(enumClass);
        Class baseType = ((CommandLineOption)((Object)((Enum)enumSet.iterator().next()))).getBaseOptionType();
        if (baseType != null) {
            CommandLineUtilities.populateTypeChain(set, baseType);
        }
    }

    private static <T extends Enum<T>, B extends Enum<B>> void populateOptionsChain(Set<CommandLineOption> set, Class<T> enumClass) {
        if (enumClass == null) {
            return;
        }
        EnumSet<Enum> enumSet = EnumSet.allOf(enumClass);
        Class baseType = null;
        for (Enum option : enumSet) {
            set.add((CommandLineOption)((Object)option));
            if (baseType != null) continue;
            baseType = ((CommandLineOption)((Object)option)).getBaseOptionType();
        }
        if (baseType != null) {
            CommandLineUtilities.populateOptionsChain(set, baseType);
        }
    }

    public static <T extends Enum<T>, B extends Enum<B>> List<DeprecatedOptionWarning> validateOptions(Class<T> enumClass, Map<CommandLineOption, CommandLineValue> optionValues) throws IllegalArgumentException, CommandLineException {
        boolean primaryRequired;
        LinkedList<DeprecatedOptionWarning> deprecatedList = new LinkedList<DeprecatedOptionWarning>();
        Set<Class<CommandLineOption>> typeChainSet = CommandLineUtilities.getTypeChain(enumClass);
        optionValues.forEach((option, optionValue) -> {
            if (option != optionValue.getOption()) {
                throw new IllegalArgumentException("Mismatch on option values key/value pair.  The option key does not the associated CommandLineValue's option.  optionKey=[ " + option + " ], optionValue=[ " + optionValue.getOption() + " ]");
            }
            if (!typeChainSet.contains(option.getClass())) {
                throw new IllegalArgumentException("The specified option values map contains an option of an illegal type given the specified CommandLineOption type.  found=[ " + option + " ], foundType=[ " + option.getClass() + " ], expected=[ " + typeChainSet + " ]");
            }
        });
        Set<CommandLineOption> primaryOptions = CommandLineUtilities.getPrimaryOptions(enumClass);
        boolean bl = primaryRequired = primaryOptions.size() > 0;
        if (primaryRequired) {
            int primaryCount = 0;
            for (CommandLineOption option2 : optionValues.keySet()) {
                if (!option2.isPrimary()) continue;
                ++primaryCount;
            }
            if (primaryCount == 0) {
                throw new NoPrimaryOptionException(primaryOptions);
            }
        }
        for (CommandLineValue cmdLineValue : optionValues.values()) {
            boolean satisfied;
            CommandLineOption option2;
            if (cmdLineValue.getSource() == CommandLineSource.DEFAULT) continue;
            option2 = cmdLineValue.getOption();
            if (option2.isDeprecated()) {
                deprecatedList.add(new DeprecatedOptionWarning(cmdLineValue));
            }
            Set<CommandLineOption> conflicts = option2.getConflicts();
            Set<Set<CommandLineOption>> dependencies = option2.getDependencies();
            if (conflicts != null) {
                for (CommandLineOption conflict : conflicts) {
                    CommandLineValue conflictValue;
                    if (option2 == conflict || (conflictValue = optionValues.get(conflict)) == null || conflictValue.getSource() == CommandLineSource.DEFAULT) continue;
                    throw new ConflictingOptionsException(cmdLineValue, conflictValue);
                }
            }
            boolean bl2 = satisfied = dependencies == null || dependencies.size() == 0;
            if (!satisfied) {
                for (Set<CommandLineOption> dependencySet : dependencies) {
                    if (!optionValues.keySet().containsAll(dependencySet)) continue;
                    satisfied = true;
                    break;
                }
            }
            if (satisfied) continue;
            throw new MissingDependenciesException(cmdLineValue.getSource(), cmdLineValue.getOption(), cmdLineValue.getSpecifier(), optionValues.keySet());
        }
        return deprecatedList.size() == 0 ? null : deprecatedList;
    }

    private static Map<String, CommandLineOption> createFlagLookupMap(Class enumClass) {
        EnumSet<Enum> enumSet = EnumSet.allOf(enumClass);
        LinkedHashMap<String, CommandLineOption> lookupMap = new LinkedHashMap<String, CommandLineOption>();
        for (Enum optionEnum : enumSet) {
            CommandLineOption option = (CommandLineOption)((Object)optionEnum);
            String flag2 = option.getCommandLineFlag();
            if (lookupMap.containsKey(flag2)) {
                throw new IllegalStateException("Command-line flag (" + flag2 + ") cannot resolve to different options (" + lookupMap.get(flag2) + " and " + option + ").  It must be unique.");
            }
            lookupMap.put(flag2, option);
            Set<String> synonymFlags = option.getSynonymFlags();
            if (synonymFlags == null) {
                synonymFlags = Collections.emptySet();
            }
            for (String synonym : synonymFlags) {
                if (synonym.equals(flag2)) {
                    throw new IllegalStateException("Synonym command-line (" + flag2 + ") for option (" + option + ") is the same as the primary flag.");
                }
                if (lookupMap.containsKey(synonym)) {
                    throw new IllegalStateException("Command-line flag (" + flag2 + ") cannot resolve to different options (" + lookupMap.get(flag2) + " and " + option + ").  It must be unique.");
                }
                lookupMap.put(synonym, option);
            }
        }
        Class baseType = ((CommandLineOption)enumSet.iterator().next()).getBaseOptionType();
        if (baseType != null) {
            Map<String, CommandLineOption> baseMap = CommandLineUtilities.createFlagLookupMap(baseType);
            baseMap.keySet().forEach(flag -> {
                if (lookupMap.containsKey(flag)) {
                    CommandLineOption option = (CommandLineOption)lookupMap.get(flag);
                    CommandLineOption baseOption = (CommandLineOption)baseMap.get(flag);
                    throw new IllegalStateException("Command-line flag (" + flag + ") for " + option + " in " + enumClass + " conflicts with " + baseOption + " in the " + baseType + " base option class.");
                }
            });
            lookupMap.putAll(baseMap);
        }
        return lookupMap;
    }

    public static <T extends Enum<T>, B extends Enum<B>> Map<CommandLineOption, CommandLineValue> parseCommandLine(Class<T> enumClass, String[] args, ParameterProcessor processor, List<DeprecatedOptionWarning> deprecationWarnings) throws CommandLineException {
        return CommandLineUtilities.parseCommandLine(enumClass, args, processor, false, null, deprecationWarnings);
    }

    public static <T extends Enum<T>, B extends Enum<B>> Map<CommandLineOption, CommandLineValue> parseCommandLine(Class<T> enumClass, String[] args, ParameterProcessor processor, boolean ignoreEnvironment, List<DeprecatedOptionWarning> deprecationWarnings) throws CommandLineException {
        return CommandLineUtilities.parseCommandLine(enumClass, args, processor, false, null, deprecationWarnings);
    }

    public static <T extends Enum<T>, B extends Enum<B>> Map<CommandLineOption, CommandLineValue> parseCommandLine(Class<T> enumClass, String[] args, ParameterProcessor processor, CommandLineOption ignoreEnvOption, List<DeprecatedOptionWarning> deprecationWarnings) throws CommandLineException {
        return CommandLineUtilities.parseCommandLine(enumClass, args, processor, false, ignoreEnvOption, deprecationWarnings);
    }

    private static <T extends Enum<T>, B extends Enum<B>> Map<CommandLineOption, CommandLineValue> parseCommandLine(Class<T> enumClass, String[] args, ParameterProcessor processor, boolean ignoreEnvironment, CommandLineOption ignoreEnvOption, List<DeprecatedOptionWarning> deprecationWarnings) throws CommandLineException {
        LinkedHashMap<CommandLineOption, CommandLineValue> result = new LinkedHashMap<CommandLineOption, CommandLineValue>();
        Map<String, CommandLineOption> lookupMap = CommandLineUtilities.createFlagLookupMap(enumClass);
        LinkedHashMap usedFlags = new LinkedHashMap();
        for (int index = 0; index < args.length; ++index) {
            String flag = args[index];
            CommandLineOption option = lookupMap.get(flag);
            if (option == null) {
                throw new UnrecognizedOptionException(flag, "Unrecognized command line option: " + flag);
            }
            String usedFlag = (String)usedFlags.get(option);
            if (usedFlag != null) {
                Set<String> flags = Set.of(flag, usedFlag);
                throw new RepeatedOptionException(option, flags);
            }
            int minParamCount = option.getMinimumParameterCount();
            int maxParamCount = option.getMaximumParameterCount();
            if (maxParamCount >= 0 && maxParamCount < minParamCount) {
                throw new IllegalStateException("The non-negative maximum parameter count is less than the minimum parameter count.  min=[ " + minParamCount + " ], max=[ " + maxParamCount + " ], option=[ " + option + " ]");
            }
            ArrayList<String> params = new ArrayList<String>(maxParamCount < 0 ? 5 : maxParamCount);
            if (minParamCount > 0) {
                int max = index + minParamCount;
                ++index;
                while (index <= max) {
                    if (index >= args.length) {
                        throw new BadOptionParameterCountException(CommandLineSource.COMMAND_LINE, option, flag, params);
                    }
                    params.add(args[index]);
                    ++index;
                }
                --index;
            }
            List<String> defaultParams = option.getDefaultParameters();
            if (minParamCount == 0 && maxParamCount == 0 && defaultParams != null && defaultParams.size() == 1 && "false".equalsIgnoreCase(defaultParams.get(0))) {
                String param;
                if (args.length > index + 1 && !(param = args[index + 1].trim().toLowerCase()).startsWith("-")) {
                    switch (param) {
                        case "true": 
                        case "false": {
                            params.add(args[++index].trim().toLowerCase());
                            break;
                        }
                        default: {
                            throw new BadOptionParametersException(CommandLineSource.COMMAND_LINE, option, flag, List.of(param), "The " + flag + " command line option can be specified with no parameters, but if a parameter is provided it must be \"true\" or \"false\": " + args[index + 1]);
                        }
                    }
                }
            } else {
                int nextIndex;
                int bound;
                int n = bound = maxParamCount < 0 ? args.length : index + (maxParamCount - minParamCount) + 1;
                if (bound > args.length) {
                    bound = args.length;
                }
                for (nextIndex = index + 1; nextIndex < bound && !lookupMap.containsKey(args[nextIndex]); ++nextIndex) {
                    params.add(args[nextIndex]);
                    ++index;
                }
                for (nextIndex = index + 1; nextIndex < args.length && !args[nextIndex].startsWith("-") && !lookupMap.containsKey(args[index]); ++nextIndex) {
                    params.add(args[nextIndex]);
                    ++index;
                }
                if (maxParamCount >= 0 && params.size() > maxParamCount) {
                    throw new BadOptionParameterCountException(CommandLineSource.COMMAND_LINE, option, flag, params);
                }
            }
            defaultParams = option.getDefaultParameters();
            if (minParamCount == 0 && maxParamCount == 0 && params.size() == 0 && defaultParams != null && defaultParams.size() == 1 && "false".equalsIgnoreCase(defaultParams.get(0))) {
                params.add("true");
            }
            Object processedValue = CommandLineUtilities.processValue(CommandLineSource.COMMAND_LINE, option, flag, processor, params);
            CommandLineValue cmdLineVal = new CommandLineValue(CommandLineSource.COMMAND_LINE, option, flag, processedValue, params);
            CommandLineUtilities.putValue(result, cmdLineVal);
        }
        boolean bl = ignoreEnvironment = ignoreEnvironment || result.containsKey(ignoreEnvOption) && !Boolean.FALSE.equals(result.get(ignoreEnvOption));
        if (!ignoreEnvironment) {
            try {
                CommandLineUtilities.processEnvironment(enumClass, processor, result);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw e;
            }
        }
        try {
            CommandLineUtilities.processDefaults(enumClass, processor, result);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
        try {
            List<DeprecatedOptionWarning> warnings = CommandLineUtilities.validateOptions(enumClass, result);
            if (deprecationWarnings != null && warnings != null) {
                deprecationWarnings.addAll(warnings);
            }
            return result;
        }
        catch (CommandLineException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static Object processValue(CommandLineSource source, CommandLineOption option, String specifier, ParameterProcessor processor, List<String> params) throws BadOptionParametersException {
        if (processor != null) {
            Object value = null;
            try {
                value = processor.process(option, params);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                pw.println("Bad parameters for " + option.getCommandLineFlag() + " option:");
                for (String p : params) {
                    pw.println("    o " + p);
                }
                pw.println();
                pw.println(e.getMessage());
                pw.flush();
                throw new BadOptionParametersException(source, option, specifier, params, sw.toString());
            }
            return value;
        }
        if (params.size() == 0) {
            return null;
        }
        if (params.size() == 1) {
            return params.get(0);
        }
        return params.toArray();
    }

    private static <T extends Enum<T>, B extends Enum<B>> void processEnvironment(Class<T> enumClass, ParameterProcessor processor, Map<CommandLineOption, CommandLineValue> optionValues) throws CommandLineException {
        LinkedHashSet<CommandLineOption> options = new LinkedHashSet<CommandLineOption>();
        CommandLineUtilities.populateOptionsChain(options, enumClass);
        CommandLineUtilities.processEnvironment(options, processor, optionValues, false);
        LinkedHashSet fallbackOptions = new LinkedHashSet();
        Set<CommandLineOption> primaryOptions = CommandLineUtilities.getPrimaryOptions(enumClass);
        for (CommandLineOption primaryOption : primaryOptions) {
            List<String> fallbacks;
            if (optionValues.containsKey(primaryOption) || (fallbacks = primaryOption.getEnvironmentFallbacks()) == null || fallbacks.size() <= 0) continue;
            fallbackOptions.add(primaryOption);
        }
        Set<CommandLineOption> optionKeys = optionValues.keySet();
        block1: for (CommandLineOption option : optionKeys) {
            Set<Set<CommandLineOption>> dependencySets = option.getDependencies();
            if (dependencySets == null || dependencySets.size() == 0) continue;
            boolean satisfied = false;
            for (Set<CommandLineOption> dependencySet : dependencySets) {
                if (!optionValues.keySet().containsAll(dependencySet)) continue;
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            for (Set<CommandLineOption> dependencySet : dependencySets) {
                int fallbackCount = 0;
                LinkedHashSet<CommandLineOption> missingSet = new LinkedHashSet<CommandLineOption>();
                for (CommandLineOption dependency : dependencySet) {
                    if (optionValues.containsKey(dependency)) continue;
                    missingSet.add(dependency);
                    List<String> fallbacks = dependency.getEnvironmentFallbacks();
                    if (fallbacks == null || fallbacks.size() <= 0) continue;
                    ++fallbackCount;
                }
                if (missingSet.size() <= 0 || missingSet.size() != fallbackCount) continue;
                fallbackOptions.addAll(missingSet);
                continue block1;
            }
        }
        if (fallbackOptions.size() > 0) {
            CommandLineUtilities.processEnvironment(fallbackOptions, processor, optionValues, true);
        }
    }

    private static void processEnvironment(Set<? extends CommandLineOption> enumSet, ParameterProcessor processor, Map<CommandLineOption, CommandLineValue> optionValues, boolean fallBacks) throws CommandLineException {
        Map<String, String> env = System.getenv();
        for (CommandLineOption commandLineOption : enumSet) {
            if (optionValues.containsKey(commandLineOption)) continue;
            List<String> envVars = null;
            if (fallBacks) {
                envVars = commandLineOption.getEnvironmentFallbacks();
                if (envVars == null) {
                    envVars = Collections.emptyList();
                }
            } else {
                String envVar = commandLineOption.getEnvironmentVariable();
                Set<String> synonymSet = commandLineOption.getEnvironmentSynonyms();
                envVars = new ArrayList(synonymSet == null ? 1 : synonymSet.size() + 1);
                if (envVar != null) {
                    envVars.add(envVar);
                }
                if (synonymSet != null) {
                    envVars.addAll(synonymSet);
                }
            }
            String envVal = null;
            String foundVar = null;
            for (String envVar : envVars) {
                if (envVar == null || (envVal = env.get(envVar)) == null) continue;
                foundVar = envVar;
                break;
            }
            if (envVal == null) continue;
            int minParamCount = commandLineOption.getMinimumParameterCount();
            int maxParamCount = commandLineOption.getMaximumParameterCount();
            if (maxParamCount > 0 && maxParamCount < minParamCount) {
                throw new IllegalStateException("The non-negative maximum parameter count is less than the minimum parameter count.  min=[ " + minParamCount + " ], max=[ " + maxParamCount + " ], option=[ " + commandLineOption + " ]");
            }
            List<String> params = null;
            if (minParamCount == 0 && maxParamCount == 0) {
                switch (envVal.trim().toLowerCase()) {
                    case "": 
                    case "true": {
                        params = List.of("true");
                        break;
                    }
                    case "false": {
                        params = List.of("false");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The specified value for the " + foundVar + " environment variable can only be \"true\" or \"false\": " + foundVar);
                    }
                }
            } else if (minParamCount <= 1 && maxParamCount == 1) {
                params = List.of(envVal);
            } else if ((maxParamCount > 1 || maxParamCount < 0) && JSON_ARRAY_PATTERN.matcher(envVal).matches()) {
                JsonArray jsonArray = JsonUtilities.parseJsonArray(envVal.trim());
                params = new ArrayList<String>(jsonArray.size());
                for (JsonString jsonString : jsonArray.getValuesAs(JsonString.class)) {
                    params.add(jsonString.getString());
                }
            } else if (maxParamCount > 1 || maxParamCount < 0) {
                String[] tokens = envVal.split("(\\s*,\\s*|\\s+)");
                params = Arrays.asList(tokens);
            }
            int paramCount = params.size();
            if (paramCount != 1 || minParamCount != 0 || maxParamCount != 0) {
                if (paramCount < minParamCount) {
                    throw new BadOptionParameterCountException(CommandLineSource.ENVIRONMENT, commandLineOption, foundVar, params);
                }
                if (maxParamCount >= 0 && paramCount > maxParamCount) {
                    throw new BadOptionParameterCountException(CommandLineSource.ENVIRONMENT, commandLineOption, foundVar, params);
                }
            }
            Object processedValue = CommandLineUtilities.processValue(CommandLineSource.ENVIRONMENT, commandLineOption, foundVar, processor, params);
            CommandLineValue cmdLineVal = new CommandLineValue(CommandLineSource.ENVIRONMENT, commandLineOption, foundVar, processedValue, params);
            CommandLineUtilities.putValue(optionValues, cmdLineVal);
        }
    }

    private static <T extends Enum<T>, B extends Enum<B>> void processDefaults(Class<T> enumClass, ParameterProcessor processor, Map<CommandLineOption, CommandLineValue> optionValues) throws CommandLineException {
        LinkedHashSet<CommandLineOption> options = new LinkedHashSet<CommandLineOption>();
        CommandLineUtilities.populateOptionsChain(options, enumClass);
        for (CommandLineOption option : options) {
            List<String> params;
            if (optionValues.containsKey(option) || (params = option.getDefaultParameters()) == null || params.size() == 0) continue;
            Object processedValue = CommandLineUtilities.processValue(CommandLineSource.DEFAULT, option, null, processor, params);
            CommandLineValue cmdLineVal = new CommandLineValue(CommandLineSource.DEFAULT, option, processedValue, params);
            CommandLineUtilities.putValue(optionValues, cmdLineVal);
        }
    }

    public static Map<CommandLineOption, Object> processCommandLine(Map<CommandLineOption, CommandLineValue> optionValues, Map<CommandLineOption, Object> processedValues) {
        return CommandLineUtilities.processCommandLine(optionValues, processedValues, null, null);
    }

    public static Map<CommandLineOption, Object> processCommandLine(Map<CommandLineOption, CommandLineValue> optionValues, Map<CommandLineOption, Object> processedValues, JsonObjectBuilder jsonBuilder) {
        return CommandLineUtilities.processCommandLine(optionValues, processedValues, jsonBuilder, null);
    }

    public static Map<CommandLineOption, Object> processCommandLine(Map<CommandLineOption, CommandLineValue> optionValues, Map<CommandLineOption, Object> processedValues, StringBuilder stringBuilder) {
        return CommandLineUtilities.processCommandLine(optionValues, processedValues, null, stringBuilder);
    }

    public static Map<CommandLineOption, Object> processCommandLine(Map<CommandLineOption, CommandLineValue> optionValues, Map<CommandLineOption, Object> processedValues, JsonObjectBuilder jsonBuilder, StringBuilder stringBuilder) {
        LinkedHashMap<CommandLineOption, Object> result = processedValues == null ? new LinkedHashMap<CommandLineOption, Object>() : processedValues;
        boolean doJson = jsonBuilder != null || stringBuilder != null;
        JsonObjectBuilder job = doJson && (jsonBuilder == null || stringBuilder != null) ? Json.createObjectBuilder() : jsonBuilder;
        optionValues.forEach((key, cmdLineVal) -> {
            if (key != cmdLineVal.getOption()) {
                throw new IllegalArgumentException("CommandLineOption key does not match the option from the paired CommandLineValue value.  key=[ " + key + " ], value=[ " + cmdLineVal + " ]");
            }
            JsonObjectBuilder job2 = doJson ? Json.createObjectBuilder() : null;
            List<String> params = cmdLineVal.getParameters();
            if (doJson) {
                if (key.isSensitive()) {
                    job2.add("value", REDACTED_SENSITIVE_VALUE);
                } else if (params.size() == 1) {
                    job2.add("value", params.get(0));
                } else {
                    JsonArrayBuilder jab = Json.createArrayBuilder();
                    for (String param : params) {
                        jab.add(param);
                    }
                    job2.add("values", jab);
                }
                job2.add("source", cmdLineVal.getSource().toString());
                if (cmdLineVal.getSpecifier() != null) {
                    job2.add("via", cmdLineVal.getSpecifier());
                }
                JsonObject jsonObject = job2.build();
                job.add(key.toString(), (JsonValue)jsonObject);
                if (jsonBuilder != null && job != jsonBuilder) {
                    jsonBuilder.add(key.toString(), (JsonValue)jsonObject);
                }
            }
            result.put((CommandLineOption)key, cmdLineVal.getProcessedValue());
        });
        if (stringBuilder != null) {
            stringBuilder.append(JsonUtilities.toJsonText(job));
        }
        return result;
    }

    public static boolean checkClassIsMain(Class cls) {
        Throwable t = new Throwable();
        StackTraceElement[] trace = t.getStackTrace();
        StackTraceElement lastStackFrame = trace[trace.length - 1];
        String className = lastStackFrame.getClassName();
        String methodName = lastStackFrame.getMethodName();
        return "main".equals(methodName) && cls.getName().equals(className);
    }

    public static String formatUsageOptionsList(int indent, CommandLineOption ... options) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int maxLength = 0;
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indent; ++index) {
            sb.append(" ");
        }
        String indenter = sb.toString();
        for (CommandLineOption option : options) {
            if (option.getCommandLineFlag().length() <= maxLength) continue;
            maxLength = option.getCommandLineFlag().length();
        }
        String spacer = "  ";
        String bullet = "o ";
        int columnCount = (80 - indent - spacer.length()) / (maxLength += bullet.length() + spacer.length());
        if (options.length == columnCount + 1) {
            --columnCount;
        }
        if (columnCount < 1) {
            columnCount = 1;
        }
        int columnIndex = 0;
        for (CommandLineOption option : options) {
            String flag = option.getCommandLineFlag();
            int spaceCount = maxLength - flag.length() - bullet.length();
            if (columnIndex == 0) {
                pw.print(indenter);
            } else {
                pw.print(spacer);
            }
            pw.print(bullet);
            pw.print(flag);
            for (int index = 0; index < spaceCount; ++index) {
                pw.print(" ");
            }
            if (columnIndex == columnCount - 1) {
                pw.println();
                columnIndex = 0;
                continue;
            }
            ++columnIndex;
        }
        if (columnIndex != 0) {
            pw.println();
        }
        pw.flush();
        return sw.toString();
    }

    public static String getJarBaseUrl(Class cls) {
        String simpleName = cls.getSimpleName();
        String url = cls.getResource(simpleName + ".class").toString();
        int index = url.lastIndexOf(cls.getName().replace(".", "/") + ".class");
        if (index < 0) {
            return null;
        }
        return url.substring(0, index);
    }

    public static String getJarName(Class cls) {
        int index;
        String url = CommandLineUtilities.getJarBaseUrl(cls);
        if (url == null) {
            return null;
        }
        if (url.indexOf(".jar") >= 0 && (index = url.lastIndexOf("!")) >= 0 && (index = (url = url.substring(0, index)).lastIndexOf("/")) >= 0) {
            return url.substring(index + 1);
        }
        return null;
    }

    public static String getJarPath(Class cls) {
        int index;
        String url = CommandLineUtilities.getJarBaseUrl(cls);
        if (url == null) {
            return null;
        }
        if (url.indexOf(".jar") >= 0 && (index = url.lastIndexOf("!")) >= 0 && (index = (url = url.substring(0, index)).lastIndexOf("/")) >= 0 && (index = (url = url.substring(0, index)).indexOf("/")) >= 0) {
            return url.substring(index);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            Class<CommandLineUtilities> cls = CommandLineUtilities.class;
            System.out.println("BASE URL: " + CommandLineUtilities.getJarBaseUrl(cls));
            System.out.println("JAR NAME: " + CommandLineUtilities.getJarName(cls));
            System.out.println("JAR PATH: " + CommandLineUtilities.getJarPath(cls));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        String jarBaseUrl = null;
        String jarFileName = null;
        String pathToJar = null;
        try {
            Class<CommandLineUtilities> cls = CommandLineUtilities.class;
            String url = cls.getResource(cls.getSimpleName() + ".class").toString();
            if (url.indexOf(".jar") >= 0) {
                int index = url.lastIndexOf(cls.getName().replace(".", "/") + ".class");
                jarBaseUrl = url.substring(0, index);
                if ((index = jarBaseUrl.lastIndexOf("!")) >= 0) {
                    if ((index = (url = url.substring(0, index)).lastIndexOf("/")) >= 0) {
                        jarFileName = url.substring(index + 1);
                    }
                    url = url.substring(0, index);
                    index = url.indexOf("/");
                    pathToJar = url.substring(index);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
        finally {
            JAR_BASE_URL = jarBaseUrl;
            JAR_FILE_NAME = jarFileName;
            PATH_TO_JAR = pathToJar;
        }
    }
}

