/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.cmdline;

import com.senzing.cmdline.CommandLineOption;
import com.senzing.cmdline.CommandLineSource;
import com.senzing.cmdline.SpecifiedOption;
import com.senzing.cmdline.SpecifiedOptionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;

public class MissingDependenciesException
extends SpecifiedOptionException {
    public MissingDependenciesException(CommandLineSource source, CommandLineOption option, String specifier, Set<CommandLineOption> specifiedOptions) {
        super(source, option, specifier, MissingDependenciesException.buildErrorMessage(source, option, option.getDependencies(), specifier, specifiedOptions));
    }

    public MissingDependenciesException(CommandLineSource source, CommandLineOption option, Set<Set<CommandLineOption>> dependencySets, String specifier, Set<CommandLineOption> specifiedOptions) {
        super(source, option, specifier, MissingDependenciesException.buildErrorMessage(source, option, dependencySets, specifier, specifiedOptions));
    }

    public static String buildErrorMessage(CommandLineSource source, CommandLineOption option, Set<Set<CommandLineOption>> dependencySets, String specifier, Set<CommandLineOption> specifiedOptions) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String sourceDescriptor = SpecifiedOption.sourceDescriptor(source, option, specifier);
        pw.println("Dependent options for the " + sourceDescriptor + " are missing.");
        pw.println("The " + sourceDescriptor + " also requires:");
        String prefix = null;
        for (Set<CommandLineOption> dependencySet : dependencySets) {
            boolean conflicting = false;
            for (CommandLineOption specifiedOption : specifiedOptions) {
                Set<CommandLineOption> conflicts = specifiedOption.getConflicts();
                if (conflicts != null) {
                    for (CommandLineOption conflict : conflicts) {
                        if (!dependencySet.contains(conflict)) continue;
                        conflicting = true;
                        break;
                    }
                }
                if (!conflicting) continue;
                break;
            }
            if (conflicting) continue;
            pw.println();
            if (prefix != null) {
                pw.println(prefix);
                pw.println();
            }
            for (CommandLineOption dependency : dependencySet) {
                if (specifiedOptions.contains(dependency)) continue;
                pw.print("     o " + dependency.getCommandLineFlag());
                if (dependency.getEnvironmentVariable() != null) {
                    pw.print(" (env: " + dependency.getEnvironmentVariable() + ")");
                }
                pw.println();
            }
            prefix = "     ==================================  OR  ==================================";
        }
        pw.flush();
        return sw.toString();
    }
}

