/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.cmdline;

import com.senzing.cmdline.CommandLineException;
import com.senzing.cmdline.CommandLineOption;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Set;

public class NoPrimaryOptionException
extends CommandLineException {
    private Set<CommandLineOption> primaryOptions;

    public NoPrimaryOptionException(Set<CommandLineOption> primaryOptions) throws NullPointerException, IllegalArgumentException {
        super(NoPrimaryOptionException.buildErrorMessage(primaryOptions));
        this.primaryOptions = Set.copyOf(primaryOptions);
    }

    public NoPrimaryOptionException(String message) {
        super(message);
    }

    public Set<CommandLineOption> getPrimaryOptions() {
        return this.primaryOptions;
    }

    public static String buildErrorMessage(Set<CommandLineOption> primaryOptions) throws IllegalArgumentException {
        Objects.requireNonNull(primaryOptions, "The Set of primary options cannot be null");
        if (primaryOptions.size() == 0) {
            throw new IllegalArgumentException("There must be at least one primary option");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Must specify at least one of the following:");
        for (CommandLineOption option : primaryOptions) {
            if (!option.isPrimary()) {
                throw new IllegalArgumentException("At least one of the specified options in the set is NOT a primary option: " + option);
            }
            pw.println("     o " + option.getCommandLineFlag() + (option.isDeprecated() ? " (deprecated)" : ""));
        }
        pw.flush();
        return sw.toString();
    }
}

