/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.io;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.mozilla.universalchardet.UniversalDetector;

public class IOUtilities {
    public static final String UTF_8 = "UTF-8";
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");

    private IOUtilities() {
    }

    public static String readAsciiLine(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        int readCount = 0;
        int readByte = inputStream.read();
        while (readByte >= 0) {
            ++readCount;
            if (readByte == 10) break;
            sb.append((char)readByte);
            readByte = inputStream.read();
        }
        if (readCount == 0) {
            return null;
        }
        return sb.toString().trim();
    }

    public static void close(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    public static String readTextFileAsString(File file, String charEncoding) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readFully(Reader reader) throws IOException {
        try (BufferedReader br = new BufferedReader(reader);){
            StringBuilder sb = new StringBuilder();
            int nextChar = br.read();
            while (nextChar >= 0) {
                if (nextChar != 0) {
                    sb.append((char)nextChar);
                }
                nextChar = br.read();
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String detectCharacterEncoding(InputStream is) throws IOException {
        byte[] bytes;
        UniversalDetector detector = new UniversalDetector(null);
        int readCount = 0;
        byte[] buffer = new byte[50];
        int maxReadCount = 0xA00000;
        boolean allAscii = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int totalReadCount = 0; totalReadCount < maxReadCount && !detector.isDone() && (readCount = is.read(buffer)) >= 0; totalReadCount += readCount) {
            detector.handleData(buffer, 0, readCount);
            baos.write(buffer, 0, readCount);
        }
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        for (byte b : bytes = baos.toByteArray()) {
            if (b >= 0) continue;
            allAscii = false;
            break;
        }
        CharsetDetector cd = new CharsetDetector();
        cd.setText(bytes);
        CharsetMatch[] matches = cd.detectAll();
        if (matches == null) {
            return null;
        }
        if (matches.length == 0) {
            return null;
        }
        CharsetMatch bestMatch = null;
        for (CharsetMatch match : matches) {
            if (bestMatch == null) {
                bestMatch = match;
                if (!match.getName().toUpperCase().startsWith("UTF")) continue;
                break;
            }
            int c1 = bestMatch.getConfidence();
            int c2 = match.getConfidence();
            if (c2 < c1) break;
            if (!match.getName().toUpperCase().startsWith("UTF")) continue;
            bestMatch = match;
            break;
        }
        if (bestMatch == null && encoding != null) {
            return encoding;
        }
        if (bestMatch == null && allAscii) {
            return UTF_8;
        }
        if (bestMatch == null) {
            return null;
        }
        if (bestMatch.getConfidence() < 50 && allAscii) {
            return UTF_8;
        }
        return bestMatch.getName();
    }

    public static Reader bomSkippingReader(Reader src, String encoding) throws IOException, NullPointerException {
        if (encoding == null) {
            throw new NullPointerException("Cannot skip byte order mark without specifying the encoding.");
        }
        if (!encoding.toUpperCase().startsWith("UTF")) {
            return src;
        }
        PushbackReader result = new PushbackReader(src, 1);
        int first = result.read();
        if (first == -1) {
            return src;
        }
        if (first != 65279) {
            result.unread(first);
        }
        return result;
    }

    public static boolean createDirectoryIfMissing(File dir) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            return false;
        }
        if (dir.exists()) {
            throw new IOException("The named directory file exists, but is not a directory: " + dir);
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new IOException("Failed to create directory: " + dir);
        }
        return true;
    }

    public static int recursiveDeleteDirectory(File dir) throws IOException {
        final int[] failedCount = new int[]{0};
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException e) {
                if (e != null) {
                    return FileVisitResult.CONTINUE;
                }
                path.toFile().delete();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                boolean result = path.toFile().delete();
                if (!result) {
                    failedCount[0] = failedCount[0] + 1;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException e) {
                e.printStackTrace();
                return FileVisitResult.CONTINUE;
            }
        });
        try {
            Files.deleteIfExists(dir.toPath());
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        return failedCount[0];
    }

    public static boolean checkFilesDiffer(File file1, File file2) throws IOException {
        return IOUtilities.checkFilesDiffer(file1, file2, false);
    }

    /*
     * Exception decompiling
     */
    public static boolean checkFilesDiffer(File file1, File file2, boolean timestampSignificant) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[DOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long touchFile(File file) throws IOException {
        if (file.exists()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            file.createNewFile();
        }
        return file.lastModified();
    }

    public static InputStream nonClosingWrapper(InputStream inputStream) {
        return new NonClosingInputStream(inputStream);
    }

    public static OutputStream nonClosingWrapper(OutputStream outputStream) {
        return new NonClosingOutputStream(outputStream);
    }

    public static Reader nonClosingWrapper(Reader reader) {
        return new NonClosingReader(reader);
    }

    public static Writer nonClosingWrapper(Writer writer) {
        return new NonClosingWriter(writer);
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        private NonClosingInputStream(InputStream backingStream) {
            super(backingStream);
        }

        @Override
        public void close() {
        }
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        private NonClosingOutputStream(OutputStream backingStream) {
            super(backingStream);
        }

        @Override
        public void close() {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class NonClosingReader
    extends FilterReader {
        private NonClosingReader(Reader backingReader) {
            super(backingReader);
        }

        @Override
        public void close() {
        }
    }

    private static class NonClosingWriter
    extends FilterWriter {
        private NonClosingWriter(Writer backingWriter) {
            super(backingWriter);
        }

        @Override
        public void close() {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

