/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.io;

import com.senzing.io.IOUtilities;
import com.senzing.text.TextUtilities;
import com.senzing.util.LoggingUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TemporaryDataCache {
    private static final long FILE_PART_TIMEOUT = 500L;
    private static final SecureRandom PRNG = new SecureRandom();
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5PADDING";
    private static final String KEY_ALGORITHM = "AES";
    private static final boolean SYNC_FLUSH = true;
    private static final int FLUSH_THRESHOLD = 524288;
    private static final int MIN_CACHE_FILE_SIZE = 1024;
    private static final int MAX_CACHE_FILE_SIZE = 0x400000;
    private static final String DEFAULT_PREFIX = "sz-file-part-";
    private final List<CacheFilePart> fileParts = new LinkedList<CacheFilePart>();
    private String baseFileName;
    private File directory;
    private ConsumerThread consumerThread;
    private boolean deleted;
    private byte[] initVector;
    private byte[] aesKey;
    private IvParameterSpec ivSpec;
    private SecretKeySpec keySpec;
    private Exception failure = null;

    public TemporaryDataCache(InputStream sourceStream) throws IOException {
        this(sourceStream, null, null);
    }

    public TemporaryDataCache(InputStream sourceStream, File directory) throws IOException {
        this(sourceStream, directory, null);
    }

    public TemporaryDataCache(InputStream sourceStream, File directory, String fileNamePrefix) throws IOException {
        if (fileNamePrefix == null) {
            fileNamePrefix = DEFAULT_PREFIX;
        }
        File tempFile = null;
        if (directory == null) {
            tempFile = File.createTempFile((String)fileNamePrefix, "-0.dat");
            directory = tempFile.getParentFile();
        } else {
            tempFile = File.createTempFile((String)fileNamePrefix, "-0.dat", directory);
        }
        String fileName = tempFile.getName();
        int length = fileName.length();
        fileNamePrefix = fileName.substring(0, length - "-0.dat".length());
        if (((String)fileNamePrefix).endsWith("-")) {
            fileNamePrefix = (String)fileNamePrefix + "-";
        }
        this.aesKey = TextUtilities.randomPrintableText(16).getBytes("UTF-8");
        this.initVector = TextUtilities.randomPrintableText(16).getBytes("UTF-8");
        this.keySpec = new SecretKeySpec(this.aesKey, KEY_ALGORITHM);
        this.ivSpec = new IvParameterSpec(this.initVector);
        this.baseFileName = fileNamePrefix;
        this.directory = directory;
        this.deleted = false;
        this.consumerThread = new ConsumerThread(sourceStream);
        this.consumerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete() {
        int count = 0;
        List<CacheFilePart> list = this.fileParts;
        synchronized (list) {
            for (CacheFilePart filePart : this.fileParts) {
                if (!filePart.file.delete()) continue;
                ++count;
            }
            this.fileParts.clear();
            this.deleted = true;
            this.fileParts.notifyAll();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeleted() {
        List<CacheFilePart> list = this.fileParts;
        synchronized (list) {
            return this.deleted;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppending() {
        List<CacheFilePart> list = this.fileParts;
        synchronized (list) {
            return this.consumerThread.isAlive() && this.consumerThread.isAppending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAppendingComplete() throws InterruptedException {
        while (this.consumerThread.isAlive()) {
            List<CacheFilePart> list = this.fileParts;
            synchronized (list) {
                this.fileParts.wait(2000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFailure(Exception e) {
        List<CacheFilePart> list = this.fileParts;
        synchronized (list) {
            this.failure = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFailure() throws RuntimeException {
        List<CacheFilePart> list = this.fileParts;
        synchronized (list) {
            if (this.failure != null) {
                throw new RuntimeException(this.failure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilAppendingComplete(long maxWait) throws InterruptedException {
        long startWait;
        long endWait;
        if (maxWait <= 0L) {
            this.waitUntilAppendingComplete();
            return true;
        }
        for (long remaining = maxWait; this.consumerThread.isAlive() && remaining > 0L; remaining -= endWait - startWait) {
            List<CacheFilePart> list = this.fileParts;
            synchronized (list) {
                startWait = System.currentTimeMillis();
                this.fileParts.wait(remaining < 2000L ? remaining : 2000L);
                endWait = System.currentTimeMillis();
                continue;
            }
        }
        return !this.consumerThread.isAlive();
    }

    public InputStream getInputStream() {
        return this.getInputStream(false);
    }

    public InputStream getInputStream(boolean consume) {
        return new ChainFileInputStream(consume);
    }

    private class ConsumerThread
    extends Thread {
        private InputStream sourceStream;
        private boolean appending = true;

        public ConsumerThread(InputStream sourceStream) {
            this.sourceStream = sourceStream;
            this.appending = true;
        }

        public synchronized boolean isAppending() {
            return this.appending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                TemporaryDataCache owner = TemporaryDataCache.this;
                InputStream is = this.sourceStream;
                FilePartSink sink = new FilePartSink();
                sink.start();
                int byteCount = 0;
                try (BufferedInputStream bis = new BufferedInputStream(is, 8192);){
                    int readByte = 0;
                    readByte = ((InputStream)bis).read();
                    while (readByte >= 0 && !owner.isDeleted()) {
                        sink.writeByte((byte)readByte);
                        ++byteCount;
                        readByte = ((InputStream)bis).read();
                    }
                    sink.close();
                    if (readByte >= 0) break block12;
                    ConsumerThread consumerThread = this;
                    synchronized (consumerThread) {
                        this.appending = false;
                    }
                }
                catch (RuntimeException e) {
                    owner.setFailure(e);
                    throw e;
                }
                catch (Exception e) {
                    owner.setFailure(e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class CacheFilePart
    implements Comparable<CacheFilePart> {
        private final File file;
        private final long offset;
        private final long length;

        CacheFilePart(File file, long offset, long length) {
            this.file = file;
            this.offset = offset;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheFilePart filePart = (CacheFilePart)o;
            return this.offset == filePart.offset && this.length == filePart.length;
        }

        public int hashCode() {
            return (int)(this.offset ^ this.length);
        }

        @Override
        public int compareTo(CacheFilePart p) {
            if (this.offset == p.offset) {
                if (this.length == p.length) {
                    return 0;
                }
                return this.length < p.length ? -1 : 1;
            }
            return this.offset < p.offset ? -1 : 1;
        }
    }

    private class ChainFileInputStream
    extends InputStream {
        private boolean consuming;
        private boolean eof;
        private boolean closed;
        private int currentFileIndex;
        private InputStream currentIS;
        private CacheFilePart currentFilePart;
        private long currentOffset;

        private ChainFileInputStream(boolean consuming) {
            this.consuming = consuming;
            this.eof = false;
            this.closed = false;
            this.currentIS = null;
            this.currentFilePart = null;
            this.currentFileIndex = 0;
            this.currentOffset = 0L;
        }

        private void closeInputStream() throws IOException {
            if (this.currentIS != null) {
                this.currentIS.close();
                this.currentIS = null;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closeInputStream();
            this.currentFilePart = null;
            this.currentFileIndex = -1;
            this.eof = true;
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            TemporaryDataCache owner = TemporaryDataCache.this;
            owner.checkFailure();
            if (this.closed) {
                throw new IOException("Cannot skip: stream already closed.");
            }
            if (n < 0L) {
                return 0L;
            }
            if (this.eof) {
                return 0L;
            }
            long totalSkipped = 0L;
            long remainingSkip = n;
            while (remainingSkip > 0L) {
                while (this.currentFilePart == null) {
                    List<CacheFilePart> list = owner.fileParts;
                    synchronized (list) {
                        if (owner.isDeleted()) {
                            this.closeInputStream();
                            throw new IOException("Cannot skip: Backing files deleted");
                        }
                        if (owner.fileParts.size() > this.currentFileIndex) {
                            this.attachStream();
                        } else if (owner.isAppending()) {
                            try {
                                owner.fileParts.wait(5000L);
                            }
                            catch (InterruptedException e) {
                                throw new IOException("Interrupted while waiting for an available file.", e);
                            }
                        } else {
                            return totalSkipped;
                        }
                    }
                }
                long remaining = this.currentFilePart.length - this.currentOffset;
                if (remainingSkip < remaining) {
                    long skipped = this.currentIS.skip(remainingSkip);
                    totalSkipped += skipped;
                    remainingSkip -= skipped;
                    this.currentOffset += skipped;
                    continue;
                }
                totalSkipped += remaining;
                remainingSkip -= remaining;
                this.advanceFile();
            }
            return totalSkipped;
        }

        private void advanceFile() throws IOException {
            if (this.consuming && this.currentFilePart != null) {
                this.currentFilePart.file.delete();
            }
            this.currentFilePart = null;
            ++this.currentFileIndex;
            if (this.currentIS != null) {
                this.currentIS.close();
                this.currentIS = null;
            }
            this.currentOffset = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attachStream() throws IOException {
            try {
                TemporaryDataCache owner = TemporaryDataCache.this;
                Cipher cipher = Cipher.getInstance(TemporaryDataCache.CIPHER_ALGORITHM);
                cipher.init(2, (Key)owner.keySpec, owner.ivSpec);
                List<CacheFilePart> list = owner.fileParts;
                synchronized (list) {
                    this.currentFilePart = owner.fileParts.get(this.currentFileIndex);
                    if (LoggingUtilities.isDebugLogging()) {
                        File filePart = this.currentFilePart.file;
                        Cipher tmpCipher = Cipher.getInstance(TemporaryDataCache.CIPHER_ALGORITHM);
                        tmpCipher.init(2, (Key)owner.keySpec, owner.ivSpec);
                        try (FileInputStream fis = new FileInputStream(filePart);
                             CipherInputStream cis = new CipherInputStream(fis, tmpCipher);
                             GZIPInputStream gis = new GZIPInputStream(cis);
                             InputStreamReader isr = new InputStreamReader((InputStream)gis, "UTF-8");){
                            char[] buffer = new char[2048];
                            StringBuilder sb = new StringBuilder();
                            int readCount = isr.read(buffer);
                            while (readCount >= 0) {
                                sb.append(buffer, 0, readCount);
                                if (sb.length() >= buffer.length * 2) break;
                                readCount = isr.read(buffer);
                            }
                            boolean truncated = isr.read() >= 0;
                            LoggingUtilities.debugLog("Reading file part " + this.currentFileIndex + ": " + filePart, truncated ? "CONTENTS:" : "PREVIEW", "-------------------------------------", sb.toString(), "-------------------------------------");
                        }
                    }
                    this.currentIS = new BufferedInputStream(new FileInputStream(this.currentFilePart.file), 8192);
                    try {
                        this.currentIS = new CipherInputStream(this.currentIS, cipher);
                        this.currentIS = new GZIPInputStream(this.currentIS);
                    }
                    catch (IOException e) {
                        this.currentIS.close();
                        this.currentIS = null;
                        throw e;
                    }
                    catch (Exception e) {
                        this.currentIS.close();
                        this.currentIS = null;
                        throw new IOException(e);
                    }
                    this.currentOffset = 0L;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Failed decryption of backing file", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            int byteRead;
            TemporaryDataCache owner = TemporaryDataCache.this;
            owner.checkFailure();
            if (this.closed) {
                throw new IOException("Cannot read: stream already closed.");
            }
            if (this.eof) {
                return -1;
            }
            String prefix = System.identityHashCode(this) + ": ";
            if (this.currentFilePart == null || this.currentFilePart.length - this.currentOffset <= 0L) {
                if (this.currentFilePart != null) {
                    this.advanceFile();
                }
                while (this.currentFilePart == null) {
                    List<CacheFilePart> list = owner.fileParts;
                    synchronized (list) {
                        if (owner.isDeleted()) {
                            this.closeInputStream();
                            throw new IOException("Cannot read: Backing files deleted");
                        }
                        if (owner.fileParts.size() > this.currentFileIndex) {
                            this.attachStream();
                        } else if (owner.isAppending()) {
                            try {
                                long start = System.currentTimeMillis();
                                owner.fileParts.wait(5000L);
                            }
                            catch (InterruptedException e) {
                                throw new IOException("Interrupted while waiting for an available file.", e);
                            }
                        } else {
                            this.eof = true;
                            if (this.consuming) {
                                owner.delete();
                            }
                            return -1;
                        }
                    }
                }
            }
            if ((long)(byteRead = this.currentIS.read()) < 0L) {
                throw new IOException("Unexpected EOF from backing input stream.  offset=[ " + this.currentOffset + " ], fileSize=[ " + this.currentFilePart.length + " ]");
            }
            ++this.currentOffset;
            return byteRead;
        }
    }

    private class FilePartSink
    extends Thread {
        private File currentFile = null;
        private FileOutputStream currentFOS = null;
        private CipherOutputStream currentCOS = null;
        private GZIPOutputStream currentGOS = null;
        private int currentOffset = 0;
        private int currentWriteCount = 0;
        private int totalWriteCount = 0;
        private long lastWriteTime = -1L;
        private boolean closed = false;
        private int partIndex = 0;
        private int maxPartLength = 1024;

        private FilePartSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            TemporaryDataCache owner = TemporaryDataCache.this;
            List<CacheFilePart> list = owner.fileParts;
            synchronized (list) {
                this.closed = true;
                this.completeCurrentFilePart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isClosed() {
            TemporaryDataCache owner = TemporaryDataCache.this;
            List<CacheFilePart> list = owner.fileParts;
            synchronized (list) {
                return this.closed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeCurrentFilePart() {
            TemporaryDataCache owner = TemporaryDataCache.this;
            List<CacheFilePart> list = owner.fileParts;
            synchronized (list) {
                try {
                    File completedFile = null;
                    int completedLength = 0;
                    int completedOffset = 0;
                    if (this.currentFOS == null || this.currentCOS == null || this.currentGOS == null || this.currentFile == null) {
                        return;
                    }
                    completedFile = this.currentFile;
                    completedOffset = this.currentOffset;
                    completedLength = this.currentWriteCount;
                    if (this.currentWriteCount > 0) {
                        this.currentGOS.flush();
                        this.currentGOS.finish();
                        this.currentGOS.flush();
                        this.currentCOS.flush();
                    }
                    IOUtilities.close(this.currentGOS);
                    IOUtilities.close(this.currentCOS);
                    IOUtilities.close(this.currentFOS);
                    LoggingUtilities.debugLog("Completed file part: " + this.currentFile + " (" + this.currentWriteCount + " bytes / " + this.currentFile.length() + " compressed)");
                    this.currentGOS = null;
                    this.currentCOS = null;
                    this.currentFOS = null;
                    this.currentFile = null;
                    this.currentOffset = 0;
                    this.currentWriteCount = 0;
                    this.lastWriteTime = -1L;
                    ++this.partIndex;
                    if (completedLength > 0) {
                        this.maxPartLength *= 16;
                        if (this.maxPartLength > 0x400000) {
                            this.maxPartLength = 0x400000;
                        }
                    }
                    if (completedLength > 0 && !owner.isDeleted()) {
                        CacheFilePart cfp = new CacheFilePart(completedFile, completedOffset, completedLength);
                        owner.fileParts.add(cfp);
                        owner.fileParts.notifyAll();
                    }
                }
                catch (IOException e) {
                    owner.setFailure(e);
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void beginNextFilePart() {
            TemporaryDataCache owner = TemporaryDataCache.this;
            int gzSize = 532480;
            boolean syncFlush = true;
            List<CacheFilePart> list = owner.fileParts;
            synchronized (list) {
                try {
                    if (this.currentFOS != null || this.currentCOS != null || this.currentGOS != null || this.currentFile != null) {
                        throw new IllegalStateException("A current file is already open.");
                    }
                    File directory = owner.directory;
                    String baseFileName = owner.baseFileName;
                    String fileName = baseFileName + "-" + this.partIndex + ".dat";
                    Cipher cipher = Cipher.getInstance(TemporaryDataCache.CIPHER_ALGORITHM);
                    cipher.init(1, (Key)owner.keySpec, owner.ivSpec);
                    this.currentOffset = this.totalWriteCount;
                    this.currentWriteCount = 0;
                    this.lastWriteTime = System.nanoTime();
                    this.currentFile = new File(directory, fileName);
                    this.currentFOS = new FileOutputStream(this.currentFile);
                    this.currentCOS = new CipherOutputStream(this.currentFOS, cipher);
                    this.currentGOS = new GZIPOutputStream((OutputStream)this.currentCOS, 532480, true);
                    this.currentFile.deleteOnExit();
                    LoggingUtilities.debugLog("Beginning file part: " + this.currentFile);
                }
                catch (RuntimeException e) {
                    owner.setFailure(e);
                    throw e;
                }
                catch (Exception e) {
                    owner.setFailure(e);
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeByte(byte data) throws IOException {
            TemporaryDataCache owner = TemporaryDataCache.this;
            List<CacheFilePart> list = owner.fileParts;
            synchronized (list) {
                double countLog10;
                int logInterval;
                if (this.closed) {
                    throw new IllegalStateException("Sink thread is already shutdown");
                }
                if (this.currentGOS == null) {
                    this.beginNextFilePart();
                }
                this.currentGOS.write(data);
                ++this.totalWriteCount;
                ++this.currentWriteCount;
                this.lastWriteTime = System.nanoTime();
                if (LoggingUtilities.isDebugLogging() && this.currentWriteCount % (logInterval = (int)Math.max(100.0, Math.pow(10.0, countLog10 = Math.floor(Math.log10(this.currentWriteCount))) * Math.max(1.0, countLog10 - 1.0))) == 0) {
                    LoggingUtilities.debugLog("Bytes written to file: " + this.currentFile + " (" + this.currentWriteCount + " current part / " + this.totalWriteCount + " total bytes)");
                }
                if (this.currentWriteCount >= this.maxPartLength) {
                    this.completeCurrentFilePart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TemporaryDataCache owner = TemporaryDataCache.this;
            long waitTime = 500L;
            while (!this.isClosed()) {
                List<CacheFilePart> list = owner.fileParts;
                synchronized (list) {
                    try {
                        owner.fileParts.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.isClosed()) {
                        long now = System.nanoTime();
                        if (this.lastWriteTime > 0L && this.currentWriteCount > 0) {
                            long duration = (now - this.lastWriteTime) / 1000000L;
                            if (duration >= 500L) {
                                this.completeCurrentFilePart();
                                waitTime = 500L;
                            } else {
                                waitTime = 500L - duration;
                            }
                        }
                    }
                }
            }
        }
    }
}

