/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.reflect;

import com.senzing.reflect.ReflectionUtilities;
import com.senzing.util.CollectionUtilities;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class PropertyReflector<T> {
    private static final Map<Class, PropertyReflector> REFLECTOR_INSTANCES = new HashMap<Class, PropertyReflector>();
    private Map<String, Method> accessors = new LinkedHashMap<String, Method>();
    private Map<String, List<Method>> mutators = new LinkedHashMap<String, List<Method>>();

    public static synchronized <T> PropertyReflector<T> getInstance(Class<T> cls) {
        PropertyReflector<T> result = REFLECTOR_INSTANCES.get(cls);
        if (result == null) {
            result = new PropertyReflector<T>(cls);
            REFLECTOR_INSTANCES.put(cls, result);
        }
        return result;
    }

    protected PropertyReflector(Class<T> cls) {
        Method[] methods;
        for (Method method : methods = cls.getMethods()) {
            List<Method> methodList;
            Object key;
            int modifiers;
            if (method.getDeclaringClass() == Object.class || Modifier.isStatic(modifiers = method.getModifiers()) || !Modifier.isPublic(modifiers)) continue;
            String name = method.getName();
            if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3)) && method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE) {
                key = name.substring(3, 4).toLowerCase();
                if (name.length() > 4) {
                    key = (String)key + name.substring(4);
                }
                this.accessors.put((String)key, method);
                continue;
            }
            if (name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2)) && method.getParameterCount() == 0 && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                key = name.substring(2, 3).toLowerCase();
                if (name.length() > 3) {
                    key = (String)key + name.substring(3);
                }
                this.accessors.put((String)key, method);
                continue;
            }
            if (name.length() <= 3 || !name.startsWith("set") || !Character.isUpperCase(name.charAt(3)) || method.getParameterCount() != 1 || method.getReturnType() != Void.TYPE) continue;
            key = name.substring(3, 4).toLowerCase();
            if (name.length() > 4) {
                key = (String)key + name.substring(4);
            }
            if ((methodList = this.mutators.get(key)) == null) {
                methodList = new LinkedList<Method>();
                this.mutators.put((String)key, methodList);
            }
            methodList.add(method);
        }
        this.accessors = Collections.unmodifiableMap(this.accessors);
        this.mutators = CollectionUtilities.recursivelyUnmodifiableMap(this.mutators);
    }

    public Map<String, Method> getAccessors() {
        return this.accessors;
    }

    public Map<String, List<Method>> getMutators() {
        return this.mutators;
    }

    public Object getPropertyValue(T target, String propertyKey) throws IllegalArgumentException {
        Map<String, Method> accessorMap = this.getAccessors();
        Method method = accessorMap.get(propertyKey);
        if (method == null) {
            if (this.getMutators().containsKey(propertyKey)) {
                throw new UnsupportedOperationException("The specified property is write-only: " + propertyKey);
            }
            throw new IllegalArgumentException("Unrecognized property key: " + propertyKey);
        }
        try {
            return method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPropertyValue(T target, String propertyKey, Object propertyValue) throws IllegalArgumentException {
        Map<String, List<Method>> mutatorMap = this.getMutators();
        List<Method> methods = mutatorMap.get(propertyKey);
        boolean invoked = false;
        if (methods == null) {
            if (this.getAccessors().containsKey(propertyKey)) {
                throw new UnsupportedOperationException("The specified property is read-only: " + propertyKey);
            }
            throw new IllegalArgumentException("Unrecognized property key: " + propertyKey);
        }
        if (propertyValue == null) {
            invoked = PropertyReflector.findAndInvokeMutator(methods, Class::isPrimitive, target, null);
            if (invoked) {
                return;
            }
            throw new NullPointerException("The specified value for the property (" + propertyKey + ") cannot be null.");
        }
        Class<?> valueType = propertyValue.getClass();
        invoked = PropertyReflector.findAndInvokeMutator(methods, argType -> argType == valueType, target, propertyValue);
        if (invoked) {
            return;
        }
        Class primType = ReflectionUtilities.getPrimitiveType(valueType);
        if (primType != null && primType != valueType && (invoked = PropertyReflector.findAndInvokeMutator(methods, argType -> argType == primType, target, propertyValue))) {
            return;
        }
        invoked = PropertyReflector.findAndInvokeMutator(methods, argType -> argType.isAssignableFrom(valueType), target, propertyValue);
        if (invoked) {
            return;
        }
        if (propertyValue == null) {
            throw new NullPointerException("The specified value for the property (" + propertyKey + ") cannot be null.");
        }
        throw new ClassCastException("The specified value for the property (" + propertyKey + ") was not of a valid type: " + propertyValue.getClass().getName());
    }

    private static boolean findAndInvokeMutator(List<Method> methods, Predicate<Class> predicate, Object target, Object propertyValue) {
        for (Method method : methods) {
            Class<?> argType = method.getParameterTypes()[0];
            if (!predicate.test(argType)) continue;
            try {
                method.invoke(target, propertyValue);
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static JsonObject toJsonObject(Object object) throws NullPointerException {
        Objects.requireNonNull("The specified object cannot be null");
        JsonObjectBuilder job = Json.createObjectBuilder();
        return PropertyReflector.buildJsonObject(job, object).build();
    }

    public static JsonObjectBuilder buildJsonObject(JsonObjectBuilder builder, Object object) throws NullPointerException {
        Objects.requireNonNull(builder, "The specified JsonObjectBuilder cannot be null");
        Objects.requireNonNull(object, "The specified object cannot be null");
        IdentityHashMap visitedMap = new IdentityHashMap();
        return PropertyReflector.buildJsonObject(visitedMap, builder, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObjectBuilder buildJsonObject(IdentityHashMap visited, JsonObjectBuilder builder, Object object) throws NullPointerException {
        if (visited.containsKey(object)) {
            throw new IllegalStateException("Circular reference detected for object: " + object);
        }
        visited.put(object, null);
        try {
            Map<String, ?> objectMap = PropertyReflector.getObjectMap(object);
            PropertyReflector<?> reflector = null;
            Map<String, Method> accessors = null;
            Set<String> keySet = null;
            if (objectMap == null) {
                Class<?> cls = object.getClass();
                reflector = PropertyReflector.getInstance(cls);
                accessors = reflector.getAccessors();
                keySet = accessors.keySet();
            } else {
                keySet = objectMap.keySet();
            }
            block27: for (String propertyKey : keySet) {
                JsonArrayBuilder jab;
                Object propertyValue;
                Object object2 = propertyValue = objectMap != null ? objectMap.get(propertyKey) : reflector.getPropertyValue(object, propertyKey);
                if (propertyValue == null) {
                    builder.addNull(propertyKey);
                    continue;
                }
                Class propertyType = propertyValue.getClass();
                if (propertyType.isPrimitive()) {
                    propertyType = ReflectionUtilities.getPromotedType(propertyType);
                }
                switch (propertyType.getName()) {
                    case "javax.json.JsonObject": {
                        JsonObject jsonObj = (JsonObject)propertyValue;
                        builder.add(propertyKey, Json.createObjectBuilder((JsonObject)jsonObj));
                        continue block27;
                    }
                    case "javax.json.JsonArray": {
                        JsonArray jsonArr = (JsonArray)propertyValue;
                        builder.add(propertyKey, Json.createArrayBuilder((JsonArray)jsonArr));
                        continue block27;
                    }
                    case "java.lang.Integer": 
                    case "java.lang.Short": {
                        builder.add(propertyKey, ((Number)propertyValue).intValue());
                        continue block27;
                    }
                    case "java.lang.Long": {
                        builder.add(propertyKey, ((Number)propertyValue).longValue());
                        continue block27;
                    }
                    case "java.lang.String": {
                        builder.add(propertyKey, propertyValue.toString());
                        continue block27;
                    }
                    case "java.lang.Double": 
                    case "java.lang.Float": {
                        builder.add(propertyKey, ((Number)propertyValue).doubleValue());
                        continue block27;
                    }
                    case "java.lang.Boolean": {
                        builder.add(propertyKey, ((Boolean)propertyValue).booleanValue());
                        continue block27;
                    }
                    case "java.math.BigDecimal": {
                        builder.add(propertyKey, (BigDecimal)propertyValue);
                        continue block27;
                    }
                    case "java.math.BigInteger": {
                        builder.add(propertyKey, (BigInteger)propertyValue);
                        continue block27;
                    }
                }
                if (Collection.class.isAssignableFrom(propertyType)) {
                    jab = Json.createArrayBuilder();
                    Collection collection = (Collection)propertyValue;
                    for (Object elem : collection) {
                        PropertyReflector.addToJsonArray(visited, jab, elem);
                    }
                    builder.add(propertyKey, jab);
                    continue;
                }
                if (propertyType.isArray()) {
                    jab = Json.createArrayBuilder();
                    int length = Array.getLength(propertyValue);
                    for (int index = 0; index < length; ++index) {
                        Object elem;
                        elem = Array.get(propertyValue, index);
                        PropertyReflector.addToJsonArray(visited, jab, elem);
                    }
                    builder.add(propertyKey, jab);
                    continue;
                }
                JsonObjectBuilder job = Json.createObjectBuilder();
                builder.add(propertyKey, PropertyReflector.buildJsonObject(visited, job, propertyValue));
            }
            JsonObjectBuilder jsonObjectBuilder = builder;
            return jsonObjectBuilder;
        }
        finally {
            visited.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonArrayBuilder addToJsonArray(IdentityHashMap visited, JsonArrayBuilder builder, Object value) {
        if (value == null) {
            builder.addNull();
            return builder;
        }
        if (visited.containsKey(value)) {
            throw new IllegalStateException("Circular reference detected for object: " + value);
        }
        visited.put(value, null);
        try {
            Class valueType = value.getClass();
            if (valueType.isPrimitive()) {
                valueType = ReflectionUtilities.getPromotedType(valueType);
            }
            switch (valueType.getName()) {
                case "javax.json.JsonObject": {
                    JsonObject jsonObj = (JsonObject)value;
                    builder.add(Json.createObjectBuilder((JsonObject)jsonObj));
                    break;
                }
                case "javax.json.JsonArray": {
                    JsonArray jsonArr = (JsonArray)value;
                    builder.add(Json.createArrayBuilder((JsonArray)jsonArr));
                    break;
                }
                case "java.lang.Integer": 
                case "java.lang.Short": {
                    builder.add(((Number)value).intValue());
                    break;
                }
                case "java.lang.Long": {
                    builder.add(((Number)value).longValue());
                    break;
                }
                case "java.lang.String": {
                    builder.add(value.toString());
                    break;
                }
                case "java.lang.Double": 
                case "java.lang.Float": {
                    builder.add(((Number)value).doubleValue());
                    break;
                }
                case "java.lang.Boolean": {
                    builder.add(((Boolean)value).booleanValue());
                    break;
                }
                case "java.math.BigDecimal": {
                    builder.add((BigDecimal)value);
                    break;
                }
                case "java.math.BigInteger": {
                    builder.add((BigInteger)value);
                    break;
                }
                default: {
                    if (Collection.class.isAssignableFrom(valueType)) {
                        JsonArrayBuilder jab = Json.createArrayBuilder();
                        Collection collection = (Collection)value;
                        for (Object elem : collection) {
                            PropertyReflector.addToJsonArray(visited, jab, elem);
                        }
                        builder.add(jab);
                        break;
                    }
                    if (valueType.isArray()) {
                        JsonArrayBuilder jab = Json.createArrayBuilder();
                        int length = Array.getLength(value);
                        for (int index = 0; index < length; ++index) {
                            Object elem = Array.get(value, index);
                            PropertyReflector.addToJsonArray(visited, jab, elem);
                        }
                        builder.add(jab);
                        break;
                    }
                    JsonObjectBuilder job = Json.createObjectBuilder();
                    visited.remove(value);
                    try {
                        builder.add(PropertyReflector.buildJsonObject(visited, job, value));
                        break;
                    }
                    finally {
                        visited.put(value, null);
                    }
                }
            }
            String string = builder;
            return string;
        }
        finally {
            visited.remove(value);
        }
    }

    private static Map<String, ?> getObjectMap(Object object) {
        if (!(object instanceof Map)) {
            return null;
        }
        Map map = (Map)object;
        for (Object key : map.keySet()) {
            if (key instanceof String) continue;
            return null;
        }
        return map;
    }
}

