/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ReflectionUtilities {
    private static final Map<Class, Class> PROMOTED_TYPE_MAP;
    private static final Map<Class, Class> PRIMITIVE_TYPE_MAP;

    public static Class getPrimitiveType(Class promotedType) {
        return PRIMITIVE_TYPE_MAP.get(promotedType);
    }

    public static Class getPromotedType(Class primitiveType) {
        return PROMOTED_TYPE_MAP.get(primitiveType);
    }

    public static Number convertPrimitiveNumber(Number value, Class numType) {
        Objects.requireNonNull(numType, "Number type cannot be null");
        if (numType.isPrimitive()) {
            numType = ReflectionUtilities.getPromotedType(numType);
        }
        if (!Number.class.isAssignableFrom(numType) || ReflectionUtilities.getPrimitiveType(numType) == null) {
            throw new IllegalArgumentException("The specified target number type must extend java.lang.Number and have a corresponding primitive numeric type: " + numType.getName());
        }
        if (value == null) {
            return null;
        }
        numType = ReflectionUtilities.getPromotedType(numType);
        switch (numType.getName()) {
            case "java.lang.Byte": {
                return value.byteValue();
            }
            case "java.lang.Short": {
                return value.shortValue();
            }
            case "java.lang.Integer": {
                return value.intValue();
            }
            case "java.lang.Long": {
                return value.longValue();
            }
            case "java.lang.Float": {
                return Float.valueOf(value.floatValue());
            }
            case "java.lang.Double": {
                return value.doubleValue();
            }
        }
        throw new IllegalStateException("Unable to convert to target number type: " + numType);
    }

    public static <I, T extends I> I synchronizedProxy(Class<I> proxyInterface, T targetObject) {
        return ReflectionUtilities.synchronizedProxy(proxyInterface, targetObject, null);
    }

    public static <I, T extends I> I synchronizedProxy(Class<I> proxyInterface, T targetObject, Object monitor) {
        Objects.requireNonNull(proxyInterface, "The proxy interface cannot be null.");
        Objects.requireNonNull(targetObject, "The specified target object cannot be null.");
        if (!proxyInterface.isInterface()) {
            throw new IllegalArgumentException("The specified proxy class is not an interface: " + proxyInterface.getName());
        }
        if (!proxyInterface.isAssignableFrom(targetObject.getClass())) {
            throw new IllegalArgumentException("The specified target object does not implement the specified proxy interface.  proxyInterface=[ " + proxyInterface.getName() + " ], targetObjectClass=[ " + targetObject.getClass().getName() + " ]");
        }
        ClassLoader classLoader = targetObject.getClass().getClassLoader();
        Class[] interfaces = new Class[]{proxyInterface};
        SynchronizedHandler handler = new SynchronizedHandler(targetObject, monitor);
        return (I)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }

    static {
        LinkedHashMap primitiveMap = new LinkedHashMap();
        LinkedHashMap<Class, Class> promotedMap = new LinkedHashMap<Class, Class>();
        try {
            promotedMap.put(Void.TYPE, Void.class);
            promotedMap.put(Boolean.TYPE, Boolean.class);
            promotedMap.put(Character.TYPE, Character.class);
            promotedMap.put(Byte.TYPE, Byte.class);
            promotedMap.put(Short.TYPE, Short.class);
            promotedMap.put(Integer.TYPE, Integer.class);
            promotedMap.put(Long.TYPE, Long.class);
            promotedMap.put(Float.TYPE, Float.class);
            promotedMap.put(Double.TYPE, Double.class);
            promotedMap.forEach((primitive, promoted) -> primitiveMap.put(promoted, primitive));
            promotedMap.keySet().forEach(primitive -> primitiveMap.put(primitive, primitive));
            primitiveMap.keySet().forEach(keyType -> {
                if (!keyType.isPrimitive()) {
                    promotedMap.put((Class)keyType, (Class)keyType);
                }
            });
        }
        finally {
            PROMOTED_TYPE_MAP = Collections.unmodifiableMap(promotedMap);
            PRIMITIVE_TYPE_MAP = Collections.unmodifiableMap(primitiveMap);
        }
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private Object target;
        private Object monitor = null;

        public SynchronizedHandler(Object target) {
            this(target, null);
        }

        public SynchronizedHandler(Object target, Object monitor) {
            this.target = target;
            this.monitor = monitor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Object monitor;
            Object object = monitor = this.monitor == null ? proxy : this.monitor;
            synchronized (object) {
                try {
                    return method.invoke(this.target, args);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

